/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private ArrayList<JsonValue> valueList;
    private final BufferPool bufferPool;

    JsonArrayBuilderImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonArrayBuilder add(JsonValue value) {
        this.validateValue(value);
        this.addValueList(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value) {
        this.validateValue(value);
        this.addValueList(new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value) {
        this.validateValue(value);
        this.addValueList(JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value) {
        this.validateValue(value);
        this.addValueList(JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value) {
        this.addValueList(JsonNumberImpl.getJsonNumber(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value) {
        this.addValueList(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.addValueList(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList(builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_ARRAY_BUILDER_NULL());
        }
        this.addValueList(builder.build());
        return this;
    }

    @Override
    public JsonArray build() {
        List<Object> snapshot = this.valueList == null ? Collections.emptyList() : Collections.unmodifiableList(this.valueList);
        this.valueList = null;
        return new JsonArrayImpl(snapshot, this.bufferPool);
    }

    private void addValueList(JsonValue value) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(value);
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;
        private final BufferPool bufferPool;

        JsonArrayImpl(List<JsonValue> valueList, BufferPool bufferPool) {
            this.valueList = valueList;
            this.bufferPool = bufferPool;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        @Override
        public JsonObject getJsonObject(int index) {
            return (JsonObject)this.valueList.get(index);
        }

        @Override
        public JsonArray getJsonArray(int index) {
            return (JsonArray)this.valueList.get(index);
        }

        @Override
        public JsonNumber getJsonNumber(int index) {
            return (JsonNumber)this.valueList.get(index);
        }

        @Override
        public JsonString getJsonString(int index) {
            return (JsonString)this.valueList.get(index);
        }

        @Override
        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        @Override
        public String getString(int index) {
            return this.getJsonString(index).getString();
        }

        @Override
        public String getString(int index, String defaultValue) {
            try {
                return this.getString(index);
            }
            catch (Exception e2) {
                return defaultValue;
            }
        }

        @Override
        public int getInt(int index) {
            return this.getJsonNumber(index).intValue();
        }

        @Override
        public int getInt(int index, int defaultValue) {
            try {
                return this.getInt(index);
            }
            catch (Exception e2) {
                return defaultValue;
            }
        }

        @Override
        public boolean getBoolean(int index) {
            JsonValue jsonValue = this.get(index);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(int index, boolean defaultValue) {
            try {
                return this.getBoolean(index);
            }
            catch (Exception e2) {
                return defaultValue;
            }
        }

        @Override
        public boolean isNull(int index) {
            return this.valueList.get(index).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index) {
            return this.valueList.get(index);
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw, this.bufferPool);
            jw.write(this);
            jw.close();
            return sw.toString();
        }
    }
}

