/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.STWriter;

public class AutoIndentWriter
implements STWriter {
    public List<String> indents = new ArrayList<String>();
    public int[] anchors = new int[10];
    public int anchors_sp = -1;
    public String newline;
    public Writer out = null;
    public boolean atStartOfLine = true;
    public int charPosition = 0;
    public int charIndex = 0;
    public int lineWidth = -1;

    public AutoIndentWriter(Writer out, String newline) {
        this.out = out;
        this.indents.add(null);
        this.newline = newline;
    }

    public AutoIndentWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void pushIndentation(String indent) {
        this.indents.add(indent);
    }

    public String popIndentation() {
        return this.indents.remove(this.indents.size() - 1);
    }

    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] a2 = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, a2, 0, this.anchors.length - 1);
            this.anchors = a2;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    public int index() {
        return this.charIndex;
    }

    public int write(String str) throws IOException {
        int n2 = 0;
        int nll = this.newline.length();
        int sl = str.length();
        for (int i2 = 0; i2 < sl; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 == '\r') continue;
            if (c2 == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -nll;
                this.out.write(this.newline);
                this.charIndex += nll;
                this.charPosition += (n2 += nll);
                continue;
            }
            if (this.atStartOfLine) {
                n2 += this.indent();
                this.atStartOfLine = false;
            }
            ++n2;
            this.out.write(c2);
            ++this.charPosition;
            ++this.charIndex;
        }
        return n2;
    }

    public int writeSeparator(String str) throws IOException {
        return this.write(str);
    }

    public int write(String str, String wrap) throws IOException {
        int n2 = this.writeWrap(wrap);
        return n2 + this.write(str);
    }

    public int writeWrap(String wrap) throws IOException {
        int n2 = 0;
        if (this.lineWidth != -1 && wrap != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i2 = 0; i2 < wrap.length(); ++i2) {
                char c2 = wrap.charAt(i2);
                if (c2 == '\r') continue;
                if (c2 == '\n') {
                    this.out.write(this.newline);
                    n2 += this.newline.length();
                    this.charPosition = 0;
                    this.charIndex += this.newline.length();
                    n2 += this.indent();
                    continue;
                }
                ++n2;
                this.out.write(c2);
                ++this.charPosition;
                ++this.charIndex;
            }
        }
        return n2;
    }

    public int indent() throws IOException {
        int n2 = 0;
        for (String ind : this.indents) {
            if (ind == null) continue;
            n2 += ind.length();
            this.out.write(ind);
        }
        int indentWidth = n2;
        if (this.anchors_sp >= 0 && this.anchors[this.anchors_sp] > indentWidth) {
            int remainder = this.anchors[this.anchors_sp] - indentWidth;
            for (int i2 = 1; i2 <= remainder; ++i2) {
                this.out.write(32);
            }
            n2 += remainder;
        }
        this.charPosition += n2;
        this.charIndex += n2;
        return n2;
    }
}

