/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.EvalExprEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.IndentEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.misc.ArrayIterator;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STNoSuchAttributeException;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    public static final int DEFAULT_OPERAND_STACK_SIZE = 100;
    public static final Set<String> predefinedAnonSubtemplateAttributes = new HashSet<String>(){
        {
            this.add("i");
            this.add("i0");
        }
    };
    Object[] operands = new Object[100];
    int sp = -1;
    int nwline = 0;
    STGroup group;
    Locale locale;
    ErrorManager errMgr;
    public static boolean trace = false;
    protected List<String> executeTrace;
    public boolean debug = false;
    protected List<InterpEvent> events;

    public Interpreter(STGroup group, boolean debug) {
        this(group, Locale.getDefault(), group.errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, boolean debug) {
        this(group, locale, group.errMgr, debug);
    }

    public Interpreter(STGroup group, ErrorManager errMgr, boolean debug) {
        this(group, Locale.getDefault(), errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, ErrorManager errMgr, boolean debug) {
        this.group = group;
        this.locale = locale;
        this.errMgr = errMgr;
        this.debug = debug;
        if (debug) {
            this.events = new ArrayList<InterpEvent>();
            this.executeTrace = new ArrayList<String>();
        }
    }

    public int exec(STWriter out, InstanceScope scope) {
        ST self = scope.st;
        if (trace) {
            System.out.println("exec(" + self.getName() + ")");
        }
        try {
            this.setDefaultArguments(out, scope);
            return this._exec(out, scope);
        }
        catch (Exception e2) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e2.printStackTrace(pw);
            pw.flush();
            this.errMgr.runTimeError(this, scope, ErrorType.INTERNAL_ERROR, "internal error: " + sw.toString());
            return 0;
        }
    }

    protected int _exec(STWriter out, InstanceScope scope) {
        ST self = scope.st;
        int start = out.index();
        short prevOpcode = 0;
        int n2 = 0;
        byte[] code = self.impl.instrs;
        int ip = 0;
        while (ip < self.impl.codeSize) {
            if (trace || this.debug) {
                this.trace(scope, ip);
            }
            short opcode = code[ip];
            scope.ip = ip++;
            switch (opcode) {
                case 1: {
                    this.load_str(self, ip);
                    ip += 2;
                    break;
                }
                case 2: {
                    Object o2;
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    try {
                        o2 = this.getAttribute(scope, name);
                        if (o2 == ST.EMPTY_ATTR) {
                            o2 = null;
                        }
                    }
                    catch (STNoSuchAttributeException nsae) {
                        this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, name);
                        o2 = null;
                    }
                    this.operands[++this.sp] = o2;
                    break;
                }
                case 3: {
                    int valueIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o2 = self.locals[valueIndex];
                    if (o2 == ST.EMPTY_ATTR) {
                        o2 = null;
                    }
                    this.operands[++this.sp] = o2;
                    break;
                }
                case 4: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o2 = this.operands[this.sp--];
                    String name = self.impl.strings[nameIndex];
                    this.operands[++this.sp] = this.getObjectProperty(out, scope, o2, name);
                    break;
                }
                case 5: {
                    Object propName = this.operands[this.sp--];
                    Object o2 = this.operands[this.sp];
                    this.operands[this.sp] = this.getObjectProperty(out, scope, o2, propName);
                    break;
                }
                case 8: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ip += 2;
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, nargs, st);
                    this.sp -= nargs;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 9: {
                    int nargs = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = (String)this.operands[this.sp - nargs];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, nargs, st);
                    this.sp -= nargs;
                    --this.sp;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 10: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope, name);
                    this.storeArgs(scope, attrs, st);
                    this.operands[++this.sp] = st;
                    break;
                }
                case 11: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ip += 2;
                    this.super_new(scope, name, nargs);
                    break;
                }
                case 12: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    this.super_new(scope, name, attrs);
                    break;
                }
                case 6: {
                    int optionIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o2 = this.operands[this.sp--];
                    Object[] options = (Object[])this.operands[this.sp];
                    options[optionIndex] = o2;
                    break;
                }
                case 7: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    ip += 2;
                    Object o2 = this.operands[this.sp--];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    attrs.put(name, o2);
                    break;
                }
                case 13: {
                    Object o2 = this.operands[this.sp--];
                    int n1 = this.writeObjectNoOptions(out, scope, o2);
                    n2 += n1;
                    this.nwline += n1;
                    break;
                }
                case 14: {
                    Object[] options = (Object[])this.operands[this.sp--];
                    Object o2 = this.operands[this.sp--];
                    int n22 = this.writeObjectWithOptions(out, scope, o2, options);
                    n2 += n22;
                    this.nwline += n22;
                    break;
                }
                case 15: {
                    ST st = (ST)this.operands[this.sp--];
                    Object o2 = this.operands[this.sp--];
                    this.map(scope, o2, st);
                    break;
                }
                case 16: {
                    Object o2;
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ArrayList<ST> templates = new ArrayList<ST>();
                    for (int i2 = nmaps - 1; i2 >= 0; --i2) {
                        templates.add((ST)this.operands[this.sp - i2]);
                    }
                    this.sp -= nmaps;
                    if ((o2 = this.operands[this.sp--]) == null) break;
                    this.rot_map(scope, o2, templates);
                    break;
                }
                case 17: {
                    ST st = (ST)this.operands[this.sp--];
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ObjectList exprs = new ObjectList();
                    for (int i3 = nmaps - 1; i3 >= 0; --i3) {
                        exprs.add(this.operands[this.sp - i3]);
                    }
                    this.sp -= nmaps;
                    this.operands[++this.sp] = this.zip_map(scope, exprs, st);
                    break;
                }
                case 18: {
                    ip = Interpreter.getShort(code, ip);
                    break;
                }
                case 19: {
                    int addr = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o2 = this.operands[this.sp--];
                    if (this.testAttributeTrue(o2)) break;
                    ip = addr;
                    break;
                }
                case 20: {
                    this.operands[++this.sp] = new Object[Compiler.NUM_OPTIONS];
                    break;
                }
                case 21: {
                    this.operands[++this.sp] = new ArgumentsMap();
                    break;
                }
                case 22: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    this.passthru(scope, name, attrs);
                    break;
                }
                case 24: {
                    this.operands[++this.sp] = new ObjectList();
                    break;
                }
                case 25: {
                    Object o2 = this.operands[this.sp--];
                    ObjectList list = (ObjectList)this.operands[this.sp];
                    this.addToList(scope, list, o2);
                    break;
                }
                case 26: {
                    this.operands[this.sp] = this.toString(out, scope, this.operands[this.sp]);
                    break;
                }
                case 27: {
                    this.operands[this.sp] = this.first(scope, this.operands[this.sp]);
                    break;
                }
                case 28: {
                    this.operands[this.sp] = this.last(scope, this.operands[this.sp]);
                    break;
                }
                case 29: {
                    this.operands[this.sp] = this.rest(scope, this.operands[this.sp]);
                    break;
                }
                case 30: {
                    this.operands[this.sp] = this.trunc(scope, this.operands[this.sp]);
                    break;
                }
                case 31: {
                    this.operands[this.sp] = this.strip(scope, this.operands[this.sp]);
                    break;
                }
                case 32: {
                    Object o2 = this.operands[this.sp--];
                    if (o2.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o2).trim();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope, ErrorType.EXPECTING_STRING, "trim", (Object)o2.getClass().getName());
                    this.operands[++this.sp] = o2;
                    break;
                }
                case 33: {
                    this.operands[this.sp] = this.length(this.operands[this.sp]);
                    break;
                }
                case 34: {
                    Object o2 = this.operands[this.sp--];
                    if (o2.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o2).length();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope, ErrorType.EXPECTING_STRING, "strlen", (Object)o2.getClass().getName());
                    this.operands[++this.sp] = 0;
                    break;
                }
                case 35: {
                    this.operands[this.sp] = this.reverse(scope, this.operands[this.sp]);
                    break;
                }
                case 36: {
                    this.operands[this.sp] = !this.testAttributeTrue(this.operands[this.sp]);
                    break;
                }
                case 37: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) || this.testAttributeTrue(right);
                    break;
                }
                case 38: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) && this.testAttributeTrue(right);
                    break;
                }
                case 39: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    this.indent(out, scope, strIndex);
                    break;
                }
                case 40: {
                    out.popIndentation();
                    break;
                }
                case 41: {
                    try {
                        if (prevOpcode == 41 || prevOpcode == 39 || this.nwline > 0) {
                            out.write(Misc.newline);
                        }
                        this.nwline = 0;
                    }
                    catch (IOException ioe) {
                        this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe);
                    }
                    break;
                }
                case 42: {
                    break;
                }
                case 43: {
                    --this.sp;
                    break;
                }
                case 44: {
                    this.operands[++this.sp] = null;
                    break;
                }
                case 45: {
                    this.operands[++this.sp] = true;
                    break;
                }
                case 46: {
                    this.operands[++this.sp] = false;
                    break;
                }
                case 47: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o2 = self.impl.strings[strIndex];
                    int n1 = this.writeObjectNoOptions(out, scope, o2);
                    n2 += n1;
                    this.nwline += n1;
                    break;
                }
                default: {
                    this.errMgr.internalError(self, "invalid bytecode @ " + (ip - 1) + ": " + opcode, null);
                    self.impl.dump();
                }
            }
            prevOpcode = opcode;
        }
        if (this.debug) {
            int stop = out.index() - 1;
            EvalTemplateEvent e2 = new EvalTemplateEvent(scope, start, stop);
            this.trackDebugEvent(scope, e2);
        }
        return n2;
    }

    void load_str(ST self, int ip) {
        int strIndex = Interpreter.getShort(self.impl.instrs, ip);
        ip += 2;
        this.operands[++this.sp] = self.impl.strings[strIndex];
    }

    void super_new(InstanceScope scope, String name, int nargs) {
        ST self = scope.st;
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.getEmbeddedInstanceOf(this, scope, name);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope, nargs, st);
        this.sp -= nargs;
        this.operands[++this.sp] = st;
    }

    void super_new(InstanceScope scope, String name, Map<String, Object> attrs) {
        ST self = scope.st;
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.createStringTemplateInternally(imported);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope, attrs, st);
        this.operands[++this.sp] = st;
    }

    void passthru(InstanceScope scope, String templateName, Map<String, Object> attrs) {
        CompiledST c2 = this.group.lookupTemplate(templateName);
        if (c2 == null) {
            return;
        }
        if (c2.formalArguments == null) {
            return;
        }
        for (FormalArgument arg : c2.formalArguments.values()) {
            if (attrs.containsKey(arg.name)) continue;
            try {
                Object o2 = this.getAttribute(scope, arg.name);
                if (o2 == ST.EMPTY_ATTR && arg.defaultValueToken == null) {
                    attrs.put(arg.name, null);
                    continue;
                }
                if (o2 == ST.EMPTY_ATTR) continue;
                attrs.put(arg.name, o2);
            }
            catch (STNoSuchAttributeException nsae) {
                if (arg.defaultValueToken != null) continue;
                this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE_PASS_THROUGH, arg.name);
                attrs.put(arg.name, null);
            }
        }
    }

    void storeArgs(InstanceScope scope, Map<String, Object> attrs, ST st) {
        if (st.impl.hasFormalArgs) {
            boolean argumentCountMismatch = false;
            Map<String, FormalArgument> formalArguments = st.impl.formalArguments;
            if (formalArguments == null) {
                formalArguments = Collections.emptyMap();
            }
            for (Map.Entry<String, FormalArgument> formalArgument : formalArguments.entrySet()) {
                if (formalArgument.getValue().defaultValueToken != null || formalArgument.getValue().defaultValue != null || attrs != null && attrs.containsKey(formalArgument.getKey())) continue;
                argumentCountMismatch = true;
                break;
            }
            if (attrs != null && attrs.size() > formalArguments.size()) {
                argumentCountMismatch = true;
            }
            if (argumentCountMismatch) {
                int nargs = attrs != null ? attrs.size() : 0;
                int nformalArgs = formalArguments.size();
                this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, Object> argument : attrs.entrySet()) {
                if (!st.impl.hasFormalArgs) {
                    if (st.impl.formalArguments == null || !st.impl.formalArguments.containsKey(argument.getKey())) {
                        try {
                            st.impl = st.impl.clone();
                            st.add(argument.getKey(), argument.getValue());
                        }
                        catch (CloneNotSupportedException ex) {
                            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                        }
                        continue;
                    }
                    st.rawSetAttribute(argument.getKey(), argument.getValue());
                    continue;
                }
                if (st.impl.formalArguments == null || !st.impl.formalArguments.containsKey(argument.getKey())) {
                    this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                    continue;
                }
                st.rawSetAttribute(argument.getKey(), argument.getValue());
            }
        }
    }

    void storeArgs(InstanceScope scope, int nargs, ST st) {
        if (nargs > 0 && !st.impl.hasFormalArgs && st.impl.formalArguments == null) {
            st.add("it", null);
        }
        int nformalArgs = 0;
        if (st.impl.formalArguments != null) {
            nformalArgs = st.impl.formalArguments.size();
        }
        int firstArg = this.sp - (nargs - 1);
        int numToStore = Math.min(nargs, nformalArgs);
        if (st.impl.isAnonSubtemplate) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nargs < nformalArgs - st.impl.numberOfArgsWithDefaultValues || nargs > nformalArgs) {
            this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
        }
        if (st.impl.formalArguments == null) {
            return;
        }
        Iterator<String> argNames = st.impl.formalArguments.keySet().iterator();
        for (int i2 = 0; i2 < numToStore; ++i2) {
            Object o2 = this.operands[firstArg + i2];
            String argName = argNames.next();
            st.rawSetAttribute(argName, o2);
        }
    }

    protected void indent(STWriter out, InstanceScope scope, int strIndex) {
        String indent = scope.st.impl.strings[strIndex];
        if (this.debug) {
            int start = out.index();
            IndentEvent e2 = new IndentEvent(scope, start, start + indent.length() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e2);
        }
        out.pushIndentation(indent);
    }

    protected int writeObjectNoOptions(STWriter out, InstanceScope scope, Object o2) {
        int start = out.index();
        int n2 = this.writeObject(out, scope, o2, null);
        if (this.debug) {
            EvalExprEvent e2 = new EvalExprEvent(scope, start, out.index() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e2);
        }
        return n2;
    }

    protected int writeObjectWithOptions(STWriter out, InstanceScope scope, Object o2, Object[] options) {
        int start = out.index();
        String[] optionStrings = null;
        if (options != null) {
            optionStrings = new String[options.length];
            for (int i2 = 0; i2 < Compiler.NUM_OPTIONS; ++i2) {
                optionStrings[i2] = this.toString(out, scope, options[i2]);
            }
        }
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.pushAnchorPoint();
        }
        int n2 = this.writeObject(out, scope, o2, optionStrings);
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.popAnchorPoint();
        }
        if (this.debug) {
            EvalExprEvent e2 = new EvalExprEvent(scope, start, out.index() - 1, this.getExprStartChar(scope), this.getExprStopChar(scope));
            this.trackDebugEvent(scope, e2);
        }
        return n2;
    }

    protected int writeObject(STWriter out, InstanceScope scope, Object o2, String[] options) {
        int n2 = 0;
        if (o2 == null) {
            if (options != null && options[Option.NULL.ordinal()] != null) {
                o2 = options[Option.NULL.ordinal()];
            } else {
                return 0;
            }
        }
        if (o2 instanceof ST) {
            scope = new InstanceScope(scope, (ST)o2);
            if (options != null && options[Option.WRAP.ordinal()] != null) {
                try {
                    out.writeWrap(options[Option.WRAP.ordinal()]);
                }
                catch (IOException ioe) {
                    this.errMgr.IOError(scope.st, ErrorType.WRITE_IO_ERROR, ioe);
                }
            }
            n2 = this.exec(out, scope);
        } else {
            o2 = this.convertAnythingIteratableToIterator(scope, o2);
            try {
                n2 = o2 instanceof Iterator ? this.writeIterator(out, scope, o2, options) : this.writePOJO(out, scope, o2, options);
            }
            catch (IOException ioe) {
                this.errMgr.IOError(scope.st, ErrorType.WRITE_IO_ERROR, ioe, o2);
            }
        }
        return n2;
    }

    protected int writeIterator(STWriter out, InstanceScope scope, Object o2, String[] options) throws IOException {
        if (o2 == null) {
            return 0;
        }
        int n2 = 0;
        Iterator it = (Iterator)o2;
        String separator = null;
        if (options != null) {
            separator = options[Option.SEPARATOR.ordinal()];
        }
        boolean seenAValue = false;
        while (it.hasNext()) {
            int nw;
            boolean needSeparator;
            Object iterValue = it.next();
            boolean bl = needSeparator = seenAValue && separator != null && (iterValue != null || options[Option.NULL.ordinal()] != null);
            if (needSeparator) {
                n2 += out.writeSeparator(separator);
            }
            if ((nw = this.writeObject(out, scope, iterValue, options)) > 0) {
                seenAValue = true;
            }
            n2 += nw;
        }
        return n2;
    }

    protected int writePOJO(STWriter out, InstanceScope scope, Object o2, String[] options) throws IOException {
        AttributeRenderer r2;
        String formatString = null;
        if (options != null) {
            formatString = options[Option.FORMAT.ordinal()];
        }
        String v2 = (r2 = scope.st.impl.nativeGroup.getAttributeRenderer(o2.getClass())) != null ? r2.toString(o2, formatString, this.locale) : o2.toString();
        int n2 = options != null && options[Option.WRAP.ordinal()] != null ? out.write(v2, options[Option.WRAP.ordinal()]) : out.write(v2);
        return n2;
    }

    protected int getExprStartChar(InstanceScope scope) {
        Interval templateLocation = scope.st.impl.sourceMap[scope.ip];
        if (templateLocation != null) {
            return templateLocation.a;
        }
        return -1;
    }

    protected int getExprStopChar(InstanceScope scope) {
        Interval templateLocation = scope.st.impl.sourceMap[scope.ip];
        if (templateLocation != null) {
            return templateLocation.b;
        }
        return -1;
    }

    protected void map(InstanceScope scope, Object attr, final ST st) {
        this.rot_map(scope, attr, (List<ST>)new ArrayList<ST>(){
            {
                this.add(st);
            }
        });
    }

    protected void rot_map(InstanceScope scope, Object attr, List<ST> prototypes) {
        if (attr == null) {
            this.operands[++this.sp] = null;
            return;
        }
        if ((attr = this.convertAnythingIteratableToIterator(scope, attr)) instanceof Iterator) {
            List<ST> mapped = this.rot_map_iterator(scope, (Iterator)attr, prototypes);
            this.operands[++this.sp] = mapped;
        } else {
            ST proto = prototypes.get(0);
            ST st = this.group.createStringTemplateInternally(proto);
            if (st != null) {
                this.setFirstArgument(scope, st, attr);
                if (st.impl.isAnonSubtemplate) {
                    st.rawSetAttribute("i0", 0);
                    st.rawSetAttribute("i", 1);
                }
                this.operands[++this.sp] = st;
            } else {
                this.operands[++this.sp] = null;
            }
        }
    }

    protected List<ST> rot_map_iterator(InstanceScope scope, Iterator<?> attr, List<ST> prototypes) {
        ArrayList<ST> mapped = new ArrayList<ST>();
        Iterator<?> iter = attr;
        int i0 = 0;
        int i2 = 1;
        int ti = 0;
        while (iter.hasNext()) {
            Object iterValue = iter.next();
            if (iterValue == null) {
                mapped.add(null);
                continue;
            }
            int templateIndex = ti % prototypes.size();
            ++ti;
            ST proto = prototypes.get(templateIndex);
            ST st = this.group.createStringTemplateInternally(proto);
            this.setFirstArgument(scope, st, iterValue);
            if (st.impl.isAnonSubtemplate) {
                st.rawSetAttribute("i0", i0);
                st.rawSetAttribute("i", i2);
            }
            mapped.add(st);
            ++i0;
            ++i2;
        }
        return mapped;
    }

    protected ST.AttributeList zip_map(InstanceScope scope, List<Object> exprs, ST prototype) {
        if (exprs == null || prototype == null || exprs.size() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < exprs.size(); ++i2) {
            Object attr = exprs.get(i2);
            if (attr == null) continue;
            exprs.set(i2, this.convertAnythingToIterator(scope, attr));
        }
        int numExprs = exprs.size();
        CompiledST code = prototype.impl;
        Map<String, FormalArgument> formalArguments = code.formalArguments;
        if (!code.hasFormalArgs || formalArguments == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.MISSING_FORMAL_ARGUMENTS);
            return null;
        }
        String[] formalArgumentNames = formalArguments.keySet().toArray(new String[formalArguments.size()]);
        int nformalArgs = formalArgumentNames.length;
        if (prototype.isAnonSubtemplate()) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nformalArgs != numExprs) {
            int shorterSize;
            this.errMgr.runTimeError(this, scope, ErrorType.MAP_ARGUMENT_COUNT_MISMATCH, numExprs, (Object)nformalArgs);
            numExprs = shorterSize = Math.min(formalArgumentNames.length, numExprs);
            String[] newFormalArgumentNames = new String[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        ST.AttributeList results = new ST.AttributeList();
        int i3 = 0;
        while (true) {
            int numEmpty = 0;
            ST embedded = this.group.createStringTemplateInternally(prototype);
            embedded.rawSetAttribute("i0", i3);
            embedded.rawSetAttribute("i", i3 + 1);
            for (int a2 = 0; a2 < numExprs; ++a2) {
                Iterator it = (Iterator)exprs.get(a2);
                if (it != null && it.hasNext()) {
                    String argName = formalArgumentNames[a2];
                    Object iteratedValue = it.next();
                    embedded.rawSetAttribute(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numExprs) break;
            results.add(embedded);
            ++i3;
        }
        return results;
    }

    protected void setFirstArgument(InstanceScope scope, ST st, Object attr) {
        if (!st.impl.hasFormalArgs && st.impl.formalArguments == null) {
            st.add("it", attr);
            return;
        }
        if (st.impl.formalArguments == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.ARGUMENT_COUNT_MISMATCH, 1, st.impl.name, 0);
            return;
        }
        st.locals[0] = attr;
    }

    protected void addToList(InstanceScope scope, List<Object> list, Object o2) {
        if ((o2 = this.convertAnythingIteratableToIterator(scope, o2)) instanceof Iterator) {
            Iterator it = (Iterator)o2;
            while (it.hasNext()) {
                list.add(it.next());
            }
        } else {
            list.add(o2);
        }
    }

    public Object first(InstanceScope scope, Object v2) {
        Iterator it;
        if (v2 == null) {
            return null;
        }
        Object r2 = v2;
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator && (it = (Iterator)v2).hasNext()) {
            r2 = it.next();
        }
        return r2;
    }

    public Object last(InstanceScope scope, Object v2) {
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof List) {
            return ((List)v2).get(((List)v2).size() - 1);
        }
        if (v2.getClass().isArray()) {
            return Array.get(v2, Array.getLength(v2) - 1);
        }
        Object last = v2;
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator) {
            Iterator it = (Iterator)v2;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object rest(InstanceScope scope, Object v2) {
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof List) {
            List elems = (List)v2;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(1, elems.size());
        }
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator) {
            ArrayList a2 = new ArrayList();
            Iterator it = (Iterator)v2;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o2 = it.next();
                a2.add(o2);
            }
            return a2;
        }
        return null;
    }

    public Object trunc(InstanceScope scope, Object v2) {
        if (v2 == null) {
            return null;
        }
        if (v2 instanceof List) {
            List elems = (List)v2;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(0, elems.size() - 1);
        }
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator) {
            ArrayList a2 = new ArrayList();
            Iterator it = (Iterator)v2;
            while (it.hasNext()) {
                Object o2 = it.next();
                if (!it.hasNext()) continue;
                a2.add(o2);
            }
            return a2;
        }
        return null;
    }

    public Object strip(InstanceScope scope, Object v2) {
        if (v2 == null) {
            return null;
        }
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator) {
            ArrayList a2 = new ArrayList();
            Iterator it = (Iterator)v2;
            while (it.hasNext()) {
                Object o2 = it.next();
                if (o2 == null) continue;
                a2.add(o2);
            }
            return a2;
        }
        return v2;
    }

    public Object reverse(InstanceScope scope, Object v2) {
        if (v2 == null) {
            return null;
        }
        if ((v2 = this.convertAnythingIteratableToIterator(scope, v2)) instanceof Iterator) {
            LinkedList a2 = new LinkedList();
            Iterator it = (Iterator)v2;
            while (it.hasNext()) {
                a2.add(0, it.next());
            }
            return a2;
        }
        return v2;
    }

    public Object length(Object v2) {
        if (v2 == null) {
            return 0;
        }
        int i2 = 1;
        if (v2 instanceof Map) {
            i2 = ((Map)v2).size();
        } else if (v2 instanceof Collection) {
            i2 = ((Collection)v2).size();
        } else if (v2 instanceof Object[]) {
            i2 = ((Object[])v2).length;
        } else if (v2.getClass().isArray()) {
            i2 = Array.getLength(v2);
        } else if (v2 instanceof Iterator) {
            Iterator it = (Iterator)v2;
            i2 = 0;
            while (it.hasNext()) {
                it.next();
                ++i2;
            }
        }
        return i2;
    }

    protected String toString(STWriter out, InstanceScope scope, Object value) {
        if (value != null) {
            STWriter stw;
            if (value.getClass() == String.class) {
                return (String)value;
            }
            StringWriter sw = new StringWriter();
            try {
                Class<?> writerClass = out.getClass();
                Constructor<?> ctor = writerClass.getConstructor(Writer.class);
                stw = (STWriter)ctor.newInstance(sw);
            }
            catch (Exception e2) {
                stw = new AutoIndentWriter(sw);
                this.errMgr.runTimeError(this, scope, ErrorType.WRITER_CTOR_ISSUE, out.getClass().getSimpleName());
            }
            if (this.debug && !scope.earlyEval) {
                scope = new InstanceScope(scope, scope.st);
                scope.earlyEval = true;
            }
            this.writeObjectNoOptions(stw, scope, value);
            return sw.toString();
        }
        return null;
    }

    public Object convertAnythingIteratableToIterator(InstanceScope scope, Object o2) {
        Iterator<Object> iter = null;
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Collection) {
            iter = ((Collection)o2).iterator();
        } else if (o2 instanceof Object[]) {
            iter = Arrays.asList((Object[])o2).iterator();
        } else if (o2.getClass().isArray()) {
            iter = new ArrayIterator(o2);
        } else if (o2 instanceof Map) {
            iter = scope.st.groupThatCreatedThisInstance.iterateAcrossValues ? ((Map)o2).values().iterator() : ((Map)o2).keySet().iterator();
        }
        if (iter == null) {
            return o2;
        }
        return iter;
    }

    public Iterator<?> convertAnythingToIterator(InstanceScope scope, Object o2) {
        if ((o2 = this.convertAnythingIteratableToIterator(scope, o2)) instanceof Iterator) {
            return (Iterator)o2;
        }
        ST.AttributeList singleton = new ST.AttributeList(1);
        singleton.add(o2);
        return singleton.iterator();
    }

    protected boolean testAttributeTrue(Object a2) {
        if (a2 == null) {
            return false;
        }
        if (a2 instanceof Boolean) {
            return (Boolean)a2;
        }
        if (a2 instanceof Collection) {
            return ((Collection)a2).size() > 0;
        }
        if (a2 instanceof Map) {
            return ((Map)a2).size() > 0;
        }
        if (a2 instanceof Iterator) {
            return ((Iterator)a2).hasNext();
        }
        return true;
    }

    protected Object getObjectProperty(STWriter out, InstanceScope scope, Object o2, Object property) {
        if (o2 == null) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_PROPERTY, "null." + property);
            return null;
        }
        try {
            ST self = scope.st;
            ModelAdaptor adap = self.groupThatCreatedThisInstance.getModelAdaptor(o2.getClass());
            return adap.getProperty(this, self, o2, property, this.toString(out, scope, property));
        }
        catch (STNoSuchPropertyException e2) {
            this.errMgr.runTimeError(this, scope, ErrorType.NO_SUCH_PROPERTY, e2, (Object)(o2.getClass().getName() + "." + property));
            return null;
        }
    }

    public Object getAttribute(InstanceScope scope, String name) {
        InstanceScope current = scope;
        while (current != null) {
            ST p2 = current.st;
            FormalArgument localArg = null;
            if (p2.impl.formalArguments != null) {
                localArg = p2.impl.formalArguments.get(name);
            }
            if (localArg != null) {
                Object o2 = p2.locals[localArg.index];
                return o2;
            }
            current = current.parent;
        }
        ST self = scope.st;
        STGroup g2 = self.impl.nativeGroup;
        Object o3 = this.getDictionary(g2, name);
        if (o3 != null) {
            return o3;
        }
        throw new STNoSuchAttributeException(name, scope);
    }

    public Object getDictionary(STGroup g2, String name) {
        if (g2.isDictionary(name)) {
            return g2.rawGetDictionary(name);
        }
        if (g2.imports != null) {
            for (STGroup sup : g2.imports) {
                Object o2 = this.getDictionary(sup, name);
                if (o2 == null) continue;
                return o2;
            }
        }
        return null;
    }

    public void setDefaultArguments(STWriter out, InstanceScope scope) {
        ST invokedST = scope.st;
        if (invokedST.impl.formalArguments == null || invokedST.impl.numberOfArgsWithDefaultValues == 0) {
            return;
        }
        for (FormalArgument arg : invokedST.impl.formalArguments.values()) {
            if (invokedST.locals[arg.index] != ST.EMPTY_ATTR || arg.defaultValueToken == null) continue;
            if (arg.defaultValueToken.getType() == 4) {
                CompiledST code = arg.compiledDefaultValue;
                if (code == null) {
                    code = new CompiledST();
                }
                ST defaultArgST = this.group.createStringTemplateInternally(code);
                defaultArgST.groupThatCreatedThisInstance = this.group;
                String defArgTemplate = arg.defaultValueToken.getText();
                if (defArgTemplate.startsWith("{" + this.group.delimiterStartChar + "(") && defArgTemplate.endsWith(")" + this.group.delimiterStopChar + "}")) {
                    invokedST.rawSetAttribute(arg.name, this.toString(out, new InstanceScope(scope, invokedST), defaultArgST));
                    continue;
                }
                invokedST.rawSetAttribute(arg.name, defaultArgST);
                continue;
            }
            invokedST.rawSetAttribute(arg.name, arg.defaultValue);
        }
    }

    public static String getEnclosingInstanceStackString(InstanceScope scope) {
        List<ST> templates = Interpreter.getEnclosingInstanceStack(scope, true);
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        for (ST st : templates) {
            if (i2 > 0) {
                buf.append(" ");
            }
            buf.append(st.getName());
            ++i2;
        }
        return buf.toString();
    }

    public static List<ST> getEnclosingInstanceStack(InstanceScope scope, boolean topdown) {
        LinkedList<ST> stack = new LinkedList<ST>();
        InstanceScope p2 = scope;
        while (p2 != null) {
            if (topdown) {
                stack.add(0, p2.st);
            } else {
                stack.add(p2.st);
            }
            p2 = p2.parent;
        }
        return stack;
    }

    public static List<InstanceScope> getScopeStack(InstanceScope scope, boolean topdown) {
        LinkedList<InstanceScope> stack = new LinkedList<InstanceScope>();
        InstanceScope p2 = scope;
        while (p2 != null) {
            if (topdown) {
                stack.add(0, p2);
            } else {
                stack.add(p2);
            }
            p2 = p2.parent;
        }
        return stack;
    }

    public static List<EvalTemplateEvent> getEvalTemplateEventStack(InstanceScope scope, boolean topdown) {
        LinkedList<EvalTemplateEvent> stack = new LinkedList<EvalTemplateEvent>();
        InstanceScope p2 = scope;
        while (p2 != null) {
            EvalTemplateEvent eval = (EvalTemplateEvent)p2.events.get(p2.events.size() - 1);
            if (topdown) {
                stack.add(0, eval);
            } else {
                stack.add(eval);
            }
            p2 = p2.parent;
        }
        return stack;
    }

    protected void trace(InstanceScope scope, int ip) {
        ST self = scope.st;
        StringBuilder tr = new StringBuilder();
        BytecodeDisassembler dis = new BytecodeDisassembler(self.impl);
        StringBuilder buf = new StringBuilder();
        dis.disassembleInstruction(buf, ip);
        String name = self.impl.name + ":";
        if (Misc.referenceEquals(self.impl.name, "anonymous")) {
            name = "";
        }
        tr.append(String.format("%-40s", name + buf));
        tr.append("\tstack=[");
        for (int i2 = 0; i2 <= this.sp; ++i2) {
            Object o2 = this.operands[i2];
            this.printForTrace(tr, scope, o2);
        }
        tr.append(" ], calls=");
        tr.append(Interpreter.getEnclosingInstanceStackString(scope));
        tr.append(", sp=" + this.sp + ", nw=" + this.nwline);
        String s2 = tr.toString();
        if (this.debug) {
            this.executeTrace.add(s2);
        }
        if (trace) {
            System.out.println(s2);
        }
    }

    protected void printForTrace(StringBuilder tr, InstanceScope scope, Object o2) {
        if (o2 instanceof ST) {
            if (((ST)o2).impl == null) {
                tr.append("bad-template()");
            } else {
                tr.append(" " + ((ST)o2).impl.name + "()");
            }
            return;
        }
        if ((o2 = this.convertAnythingIteratableToIterator(scope, o2)) instanceof Iterator) {
            Iterator it = (Iterator)o2;
            tr.append(" [");
            while (it.hasNext()) {
                Object iterValue = it.next();
                this.printForTrace(tr, scope, iterValue);
            }
            tr.append(" ]");
        } else {
            tr.append(" " + o2);
        }
    }

    public List<InterpEvent> getEvents() {
        return this.events;
    }

    protected void trackDebugEvent(InstanceScope scope, InterpEvent e2) {
        InstanceScope parent;
        this.events.add(e2);
        scope.events.add(e2);
        if (e2 instanceof EvalTemplateEvent && (parent = scope.parent) != null) {
            scope.parent.childEvalTemplateEvents.add((EvalTemplateEvent)e2);
        }
    }

    public List<String> getExecutionTrace() {
        return this.executeTrace;
    }

    public static int getShort(byte[] memory, int index) {
        int b1 = memory[index] & 0xFF;
        int b2 = memory[index + 1] & 0xFF;
        return b1 << 8 | b2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentsMap
    extends HashMap<String, Object> {
        protected ArgumentsMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjectList
    extends ArrayList<Object> {
        protected ObjectList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        ANCHOR,
        FORMAT,
        NULL,
        SEPARATOR,
        WRAP;

    }
}

