/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Token;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Misc;

public class STGroupDir
extends STGroup {
    public String groupDirName;
    public URL root;

    public STGroupDir(String dirName) {
        this(dirName, '<', '>');
    }

    public STGroupDir(String dirName, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.groupDirName = dirName;
        File dir = new File(dirName);
        if (dir.exists() && dir.isDirectory()) {
            try {
                this.root = dir.toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new STException("can't load dir " + dirName, e2);
            }
            if (verbose) {
                System.out.println("STGroupDir(" + dirName + ") found at " + this.root);
            }
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.root = cl.getResource(dirName);
            if (this.root == null) {
                cl = this.getClass().getClassLoader();
                this.root = cl.getResource(dirName);
            }
            if (verbose) {
                System.out.println("STGroupDir(" + dirName + ") found via CLASSPATH at " + this.root);
            }
            if (this.root == null) {
                throw new IllegalArgumentException("No such directory: " + dirName);
            }
        }
    }

    public STGroupDir(String dirName, String encoding) {
        this(dirName, encoding, '<', '>');
    }

    public STGroupDir(String dirName, String encoding, char delimiterStartChar, char delimiterStopChar) {
        this(dirName, delimiterStartChar, delimiterStopChar);
        this.encoding = encoding;
    }

    public STGroupDir(URL root, String encoding, char delimiterStartChar, char delimiterStopChar) {
        super(delimiterStartChar, delimiterStopChar);
        this.groupDirName = new File(root.getFile()).getName();
        this.root = root;
        this.encoding = encoding;
    }

    public void importTemplates(Token fileNameToken) {
        String msg = "import illegal in group files embedded in STGroupDirs; import " + fileNameToken.getText() + " in STGroupDir " + this.getName();
        throw new UnsupportedOperationException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledST load(String name) {
        if (verbose) {
            System.out.println("STGroupDir.load(" + name + ")");
        }
        String parent = Misc.getParent(name);
        String prefix = Misc.getPrefix(name);
        URL groupFileURL = null;
        try {
            groupFileURL = new URL(this.root + parent + GROUP_FILE_EXTENSION);
        }
        catch (MalformedURLException e2) {
            this.errMgr.internalError(null, "bad URL: " + this.root + parent + GROUP_FILE_EXTENSION, e2);
            return null;
        }
        InputStream is = null;
        try {
            is = groupFileURL.openStream();
        }
        catch (IOException ioe) {
            String unqualifiedName = Misc.getFileName(name);
            CompiledST compiledST = this.loadTemplateFile(prefix, unqualifiedName + TEMPLATE_FILE_EXTENSION);
            return compiledST;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                this.errMgr.internalError(null, "can't close template file stream " + name, ioe);
            }
        }
        this.loadGroupFile(prefix, this.root + parent + GROUP_FILE_EXTENSION);
        return this.rawGetTemplate(name);
    }

    public CompiledST loadTemplateFile(String prefix, String unqualifiedFileName) {
        ANTLRInputStream fs;
        if (verbose) {
            System.out.println("loadTemplateFile(" + unqualifiedFileName + ") in groupdir " + "from " + this.root + " prefix=" + prefix);
        }
        URL f2 = null;
        try {
            f2 = new URL(this.root + prefix + unqualifiedFileName);
        }
        catch (MalformedURLException me) {
            this.errMgr.runTimeError(null, null, ErrorType.INVALID_TEMPLATE_NAME, me, (Object)(this.root + unqualifiedFileName));
            return null;
        }
        try {
            fs = new ANTLRInputStream(f2.openStream(), this.encoding);
            fs.name = unqualifiedFileName;
        }
        catch (IOException ioe) {
            if (verbose) {
                System.out.println(this.root + "/" + unqualifiedFileName + " doesn't exist");
            }
            return null;
        }
        return this.loadTemplateFile(prefix, unqualifiedFileName, fs);
    }

    public String getName() {
        return this.groupDirName;
    }

    public String getFileName() {
        return this.root.getFile();
    }

    public URL getRootDirURL() {
        return this.root;
    }
}

