/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Iterator;
import org.stringtemplate.v4.misc.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Misc {
    public static final String newline = System.getProperty("line.separator");

    public static boolean referenceEquals(Object x2, Object y2) {
        return x2 == y2;
    }

    public static String join(Iterator<?> iter, String separator) {
        StringBuilder buf = new StringBuilder();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String strip(String s2, int n2) {
        return s2.substring(n2, s2.length() - n2);
    }

    public static String trimOneStartingNewline(String s2) {
        if (s2.startsWith("\r\n")) {
            s2 = s2.substring(2);
        } else if (s2.startsWith("\n")) {
            s2 = s2.substring(1);
        }
        return s2;
    }

    public static String trimOneTrailingNewline(String s2) {
        if (s2.endsWith("\r\n")) {
            s2 = s2.substring(0, s2.length() - 2);
        } else if (s2.endsWith("\n")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    public static String stripLastPathElement(String f2) {
        int slash = f2.lastIndexOf(47);
        if (slash < 0) {
            return f2;
        }
        return f2.substring(0, slash);
    }

    public static String getFileNameNoSuffix(String f2) {
        if (f2 == null) {
            return null;
        }
        f2 = Misc.getFileName(f2);
        return f2.substring(0, f2.lastIndexOf(46));
    }

    public static String getFileName(String fullFileName) {
        if (fullFileName == null) {
            return null;
        }
        File f2 = new File(fullFileName);
        return f2.getName();
    }

    public static String getParent(String name) {
        if (name == null) {
            return null;
        }
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            return name.substring(0, lastSlash);
        }
        if (lastSlash == 0) {
            return "/";
        }
        return "";
    }

    public static String getPrefix(String name) {
        String parent;
        if (name == null) {
            return "/";
        }
        String prefix = parent = Misc.getParent(name);
        if (!parent.endsWith("/")) {
            prefix = prefix + '/';
        }
        return prefix;
    }

    public static String replaceEscapes(String s2) {
        s2 = s2.replaceAll("\n", "\\\\n");
        s2 = s2.replaceAll("\r", "\\\\r");
        s2 = s2.replaceAll("\t", "\\\\t");
        return s2;
    }

    public static String replaceEscapedRightAngle(String s2) {
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            if (c2 == '<' && s2.substring(i2).startsWith("<\\\\>")) {
                buf.append("<\\\\>");
                i2 += "<\\\\>".length();
                continue;
            }
            if (c2 == '>' && s2.substring(i2).startsWith(">\\>")) {
                buf.append(">>");
                i2 += ">\\>".length();
                continue;
            }
            if (c2 == '\\' && s2.substring(i2).startsWith("\\>>") && !s2.substring(i2).startsWith("\\>>>")) {
                buf.append(">>");
                i2 += "\\>>".length();
                continue;
            }
            buf.append(c2);
            ++i2;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean urlExists(URL url) {
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jarURLConnection.getJarFileURL()});
                try {
                    boolean bl = urlClassLoader.findResource(jarURLConnection.getEntryName()) != null;
                    return bl;
                }
                finally {
                    if (urlClassLoader instanceof Closeable) {
                        ((Closeable)urlClassLoader).close();
                    }
                }
            }
            InputStream is = null;
            try {
                is = url.openStream();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (is == null) return false;
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static Coordinate getLineCharPosition(String s2, int index) {
        int line = 1;
        int charPos = 0;
        for (int p2 = 0; p2 < index; ++p2) {
            if (s2.charAt(p2) == '\n') {
                ++line;
                charPos = 0;
                continue;
            }
            ++charPos;
        }
        return new Coordinate(line, charPos);
    }
}

