/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.misc.Coordinate;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STMessage;

public class STRuntimeMessage
extends STMessage {
    final Interpreter interp;
    public final int ip;
    public final InstanceScope scope;

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip) {
        this(interp, error, ip, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope) {
        this(interp, error, ip, scope, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope, Object arg) {
        this(interp, error, ip, scope, null, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope, Throwable e2, Object arg) {
        this(interp, error, ip, scope, e2, arg, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope, Throwable e2, Object arg, Object arg2) {
        this(interp, error, ip, scope, e2, arg, arg2, null);
    }

    public STRuntimeMessage(Interpreter interp, ErrorType error, int ip, InstanceScope scope, Throwable e2, Object arg, Object arg2, Object arg3) {
        super(error, scope != null ? scope.st : null, e2, arg, arg2, arg3);
        this.interp = interp;
        this.ip = ip;
        this.scope = scope;
    }

    public String getSourceLocation() {
        if (this.ip < 0 || this.self.impl == null) {
            return null;
        }
        Interval I2 = this.self.impl.sourceMap[this.ip];
        if (I2 == null) {
            return null;
        }
        int i2 = I2.a;
        Coordinate loc = Misc.getLineCharPosition(this.self.impl.template, i2);
        return loc.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String loc = this.getSourceLocation();
        if (this.self != null) {
            buf.append("context [");
            if (this.interp != null) {
                buf.append(Interpreter.getEnclosingInstanceStackString(this.scope));
            }
            buf.append("]");
        }
        if (loc != null) {
            buf.append(" " + loc);
        }
        buf.append(" " + super.toString());
        return buf.toString();
    }
}

