/*
 * Decompiled with CFR 0.152.
 */
package org.tartarus.snowball;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.lucene.util.ArrayUtil;
import org.tartarus.snowball.Among;

public abstract class SnowballProgram {
    private char[] current = new char[8];
    protected int cursor;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected SnowballProgram() {
        this.setCurrent("");
    }

    public abstract boolean stem();

    public void setCurrent(String value) {
        this.current = value.toCharArray();
        this.cursor = 0;
        this.limit = value.length();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public String getCurrent() {
        return new String(this.current, 0, this.limit);
    }

    public void setCurrent(char[] text, int length) {
        this.current = text;
        this.cursor = 0;
        this.limit = length;
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public char[] getCurrentBuffer() {
        return this.current;
    }

    public int getCurrentBufferLength() {
        return this.limit;
    }

    protected void copy_from(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected boolean in_grouping(char[] s2, int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            return false;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] s2, int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            return false;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] s2, int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            ++this.cursor;
            return true;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] s2, int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            --this.cursor;
            return true;
        }
        if ((s2[(ch = (char)(ch - min2)) >> 3] & 1 << (ch & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean in_range(int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min2) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_range_b(int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min2) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_range(int min2, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch <= max && ch >= min2) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean out_range_b(int min2, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch <= max && ch >= min2) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean eq_s(int s_size, CharSequence s2) {
        if (this.limit - this.cursor < s_size) {
            return false;
        }
        for (int i2 = 0; i2 != s_size; ++i2) {
            if (this.current[this.cursor + i2] == s2.charAt(i2)) continue;
            return false;
        }
        this.cursor += s_size;
        return true;
    }

    protected boolean eq_s_b(int s_size, CharSequence s2) {
        if (this.cursor - this.limit_backward < s_size) {
            return false;
        }
        for (int i2 = 0; i2 != s_size; ++i2) {
            if (this.current[this.cursor - s_size + i2] == s2.charAt(i2)) continue;
            return false;
        }
        this.cursor -= s_size;
        return true;
    }

    protected boolean eq_v(CharSequence s2) {
        return this.eq_s(s2.length(), s2);
    }

    protected boolean eq_v_b(CharSequence s2) {
        return this.eq_s_b(s2.length(), s2);
    }

    protected int find_among(Among[] v2, int v_size) {
        Among w2;
        int i2 = 0;
        int j2 = v_size;
        int c2 = this.cursor;
        int l2 = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k2 = i2 + (j2 - i2 >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w3 = v2[k2];
            for (int i22 = common; i22 < w3.s_size; ++i22) {
                if (c2 + common == l2) {
                    diff = -1;
                    break;
                }
                diff = this.current[c2 + common] - w3.s[i22];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j2 = k2;
                common_j = common;
            } else {
                i2 = k2;
                common_i = common;
            }
            if (j2 - i2 > 1) continue;
            if (i2 > 0 || j2 == i2 || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w2 = v2[i2];
            if (common_i < w2.s_size) continue;
            this.cursor = c2 + w2.s_size;
            if (w2.method == null) {
                return w2.result;
            }
            boolean res = false;
            try {
                res = w2.method.invokeExact(this);
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new UndeclaredThrowableException(e3);
            }
            this.cursor = c2 + w2.s_size;
            if (!res) continue;
            return w2.result;
        } while ((i2 = w2.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] v2, int v_size) {
        Among w2;
        int i2 = 0;
        int j2 = v_size;
        int c2 = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k2 = i2 + (j2 - i2 >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w3 = v2[k2];
            for (int i22 = w3.s_size - 1 - common; i22 >= 0; --i22) {
                if (c2 - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.current[c2 - 1 - common] - w3.s[i22];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j2 = k2;
                common_j = common;
            } else {
                i2 = k2;
                common_i = common;
            }
            if (j2 - i2 > 1) continue;
            if (i2 > 0 || j2 == i2 || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w2 = v2[i2];
            if (common_i < w2.s_size) continue;
            this.cursor = c2 - w2.s_size;
            if (w2.method == null) {
                return w2.result;
            }
            boolean res = false;
            try {
                res = w2.method.invokeExact(this);
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                throw new UndeclaredThrowableException(e3);
            }
            this.cursor = c2 - w2.s_size;
            if (!res) continue;
            return w2.result;
        } while ((i2 = w2.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int c_bra, int c_ket, CharSequence s2) {
        int adjustment = s2.length() - (c_ket - c_bra);
        int newLength = this.limit + adjustment;
        if (newLength > this.current.length) {
            char[] newBuffer = new char[ArrayUtil.oversize(newLength, 2)];
            System.arraycopy(this.current, 0, newBuffer, 0, this.limit);
            this.current = newBuffer;
        }
        if (adjustment != 0 && c_ket < this.limit) {
            System.arraycopy(this.current, c_ket, this.current, c_bra + s2.length(), this.limit - c_ket);
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            this.current[c_bra + i2] = s2.charAt(i2);
        }
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    protected void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit) {
            throw new IllegalArgumentException("faulty slice operation: bra=" + this.bra + ",ket=" + this.ket + ",limit=" + this.limit);
        }
    }

    protected void slice_from(CharSequence s2) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, s2);
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int c_bra, int c_ket, CharSequence s2) {
        int adjustment = this.replace_s(c_bra, c_ket, s2);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected StringBuilder slice_to(StringBuilder s2) {
        this.slice_check();
        int len = this.ket - this.bra;
        s2.setLength(0);
        s2.append(this.current, this.bra, len);
        return s2;
    }

    protected StringBuilder assign_to(StringBuilder s2) {
        s2.setLength(0);
        s2.append(this.current, 0, this.limit);
        return s2;
    }
}

