/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.JavaToken;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.CommentsCollection;
import com.github.javaparser.utils.Utils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class ParseResult<T> {
    private final T result;
    private final List<Problem> problems;
    private final List<JavaToken> tokens;
    private final CommentsCollection commentsCollection;

    public ParseResult(T result, List<Problem> problems, List<JavaToken> tokens, CommentsCollection commentsCollection) {
        this.commentsCollection = commentsCollection;
        this.result = result;
        this.problems = problems;
        this.tokens = tokens;
    }

    public boolean isSuccessful() {
        return this.problems.isEmpty() && this.result != null;
    }

    public void ifSuccessful(Consumer<T> consumer) {
        if (this.isSuccessful()) {
            consumer.accept(this.result);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Problem getProblem(int i2) {
        return this.getProblems().get(i2);
    }

    @Deprecated
    public Optional<List<JavaToken>> getTokens() {
        return Optional.ofNullable(this.tokens);
    }

    public Optional<CommentsCollection> getCommentsCollection() {
        return Optional.ofNullable(this.commentsCollection);
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "Parsing successful";
        }
        StringBuilder message = new StringBuilder("Parsing failed:").append(Utils.EOL);
        for (Problem problem : this.problems) {
            message.append(problem.toString()).append(Utils.EOL);
        }
        return message.toString();
    }

    public static interface PostProcessor {
        public void process(ParseResult<? extends Node> var1, ParserConfiguration var2);
    }
}

