/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.nodeTypes;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.type.Type;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface NodeWithParameters<N extends Node> {
    public NodeList<Parameter> getParameters();

    default public Parameter getParameter(int i2) {
        return (Parameter)this.getParameters().get(i2);
    }

    public void tryAddImportToParentCompilationUnit(Class<?> var1);

    default public N setParameter(int i2, Parameter parameter) {
        this.getParameters().set(i2, parameter);
        return (N)((Node)((Object)this));
    }

    public N setParameters(NodeList<Parameter> var1);

    default public N addParameter(Type type, String name) {
        return this.addParameter(new Parameter(type, name));
    }

    default public N addParameter(Class<?> paramClass, String name) {
        this.tryAddImportToParentCompilationUnit(paramClass);
        return this.addParameter(JavaParser.parseType(paramClass.getSimpleName()), name);
    }

    default public N addParameter(String className, String name) {
        return this.addParameter(JavaParser.parseType(className), name);
    }

    default public N addParameter(Parameter parameter) {
        this.getParameters().add(parameter);
        return (N)((Node)((Object)this));
    }

    default public Parameter addAndGetParameter(Type type, String name) {
        return this.addAndGetParameter(new Parameter(type, name));
    }

    default public Parameter addAndGetParameter(Class<?> paramClass, String name) {
        this.tryAddImportToParentCompilationUnit(paramClass);
        return this.addAndGetParameter(JavaParser.parseType(paramClass.getSimpleName()), name);
    }

    default public Parameter addAndGetParameter(String className, String name) {
        return this.addAndGetParameter(JavaParser.parseType(className), name);
    }

    default public Parameter addAndGetParameter(Parameter parameter) {
        this.getParameters().add(parameter);
        return parameter;
    }

    default public Optional<Parameter> getParameterByName(String name) {
        return this.getParameters().stream().filter(p2 -> p2.getNameAsString().equals(name)).findFirst();
    }

    default public Optional<Parameter> getParameterByType(String type) {
        return this.getParameters().stream().filter(p2 -> p2.getType().toString().equals(type)).findFirst();
    }

    default public Optional<Parameter> getParameterByType(Class<?> type) {
        return this.getParameters().stream().filter(p2 -> p2.getType().toString().equals(type.getSimpleName())).findFirst();
    }

    default public boolean hasParametersOfType(String ... paramTypes) {
        return this.getParameters().stream().map(p2 -> p2.getType().toString()).collect(Collectors.toSet()).equals(Stream.of(paramTypes).collect(Collectors.toSet()));
    }

    default public boolean hasParametersOfType(Class<?> ... paramTypes) {
        return this.getParameters().stream().map(p2 -> p2.getType().toString()).collect(Collectors.toSet()).equals(Stream.of(paramTypes).map(Class::getSimpleName).collect(Collectors.toSet()));
    }
}

