/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.validator.SimpleValidator;
import com.github.javaparser.ast.validator.SingleNodeTypeValidator;
import com.github.javaparser.ast.validator.TreeVisitorValidator;
import com.github.javaparser.ast.validator.Validator;
import com.github.javaparser.ast.validator.Validators;
import com.github.javaparser.ast.validator.chunks.CommonValidators;
import com.github.javaparser.ast.validator.chunks.ModifierValidator;
import com.github.javaparser.ast.validator.chunks.NoBinaryIntegerLiteralsValidator;
import com.github.javaparser.ast.validator.chunks.NoUnderscoresInIntegerLiteralsValidator;

public class Java1_0Validator
extends Validators {
    protected final Validator modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods = new ModifierValidator(false, false, false);
    protected final Validator noAssertKeyword = new SimpleValidator<AssertStmt>(AssertStmt.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "'assert' keyword is not supported.", new Object[0]));
    protected final Validator noInnerClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, n2 -> !n2.isTopLevelType(), (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "inner classes or interfaces are not supported.", new Object[0]));
    protected final Validator noReflection = new SimpleValidator<ClassExpr>(ClassExpr.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Reflection is not supported.", new Object[0]));
    protected final Validator noGenerics = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof NodeWithTypeArguments && ((NodeWithTypeArguments)((Object)node)).getTypeArguments().isPresent()) {
            reporter.report(node, "Generics are not supported.", new Object[0]);
        }
        if (node instanceof NodeWithTypeParameters && ((NodeWithTypeParameters)((Object)node)).getTypeParameters().isNonEmpty()) {
            reporter.report(node, "Generics are not supported.", new Object[0]);
        }
    });
    protected final SingleNodeTypeValidator<TryStmt> tryWithoutResources = new SingleNodeTypeValidator<TryStmt>(TryStmt.class, (n2, reporter) -> {
        if (n2.getCatchClauses().isEmpty() && !n2.getFinallyBlock().isPresent()) {
            reporter.report(n2, "Try has no finally and no catch.", new Object[0]);
        }
        if (n2.getResources().isNonEmpty()) {
            reporter.report(n2, "Catch with resource is not supported.", new Object[0]);
        }
    });
    protected final Validator noAnnotations = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof AnnotationExpr || node instanceof AnnotationDeclaration) {
            reporter.report(node, "Annotations are not supported.", new Object[0]);
        }
    });
    protected final Validator noEnums = new SimpleValidator<EnumDeclaration>(EnumDeclaration.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Enumerations are not supported.", new Object[0]));
    protected final Validator noVarargs = new SimpleValidator<Parameter>(Parameter.class, Parameter::isVarArgs, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Varargs are not supported.", new Object[0]));
    protected final Validator noForEach = new SimpleValidator<ForeachStmt>(ForeachStmt.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "For-each loops are not supported.", new Object[0]));
    protected final Validator noStaticImports = new SimpleValidator<ImportDeclaration>(ImportDeclaration.class, ImportDeclaration::isStatic, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Static imports are not supported.", new Object[0]));
    protected final Validator noStringsInSwitch = new SimpleValidator<SwitchEntryStmt>(SwitchEntryStmt.class, n2 -> n2.getLabel().map(l2 -> l2 instanceof StringLiteralExpr).orElse(false), (n2, reporter) -> reporter.report(n2.getLabel().get(), "Strings in switch statements are not supported.", new Object[0]));
    protected final Validator noBinaryIntegerLiterals = new NoBinaryIntegerLiteralsValidator();
    protected final Validator noUnderscoresInIntegerLiterals = new NoUnderscoresInIntegerLiteralsValidator();
    protected final Validator noMultiCatch = new SimpleValidator<UnionType>(UnionType.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Multi-catch is not supported.", new Object[0]));
    protected final Validator noLambdas = new SimpleValidator<LambdaExpr>(LambdaExpr.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Lambdas are not supported.", new Object[0]));
    protected final Validator noModules = new SimpleValidator<ModuleDeclaration>(ModuleDeclaration.class, n2 -> true, (n2, reporter) -> reporter.report((NodeWithTokenRange<?>)n2, "Modules are not supported.", new Object[0]));

    public Java1_0Validator() {
        super(new CommonValidators());
        this.add(this.modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods);
        this.add(this.noAssertKeyword);
        this.add(this.noInnerClasses);
        this.add(this.noReflection);
        this.add(this.noGenerics);
        this.add(this.tryWithoutResources);
        this.add(this.noAnnotations);
        this.add(this.noEnums);
        this.add(this.noVarargs);
        this.add(this.noForEach);
        this.add(this.noStaticImports);
        this.add(this.noStringsInSwitch);
        this.add(this.noBinaryIntegerLiterals);
        this.add(this.noUnderscoresInIntegerLiterals);
        this.add(this.noMultiCatch);
        this.add(this.noLambdas);
        this.add(this.noModules);
    }
}

