/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator.chunks;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.ast.validator.TypedValidator;
import java.util.Optional;

public class VarValidator
implements TypedValidator<VarType> {
    private boolean varAllowedInLambdaParameters;

    public VarValidator(boolean varAllowedInLambdaParameters) {
        this.varAllowedInLambdaParameters = varAllowedInLambdaParameters;
    }

    @Override
    public void accept(VarType node, ProblemReporter reporter) {
        Optional<VariableDeclarator> variableDeclarator = node.findParent(VariableDeclarator.class);
        if (!variableDeclarator.isPresent()) {
            boolean valid;
            if (this.varAllowedInLambdaParameters && (valid = node.findParent(Parameter.class).flatMap(Node::getParentNode).map(p2 -> p2 instanceof LambdaExpr).orElse(false).booleanValue())) {
                return;
            }
            this.reportIllegalPosition(node, reporter);
            return;
        }
        variableDeclarator.ifPresent(vd -> {
            Optional<Node> variableDeclarationExpr = vd.getParentNode();
            if (!variableDeclarationExpr.isPresent()) {
                this.reportIllegalPosition(node, reporter);
                return;
            }
            variableDeclarationExpr.ifPresent(vdeNode -> {
                Optional<Node> container;
                if (!(vdeNode instanceof VariableDeclarationExpr)) {
                    this.reportIllegalPosition(node, reporter);
                    return;
                }
                VariableDeclarationExpr vde = (VariableDeclarationExpr)vdeNode;
                if (vde.getVariables().size() > 1) {
                    reporter.report(vde, "\"var\" only takes a single variable.", new Object[0]);
                }
                if (!(container = vdeNode.getParentNode()).isPresent()) {
                    this.reportIllegalPosition(node, reporter);
                    return;
                }
                container.ifPresent(c2 -> {
                    boolean positionIsFine;
                    boolean bl = positionIsFine = c2 instanceof ForStmt || c2 instanceof ForeachStmt || c2 instanceof ExpressionStmt;
                    if (!positionIsFine) {
                        this.reportIllegalPosition(node, reporter);
                    }
                    if (c2 instanceof ExpressionStmt) {
                        if (!vd.getInitializer().isPresent()) {
                            reporter.report(node, "\"var\" needs an initializer.", new Object[0]);
                        }
                        vd.getInitializer().ifPresent(initializer -> {
                            if (initializer instanceof NullLiteralExpr) {
                                reporter.report(node, "\"var\" cannot infer type from just null.", new Object[0]);
                            }
                            if (initializer instanceof ArrayCreationExpr) {
                                reporter.report(node, "\"var\" cannot infer array types.", new Object[0]);
                            }
                        });
                    }
                });
            });
        });
    }

    private void reportIllegalPosition(VarType n2, ProblemReporter reporter) {
        reporter.report(n2, "\"var\" is not allowed here.", new Object[0]);
    }
}

