/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.types;

import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ResolvedUnionType
implements ResolvedType {
    private List<ResolvedType> elements;

    public ResolvedUnionType(List<ResolvedType> elements) {
        if (elements.size() < 2) {
            throw new IllegalArgumentException("An union type should have at least two elements. This has " + elements.size());
        }
        this.elements = new LinkedList<ResolvedType>(elements);
    }

    public Optional<ResolvedReferenceType> getCommonAncestor() {
        Optional<List> reduce = this.elements.stream().map(ResolvedType::asReferenceType).map(ResolvedReferenceType::getAllAncestors).reduce((a2, b2) -> {
            ArrayList common = new ArrayList(a2);
            common.retainAll((Collection<?>)b2);
            return common;
        });
        return ((List)reduce.orElse(new ArrayList())).stream().findFirst();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ResolvedUnionType that = (ResolvedUnionType)o2;
        return new HashSet<ResolvedType>(this.elements).equals(new HashSet<ResolvedType>(that.elements));
    }

    public int hashCode() {
        return new HashSet<ResolvedType>(this.elements).hashCode();
    }

    @Override
    public String describe() {
        return String.join((CharSequence)" | ", this.elements.stream().map(ResolvedType::describe).collect(Collectors.toList()));
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        return this.elements.stream().allMatch(e2 -> e2.isAssignableBy(other));
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public ResolvedUnionType asUnionType() {
        return this;
    }
}

