/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.NoSuchElementException;

class LineIterator
implements PathIterator {
    Line2D line;
    BaseTransform transform;
    int index;

    LineIterator(Line2D line2D, BaseTransform baseTransform) {
        this.line = line2D;
        this.transform = baseTransform;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] fArray) {
        int n2;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            fArray[0] = this.line.x1;
            fArray[1] = this.line.y1;
            n2 = 0;
        } else {
            fArray[0] = this.line.x2;
            fArray[1] = this.line.y2;
            n2 = 1;
        }
        if (this.transform != null) {
            this.transform.transform(fArray, 0, fArray, 0, 1);
        }
        return n2;
    }
}

