/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

public abstract class SelectedItemsReadOnlyObservableList<E>
extends ObservableListBase<E> {
    private final ObservableList<Integer> selectedIndices;
    private ObservableList<E> itemsList;
    private boolean itemsListChanged = false;
    private ListChangeListener.Change<? extends E> itemsListChange;
    private final ListChangeListener itemsListListener = change -> {
        this.itemsListChanged = true;
        this.itemsListChange = change;
    };
    private final Supplier<Integer> modelSizeSupplier;
    private final List<WeakReference<E>> itemsRefList;

    public SelectedItemsReadOnlyObservableList(ObservableList<Integer> observableList, Supplier<Integer> supplier) {
        this.modelSizeSupplier = supplier;
        this.selectedIndices = observableList;
        this.itemsRefList = new ArrayList<WeakReference<E>>();
        observableList.addListener((ListChangeListener.Change<? super E> change) -> {
            this.beginChange();
            while (change.next()) {
                if (change.wasReplaced()) {
                    List<E> list;
                    List<E> list2 = this.getRemovedElements(change);
                    if (list2.equals(list = this.getAddedElements(change))) continue;
                    this.nextReplace(change.getFrom(), change.getTo(), list2);
                    continue;
                }
                if (change.wasAdded()) {
                    this.nextAdd(change.getFrom(), change.getTo());
                    continue;
                }
                if (change.wasRemoved()) {
                    int n2 = change.getRemovedSize();
                    if (n2 == 1) {
                        this.nextRemove(change.getFrom(), this.getRemovedModelItem(change.getFrom()));
                        continue;
                    }
                    this.nextRemove(change.getFrom(), this.getRemovedElements(change));
                    continue;
                }
                if (change.wasPermutated()) {
                    int[] nArray = new int[this.size()];
                    for (int i2 = 0; i2 < this.size(); ++i2) {
                        nArray[i2] = change.getPermutation(i2);
                    }
                    this.nextPermutation(change.getFrom(), change.getTo(), nArray);
                    continue;
                }
                if (!change.wasUpdated()) continue;
                for (int i3 = change.getFrom(); i3 < change.getTo(); ++i3) {
                    this.nextUpdate(i3);
                }
            }
            this.itemsRefList.clear();
            Iterator iterator = observableList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                this.itemsRefList.add(new WeakReference<E>(this.getModelItem(n3)));
            }
            this.itemsListChanged = false;
            this.itemsListChange = null;
            this.endChange();
        });
    }

    protected abstract E getModelItem(int var1);

    @Override
    public E get(int n2) {
        int n3 = (Integer)this.selectedIndices.get(n2);
        return this.getModelItem(n3);
    }

    @Override
    public int size() {
        return this.selectedIndices.size();
    }

    public void setItemsList(ObservableList<E> observableList) {
        if (this.itemsList != null) {
            this.itemsList.removeListener(this.itemsListListener);
        }
        this.itemsList = observableList;
        if (observableList != null) {
            observableList.addListener(this.itemsListListener);
        }
    }

    private E _getModelItem(int n2) {
        if (n2 >= this.modelSizeSupplier.get()) {
            return this.getRemovedModelItem(n2);
        }
        return this.getModelItem(n2);
    }

    private E getRemovedModelItem(int n2) {
        return n2 < 0 || n2 >= this.itemsRefList.size() ? null : (E)this.itemsRefList.get(n2).get();
    }

    private List<E> getRemovedElements(ListChangeListener.Change<? extends Integer> change) {
        int n2;
        ArrayList<E> arrayList = new ArrayList<E>(change.getRemovedSize());
        int n3 = n2 + change.getRemovedSize();
        for (int i2 = n2 = change.getFrom(); i2 < n3; ++i2) {
            arrayList.add(this.getRemovedModelItem(i2));
        }
        return arrayList;
    }

    private List<E> getAddedElements(ListChangeListener.Change<? extends Integer> change) {
        ArrayList<E> arrayList = new ArrayList<E>(change.getAddedSize());
        Iterator<? extends Integer> iterator = change.getAddedSubList().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            arrayList.add(this._getModelItem(n2));
        }
        return arrayList;
    }
}

