/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;

public final class CollinearSimplifier
implements PathConsumer2D {
    static final float EPS = 1.0E-4f;
    PathConsumer2D delegate;
    SimplifierState state;
    float px1;
    float py1;
    float px2;
    float py2;
    float pslope;

    CollinearSimplifier() {
    }

    public CollinearSimplifier init(PathConsumer2D pathConsumer2D) {
        this.delegate = pathConsumer2D;
        this.state = SimplifierState.Empty;
        return this;
    }

    @Override
    public void pathDone() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.emitStashedLine();
        this.state = SimplifierState.Empty;
        this.delegate.closePath();
    }

    @Override
    public void quadTo(float f2, float f3, float f4, float f5) {
        this.emitStashedLine();
        this.delegate.quadTo(f2, f3, f4, f5);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = f4;
        this.py1 = f5;
    }

    @Override
    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.emitStashedLine();
        this.delegate.curveTo(f2, f3, f4, f5, f6, f7);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = f6;
        this.py1 = f7;
    }

    @Override
    public void moveTo(float f2, float f3) {
        this.emitStashedLine();
        this.delegate.moveTo(f2, f3);
        this.state = SimplifierState.PreviousPoint;
        this.px1 = f2;
        this.py1 = f3;
    }

    @Override
    public void lineTo(float f2, float f3) {
        switch (this.state) {
            case Empty: {
                this.delegate.lineTo(f2, f3);
                this.state = SimplifierState.PreviousPoint;
                this.px1 = f2;
                this.py1 = f3;
                return;
            }
            case PreviousPoint: {
                this.state = SimplifierState.PreviousLine;
                this.px2 = f2;
                this.py2 = f3;
                this.pslope = CollinearSimplifier.getSlope(this.px1, this.py1, f2, f3);
                return;
            }
            case PreviousLine: {
                float f4 = CollinearSimplifier.getSlope(this.px2, this.py2, f2, f3);
                if (f4 == this.pslope || Math.abs(this.pslope - f4) < 1.0E-4f) {
                    this.px2 = f2;
                    this.py2 = f3;
                    return;
                }
                this.delegate.lineTo(this.px2, this.py2);
                this.px1 = this.px2;
                this.py1 = this.py2;
                this.px2 = f2;
                this.py2 = f3;
                this.pslope = f4;
                return;
            }
        }
    }

    private void emitStashedLine() {
        if (this.state == SimplifierState.PreviousLine) {
            this.delegate.lineTo(this.px2, this.py2);
        }
    }

    private static float getSlope(float f2, float f3, float f4, float f5) {
        float f6 = f5 - f3;
        if (f6 == 0.0f) {
            return f4 > f2 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        return (f4 - f2) / f6;
    }

    static enum SimplifierState {
        Empty,
        PreviousPoint,
        PreviousLine;

    }
}

