/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DHelpers;

final class DCurve {
    double ax;
    double ay;
    double bx;
    double by;
    double cx;
    double cy;
    double dx;
    double dy;
    double dax;
    double day;
    double dbx;
    double dby;

    DCurve() {
    }

    void set(double[] dArray, int n2) {
        if (n2 == 8) {
            this.set(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
        } else if (n2 == 4) {
            this.set(dArray[0], dArray[1], dArray[2], dArray[3]);
        } else {
            this.set(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        }
    }

    void set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = 3.0 * (d6 - d4);
        double d11 = 3.0 * (d7 - d5);
        double d12 = 3.0 * (d4 - d2);
        double d13 = 3.0 * (d5 - d3);
        this.ax = d8 - d2 - d10;
        this.ay = d9 - d3 - d11;
        this.bx = d10 - d12;
        this.by = d11 - d13;
        this.cx = d12;
        this.cy = d13;
        this.dx = d2;
        this.dy = d3;
        this.dax = 3.0 * this.ax;
        this.day = 3.0 * this.ay;
        this.dbx = 2.0 * this.bx;
        this.dby = 2.0 * this.by;
    }

    void set(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 - d2;
        double d9 = d5 - d3;
        this.ax = 0.0;
        this.ay = 0.0;
        this.bx = d6 - d4 - d8;
        this.by = d7 - d5 - d9;
        this.cx = 2.0 * d8;
        this.cy = 2.0 * d9;
        this.dx = d2;
        this.dy = d3;
        this.dax = 0.0;
        this.day = 0.0;
        this.dbx = 2.0 * this.bx;
        this.dby = 2.0 * this.by;
    }

    void set(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        this.ax = 0.0;
        this.ay = 0.0;
        this.bx = 0.0;
        this.by = 0.0;
        this.cx = d6;
        this.cy = d7;
        this.dx = d2;
        this.dy = d3;
        this.dax = 0.0;
        this.day = 0.0;
        this.dbx = 0.0;
        this.dby = 0.0;
    }

    int dxRoots(double[] dArray, int n2) {
        return DHelpers.quadraticRoots(this.dax, this.dbx, this.cx, dArray, n2);
    }

    int dyRoots(double[] dArray, int n2) {
        return DHelpers.quadraticRoots(this.day, this.dby, this.cy, dArray, n2);
    }

    int infPoints(double[] dArray, int n2) {
        double d2 = this.dax * this.dby - this.dbx * this.day;
        double d3 = 2.0 * (this.cy * this.dax - this.day * this.cx);
        double d4 = this.cy * this.dbx - this.cx * this.dby;
        return DHelpers.quadraticRoots(d2, d3, d4, dArray, n2);
    }

    int xPoints(double[] dArray, int n2, double d2) {
        return DHelpers.cubicRootsInAB(this.ax, this.bx, this.cx, this.dx - d2, dArray, n2, 0.0, 1.0);
    }

    int yPoints(double[] dArray, int n2, double d2) {
        return DHelpers.cubicRootsInAB(this.ay, this.by, this.cy, this.dy - d2, dArray, n2, 0.0, 1.0);
    }

    private int perpendiculardfddf(double[] dArray, int n2) {
        assert (dArray.length >= n2 + 4);
        double d2 = 2.0 * (this.dax * this.dax + this.day * this.day);
        double d3 = 3.0 * (this.dax * this.dbx + this.day * this.dby);
        double d4 = 2.0 * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        double d5 = this.dbx * this.cx + this.dby * this.cy;
        return DHelpers.cubicRootsInAB(d2, d3, d4, d5, dArray, n2, 0.0, 1.0);
    }

    int rootsOfROCMinusW(double[] dArray, int n2, double d2, double d3) {
        assert (n2 <= 6 && dArray.length >= 10);
        int n3 = n2;
        int n4 = n2 + this.perpendiculardfddf(dArray, n2);
        dArray[n4] = 1.0;
        double d4 = 0.0;
        double d5 = this.ROCsq(d4) - d2;
        for (int i2 = n2; i2 <= n4; ++i2) {
            double d6 = dArray[i2];
            double d7 = this.ROCsq(d6) - d2;
            if (d5 == 0.0) {
                dArray[n3++] = d4;
            } else if (d7 * d5 < 0.0) {
                dArray[n3++] = this.falsePositionROCsqMinusX(d4, d6, d2, d3);
            }
            d4 = d6;
            d5 = d7;
        }
        return n3 - n2;
    }

    private static double eliminateInf(double d2) {
        return d2 == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : (d2 == Double.NEGATIVE_INFINITY ? Double.MIN_VALUE : d2);
    }

    private double falsePositionROCsqMinusX(double d2, double d3, double d4, double d5) {
        int n2 = 0;
        double d6 = d3;
        double d7 = DCurve.eliminateInf(this.ROCsq(d6) - d4);
        double d8 = d2;
        double d9 = DCurve.eliminateInf(this.ROCsq(d8) - d4);
        double d10 = d8;
        for (int i2 = 0; i2 < 100 && Math.abs(d6 - d8) > d5 * Math.abs(d6 + d8); ++i2) {
            d10 = (d9 * d6 - d7 * d8) / (d9 - d7);
            double d11 = this.ROCsq(d10) - d4;
            if (DCurve.sameSign(d11, d7)) {
                d7 = d11;
                d6 = d10;
                if (n2 < 0) {
                    d9 /= (double)(1 << -n2);
                    --n2;
                    continue;
                }
                n2 = -1;
                continue;
            }
            if (!(d11 * d9 > 0.0)) break;
            d9 = d11;
            d8 = d10;
            if (n2 > 0) {
                d7 /= (double)(1 << n2);
                ++n2;
                continue;
            }
            n2 = 1;
        }
        return d10;
    }

    private static boolean sameSign(double d2, double d3) {
        return d2 < 0.0 && d3 < 0.0 || d2 > 0.0 && d3 > 0.0;
    }

    private double ROCsq(double d2) {
        double d3 = d2 * (d2 * this.dax + this.dbx) + this.cx;
        double d4 = d2 * (d2 * this.day + this.dby) + this.cy;
        double d5 = 2.0 * this.dax * d2 + this.dbx;
        double d6 = 2.0 * this.day * d2 + this.dby;
        double d7 = d3 * d3 + d4 * d4;
        double d8 = d5 * d5 + d6 * d6;
        double d9 = d5 * d3 + d6 * d4;
        return d7 * (d7 * d7 / (d7 * d8 - d9 * d9));
    }
}

