/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class FloatArrayCache
implements MarlinConst {
    final boolean clean;
    private final int bucketCapacity;
    private WeakReference<Bucket[]> refBuckets = null;
    final ArrayCacheConst.CacheStats stats;

    FloatArrayCache(boolean bl, int n2) {
        this.clean = bl;
        this.bucketCapacity = n2;
        this.stats = DO_STATS ? new ArrayCacheConst.CacheStats(FloatArrayCache.getLogPrefix(bl) + "FloatArrayCache") : null;
    }

    Bucket getCacheBucket(int n2) {
        int n3 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n3];
    }

    private Bucket[] getBuckets() {
        Bucket[] bucketArray;
        Bucket[] bucketArray2 = bucketArray = this.refBuckets != null ? (Bucket[])this.refBuckets.get() : null;
        if (bucketArray == null) {
            bucketArray = new Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                bucketArray[i2] = new Bucket(this.clean, ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<Bucket[]>(bucketArray);
        }
        return bucketArray;
    }

    Reference createRef(int n2) {
        return new Reference(this, n2);
    }

    static float[] createArray(int n2) {
        return new float[n2];
    }

    static void fill(float[] fArray, int n2, int n3, float f2) {
        Arrays.fill(fArray, n2, n3, f2);
        if (DO_CHECKS) {
            FloatArrayCache.check(fArray, n2, n3, f2);
        }
    }

    public static void check(float[] fArray, int n2, int n3, float f2) {
        if (DO_CHECKS) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                if (fArray[i2] == f2) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + fArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(fArray), new Throwable());
                Arrays.fill(fArray, f2);
                return;
            }
        }
    }

    static String getLogPrefix(boolean bl) {
        return bl ? "Clean" : "Dirty";
    }

    static final class Bucket {
        private int tail = 0;
        private final int arraySize;
        private final boolean clean;
        private final float[][] arrays;
        private final ArrayCacheConst.BucketStats stats;

        Bucket(boolean bl, int n2, int n3, ArrayCacheConst.BucketStats bucketStats) {
            this.arraySize = n2;
            this.clean = bl;
            this.stats = bucketStats;
            this.arrays = new float[n3][];
        }

        float[] getArray() {
            if (MarlinConst.DO_STATS) {
                ++this.stats.getOp;
            }
            if (this.tail != 0) {
                float[] fArray = this.arrays[--this.tail];
                this.arrays[this.tail] = null;
                return fArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.createOp;
            }
            return FloatArrayCache.createArray(this.arraySize);
        }

        void putArray(float[] fArray) {
            if (MarlinConst.DO_CHECKS && fArray.length != this.arraySize) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: bad length = " + fArray.length);
                return;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.returnOp;
            }
            if (this.arrays.length > this.tail) {
                this.arrays[this.tail++] = fArray;
                if (MarlinConst.DO_STATS) {
                    this.stats.updateMaxSize(this.tail);
                }
            } else if (MarlinConst.DO_CHECKS) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: array capacity exceeded !");
            }
        }
    }

    static final class Reference {
        final float[] initial;
        private final boolean clean;
        private final FloatArrayCache cache;

        Reference(FloatArrayCache floatArrayCache, int n2) {
            this.cache = floatArrayCache;
            this.clean = floatArrayCache.clean;
            this.initial = FloatArrayCache.createArray(n2);
            if (MarlinConst.DO_STATS) {
                floatArrayCache.stats.totalInitial += (long)n2;
            }
        }

        float[] getArray(int n2) {
            if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                return this.cache.getCacheBucket(n2).getArray();
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.oversize;
            }
            if (MarlinConst.DO_LOG_OVERSIZE) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: getArray[oversize]: length=\t" + n2);
            }
            return FloatArrayCache.createArray(n2);
        }

        float[] widenArray(float[] fArray, int n2, int n3) {
            int n4 = fArray.length;
            if (MarlinConst.DO_CHECKS && n4 >= n3) {
                return fArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.resize;
            }
            float[] fArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            this.putArray(fArray, 0, n2);
            if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: widenArray[" + fArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
            }
            return fArray2;
        }

        float[] putArray(float[] fArray) {
            return this.putArray(fArray, 0, fArray.length);
        }

        float[] putArray(float[] fArray, int n2, int n3) {
            if (fArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                if (this.clean && n3 != 0) {
                    FloatArrayCache.fill(fArray, n2, n3, 0.0f);
                }
                if (fArray != this.initial) {
                    this.cache.getCacheBucket(fArray.length).putArray(fArray);
                }
            }
            return this.initial;
        }
    }
}

