/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

final class HLSConnectionHolder
extends ConnectionHolder {
    private URLConnection urlConnection = null;
    private PlaylistThread playlistThread = new PlaylistThread();
    private VariantPlaylist variantPlaylist = null;
    private Playlist currentPlaylist = null;
    private int mediaFileIndex = -1;
    private CountDownLatch readySignal = new CountDownLatch(1);
    private Semaphore liveSemaphore = new Semaphore(0);
    private boolean isPlaylistClosed = false;
    private boolean isBitrateAdjustable = false;
    private long startTime = -1L;
    private static final long HLS_VALUE_FLOAT_MULTIPLIER = 1000L;
    private static final int HLS_PROP_GET_DURATION = 1;
    private static final int HLS_PROP_GET_HLS_MODE = 2;
    private static final int HLS_PROP_GET_MIMETYPE = 3;
    private static final int HLS_VALUE_MIMETYPE_MP2T = 1;
    private static final int HLS_VALUE_MIMETYPE_MP3 = 2;
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_US_ASCII = "US-ASCII";

    HLSConnectionHolder(URI uRI) throws IOException {
        this.playlistThread.setPlaylistURI(uRI);
        this.init();
    }

    private void init() {
        this.playlistThread.putState(0);
        this.playlistThread.start();
    }

    @Override
    public int readNextBlock() throws IOException {
        if (this.isBitrateAdjustable && this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        int n2 = super.readNextBlock();
        if (this.isBitrateAdjustable && n2 == -1) {
            long l2 = System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
            this.adjustBitrate(l2);
        }
        return n2;
    }

    @Override
    int readBlock(long l2, int n2) throws IOException {
        throw new IOException();
    }

    @Override
    boolean needBuffer() {
        return true;
    }

    @Override
    boolean isSeekable() {
        return true;
    }

    @Override
    boolean isRandomAccess() {
        return false;
    }

    @Override
    public long seek(long l2) {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1L;
        }
        return (long)(this.currentPlaylist.seek(l2) * 1000.0);
    }

    @Override
    public void closeConnection() {
        this.currentPlaylist.close();
        super.closeConnection();
        this.resetConnection();
        this.playlistThread.putState(1);
    }

    @Override
    int property(int n2, int n3) {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1;
        }
        if (n2 == 1) {
            return (int)(this.currentPlaylist.getDuration() * 1000.0);
        }
        if (n2 == 2) {
            return 1;
        }
        if (n2 == 3) {
            return this.currentPlaylist.getMimeType();
        }
        return -1;
    }

    @Override
    int getStreamSize() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            return -1;
        }
        return this.loadNextSegment();
    }

    private void resetConnection() {
        super.closeConnection();
        Locator.closeConnection(this.urlConnection);
        this.urlConnection = null;
    }

    private int loadNextSegment() {
        this.resetConnection();
        String string = this.currentPlaylist.getNextMediaFile();
        if (string == null) {
            return -1;
        }
        try {
            URI uRI = new URI(string);
            this.urlConnection = uRI.toURL().openConnection();
            this.channel = this.openChannel();
        }
        catch (Exception exception) {
            return -1;
        }
        if (this.currentPlaylist.isCurrentMediaFileDiscontinuity()) {
            return -1 * this.urlConnection.getContentLength();
        }
        return this.urlConnection.getContentLength();
    }

    private ReadableByteChannel openChannel() throws IOException {
        return Channels.newChannel(this.urlConnection.getInputStream());
    }

    private void adjustBitrate(long l2) {
        int n2 = (int)((long)this.urlConnection.getContentLength() * 8L * 1000L / l2);
        Playlist playlist = this.variantPlaylist.getPlaylistBasedOnBitrate(n2);
        if (playlist != null && playlist != this.currentPlaylist) {
            if (this.currentPlaylist.isLive()) {
                playlist.update(this.currentPlaylist.getNextMediaFile());
                this.playlistThread.setReloadPlaylist(playlist);
            }
            playlist.setForceDiscontinuity(true);
            this.currentPlaylist = playlist;
        }
    }

    private static String stripParameters(String string) {
        int n2 = string.indexOf(63);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private class Playlist {
        private boolean isLive = false;
        private volatile boolean isLiveWaiting = false;
        private volatile boolean isLiveStop = false;
        private long targetDuration = 0L;
        private URI playlistURI = null;
        private final Object lock = new Object();
        private List<String> mediaFiles = new ArrayList<String>();
        private List<Double> mediaFilesStartTimes = new ArrayList<Double>();
        private List<Boolean> mediaFilesDiscontinuities = new ArrayList<Boolean>();
        private boolean needBaseURI = true;
        private String baseURI = null;
        private double duration = 0.0;
        private int sequenceNumber = -1;
        private int sequenceNumberStart = -1;
        private boolean sequenceNumberUpdated = false;
        private boolean forceDiscontinuity = false;

        private Playlist(boolean bl, int n2) {
            this.isLive = bl;
            this.targetDuration = n2 * 1000;
            if (bl) {
                this.duration = -1.0;
            }
        }

        private Playlist(URI uRI) {
            this.playlistURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(String string) {
            PlaylistParser playlistParser = new PlaylistParser();
            playlistParser.load(this.playlistURI);
            this.isLive = playlistParser.isLivePlaylist();
            this.targetDuration = playlistParser.getTargetDuration() * 1000;
            if (this.isLive) {
                this.duration = -1.0;
            }
            if (this.setSequenceNumber(playlistParser.getSequenceNumber())) {
                while (playlistParser.hasNext()) {
                    this.addMediaFile(playlistParser.getString(), playlistParser.getDouble(), playlistParser.getBoolean());
                }
            }
            if (string != null) {
                Object object = this.lock;
                synchronized (object) {
                    for (int i2 = 0; i2 < this.mediaFiles.size(); ++i2) {
                        String string2 = this.mediaFiles.get(i2);
                        if (!string.endsWith(string2)) continue;
                        HLSConnectionHolder.this.mediaFileIndex = i2 - 1;
                        break;
                    }
                }
            }
        }

        private boolean isLive() {
            return this.isLive;
        }

        private long getTargetDuration() {
            return this.targetDuration;
        }

        private void setPlaylistURI(URI uRI) {
            this.playlistURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMediaFile(String string, double d2, boolean bl) {
            Object object = this.lock;
            synchronized (object) {
                if (this.needBaseURI) {
                    this.setBaseURI(this.playlistURI.toString(), string);
                }
                if (this.isLive) {
                    if (this.sequenceNumberUpdated) {
                        int n2 = this.mediaFiles.indexOf(string);
                        if (n2 != -1) {
                            for (int i2 = 0; i2 < n2; ++i2) {
                                this.mediaFiles.remove(0);
                                this.mediaFilesDiscontinuities.remove(0);
                                if (HLSConnectionHolder.this.mediaFileIndex == -1) {
                                    this.forceDiscontinuity = true;
                                }
                                if (HLSConnectionHolder.this.mediaFileIndex < 0) continue;
                                --HLSConnectionHolder.this.mediaFileIndex;
                            }
                        }
                        this.sequenceNumberUpdated = false;
                    }
                    if (this.mediaFiles.contains(string)) {
                        return;
                    }
                }
                this.mediaFiles.add(string);
                this.mediaFilesDiscontinuities.add(bl);
                if (this.isLive) {
                    if (this.isLiveWaiting) {
                        HLSConnectionHolder.this.liveSemaphore.release();
                    }
                } else {
                    this.mediaFilesStartTimes.add(this.duration);
                    this.duration += d2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getNextMediaFile() {
            Object object;
            if (this.isLive) {
                object = this.lock;
                synchronized (object) {
                    this.isLiveWaiting = HLSConnectionHolder.this.mediaFileIndex + 1 >= this.mediaFiles.size();
                }
                if (this.isLiveWaiting) {
                    try {
                        HLSConnectionHolder.this.liveSemaphore.acquire();
                        this.isLiveWaiting = false;
                        if (this.isLiveStop) {
                            this.isLiveStop = false;
                            return null;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.isLiveWaiting = false;
                        return null;
                    }
                }
                if (HLSConnectionHolder.this.isPlaylistClosed) {
                    return null;
                }
            }
            object = this.lock;
            synchronized (object) {
                ++HLSConnectionHolder.this.mediaFileIndex;
                if (HLSConnectionHolder.this.mediaFileIndex < this.mediaFiles.size()) {
                    if (this.baseURI != null) {
                        return this.baseURI + this.mediaFiles.get(HLSConnectionHolder.this.mediaFileIndex);
                    }
                    return this.mediaFiles.get(HLSConnectionHolder.this.mediaFileIndex);
                }
                return null;
            }
        }

        private double getDuration() {
            return this.duration;
        }

        private void setForceDiscontinuity(boolean bl) {
            this.forceDiscontinuity = bl;
        }

        private boolean isCurrentMediaFileDiscontinuity() {
            if (this.forceDiscontinuity) {
                this.forceDiscontinuity = false;
                return true;
            }
            return this.mediaFilesDiscontinuities.get(HLSConnectionHolder.this.mediaFileIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double seek(long l2) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isLive) {
                    if (l2 == 0L) {
                        HLSConnectionHolder.this.mediaFileIndex = -1;
                        if (this.isLiveWaiting) {
                            this.isLiveStop = true;
                            HLSConnectionHolder.this.liveSemaphore.release();
                        }
                        return 0.0;
                    }
                } else {
                    l2 += this.targetDuration / 2000L;
                    int n2 = this.mediaFilesStartTimes.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!((double)l2 >= this.mediaFilesStartTimes.get(i2))) continue;
                        if (i2 + 1 < n2) {
                            if (!((double)l2 < this.mediaFilesStartTimes.get(i2 + 1))) continue;
                            HLSConnectionHolder.this.mediaFileIndex = i2 - 1;
                            return this.mediaFilesStartTimes.get(i2);
                        }
                        if ((double)(l2 - this.targetDuration / 2000L) < this.duration) {
                            HLSConnectionHolder.this.mediaFileIndex = i2 - 1;
                            return this.mediaFilesStartTimes.get(i2);
                        }
                        if (Double.compare(l2 - this.targetDuration / 2000L, this.duration) != 0) continue;
                        return this.duration;
                    }
                }
            }
            return -1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getMimeType() {
            Object object = this.lock;
            synchronized (object) {
                if (this.mediaFiles.size() > 0) {
                    if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".ts")) {
                        return 1;
                    }
                    if (HLSConnectionHolder.stripParameters(this.mediaFiles.get(0)).endsWith(".mp3")) {
                        return 2;
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getMediaFileExtension() {
            Object object = this.lock;
            synchronized (object) {
                String string;
                int n2;
                if (this.mediaFiles.size() > 0 && (n2 = (string = HLSConnectionHolder.stripParameters(this.mediaFiles.get(0))).lastIndexOf(".")) != -1) {
                    return string.substring(n2);
                }
            }
            return null;
        }

        private boolean setSequenceNumber(int n2) {
            if (this.sequenceNumberStart == -1) {
                this.sequenceNumberStart = n2;
            } else if (this.sequenceNumber != n2) {
                this.sequenceNumberUpdated = true;
                this.sequenceNumber = n2;
            } else {
                return false;
            }
            return true;
        }

        private void close() {
            if (this.isLive) {
                HLSConnectionHolder.this.isPlaylistClosed = true;
                HLSConnectionHolder.this.liveSemaphore.release();
            }
        }

        private void setBaseURI(String string, String string2) {
            if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
                this.baseURI = string.substring(0, string.lastIndexOf("/") + 1);
            }
            this.needBaseURI = false;
        }
    }

    private static class VariantPlaylist {
        private URI playlistURI = null;
        private int infoIndex = -1;
        private List<String> playlistsLocations = new ArrayList<String>();
        private List<Integer> playlistsBitrates = new ArrayList<Integer>();
        private List<Playlist> playlists = new ArrayList<Playlist>();
        private String mediaFileExtension = null;

        private VariantPlaylist(URI uRI) {
            this.playlistURI = uRI;
        }

        private void addPlaylistInfo(String string, int n2) {
            this.playlistsLocations.add(string);
            this.playlistsBitrates.add(n2);
        }

        private void addPlaylist(Playlist playlist) {
            if (this.mediaFileExtension == null) {
                this.mediaFileExtension = playlist.getMediaFileExtension();
            } else if (!this.mediaFileExtension.equals(playlist.getMediaFileExtension())) {
                this.playlistsLocations.remove(this.infoIndex);
                this.playlistsBitrates.remove(this.infoIndex);
                --this.infoIndex;
                return;
            }
            this.playlists.add(playlist);
        }

        private Playlist getPlaylist(int n2) {
            if (this.playlists.size() > n2) {
                return this.playlists.get(n2);
            }
            return null;
        }

        private boolean hasNext() {
            ++this.infoIndex;
            return this.playlistsLocations.size() > this.infoIndex && this.playlistsBitrates.size() > this.infoIndex;
        }

        private URI getPlaylistURI() throws URISyntaxException, MalformedURLException {
            String string = this.playlistsLocations.get(this.infoIndex);
            if (string.startsWith("http://") || string.startsWith("https://")) {
                return new URI(string);
            }
            return new URI(this.playlistURI.toURL().toString().substring(0, this.playlistURI.toURL().toString().lastIndexOf("/") + 1) + string);
        }

        private Playlist getPlaylistBasedOnBitrate(int n2) {
            int n3;
            int n4;
            int n5 = -1;
            int n6 = 0;
            for (n4 = 0; n4 < this.playlistsBitrates.size(); ++n4) {
                n3 = this.playlistsBitrates.get(n4);
                if (n3 >= n2) continue;
                if (n5 != -1) {
                    if (n3 <= n6) continue;
                    n6 = n3;
                    n5 = n4;
                    continue;
                }
                n5 = n4;
            }
            if (n5 == -1) {
                for (n4 = 0; n4 < this.playlistsBitrates.size(); ++n4) {
                    n3 = this.playlistsBitrates.get(n4);
                    if (n3 >= n6 && n5 != -1) continue;
                    n6 = n3;
                    n5 = n4;
                }
            }
            if (n5 < 0 || n5 >= this.playlists.size()) {
                return null;
            }
            return this.playlists.get(n5);
        }
    }

    private static class PlaylistParser {
        private boolean isFirstLine = true;
        private boolean isLineMediaFileURI = false;
        private boolean isEndList = false;
        private boolean isLinePlaylistURI = false;
        private boolean isVariantPlaylist = false;
        private boolean isDiscontinuity = false;
        private int targetDuration = 0;
        private int sequenceNumber = 0;
        private int dataListIndex = -1;
        private List<String> dataListString = new ArrayList<String>();
        private List<Integer> dataListInteger = new ArrayList<Integer>();
        private List<Double> dataListDouble = new ArrayList<Double>();
        private List<Boolean> dataListBoolean = new ArrayList<Boolean>();

        private PlaylistParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(URI uRI) {
            HttpURLConnection httpURLConnection = null;
            BufferedReader bufferedReader = null;
            try {
                Charset charset;
                httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
                httpURLConnection.setRequestMethod("GET");
                if (httpURLConnection.getResponseCode() != 200) {
                    MediaUtils.error(this, MediaError.ERROR_LOCATOR_CONNECTION_LOST.code(), "HTTP responce code: " + httpURLConnection.getResponseCode(), null);
                }
                if ((charset = this.getCharset(uRI.toURL().toExternalForm(), httpURLConnection.getContentType())) != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), charset));
                }
                if (bufferedReader != null) {
                    boolean bl;
                    while (bl = this.parseLine(bufferedReader.readLine())) {
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                    Locator.closeConnection(httpURLConnection);
                }
            }
        }

        private boolean isVariantPlaylist() {
            return this.isVariantPlaylist;
        }

        private boolean isLivePlaylist() {
            return !this.isEndList;
        }

        private int getTargetDuration() {
            return this.targetDuration;
        }

        private int getSequenceNumber() {
            return this.sequenceNumber;
        }

        private boolean hasNext() {
            ++this.dataListIndex;
            return this.dataListString.size() > this.dataListIndex || this.dataListInteger.size() > this.dataListIndex || this.dataListDouble.size() > this.dataListIndex || this.dataListBoolean.size() > this.dataListIndex;
        }

        private String getString() {
            return this.dataListString.get(this.dataListIndex);
        }

        private Integer getInteger() {
            return this.dataListInteger.get(this.dataListIndex);
        }

        private Double getDouble() {
            return this.dataListDouble.get(this.dataListIndex);
        }

        private Boolean getBoolean() {
            return this.dataListBoolean.get(this.dataListIndex);
        }

        private boolean parseLine(String string) {
            if (string == null) {
                return false;
            }
            if (this.isFirstLine) {
                if (string.compareTo("#EXTM3U") != 0) {
                    return false;
                }
                this.isFirstLine = false;
                return true;
            }
            if (string.isEmpty() || string.startsWith("#") && !string.startsWith("#EXT")) {
                return true;
            }
            if (string.startsWith("#EXTINF")) {
                String[] stringArray;
                String[] stringArray2 = string.split(":");
                if (stringArray2.length == 2 && stringArray2[1].length() > 0 && (stringArray = stringArray2[1].split(",")).length >= 1) {
                    this.dataListDouble.add(Double.parseDouble(stringArray[0]));
                }
                this.isLineMediaFileURI = true;
            } else if (string.startsWith("#EXT-X-TARGETDURATION")) {
                String[] stringArray = string.split(":");
                if (stringArray.length == 2 && stringArray[1].length() > 0) {
                    this.targetDuration = Integer.parseInt(stringArray[1]);
                }
            } else if (string.startsWith("#EXT-X-MEDIA-SEQUENCE")) {
                String[] stringArray = string.split(":");
                if (stringArray.length == 2 && stringArray[1].length() > 0) {
                    this.sequenceNumber = Integer.parseInt(stringArray[1]);
                }
            } else if (string.startsWith("#EXT-X-STREAM-INF")) {
                String[] stringArray;
                this.isVariantPlaylist = true;
                int n2 = 0;
                String[] stringArray3 = string.split(":");
                if (stringArray3.length == 2 && stringArray3[1].length() > 0 && (stringArray = stringArray3[1].split(",")).length > 0) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String[] stringArray4;
                        stringArray[i2] = stringArray[i2].trim();
                        if (!stringArray[i2].startsWith("BANDWIDTH") || (stringArray4 = stringArray[i2].split("=")).length != 2 || stringArray4[1].length() <= 0) continue;
                        n2 = Integer.parseInt(stringArray4[1]);
                    }
                }
                if (n2 < 1) {
                    return false;
                }
                this.dataListInteger.add(n2);
                this.isLinePlaylistURI = true;
            } else if (string.startsWith("#EXT-X-ENDLIST")) {
                this.isEndList = true;
            } else if (string.startsWith("#EXT-X-DISCONTINUITY")) {
                this.isDiscontinuity = true;
            } else if (this.isLinePlaylistURI) {
                this.isLinePlaylistURI = false;
                this.dataListString.add(string);
            } else if (this.isLineMediaFileURI) {
                this.isLineMediaFileURI = false;
                this.dataListString.add(string);
                this.dataListBoolean.add(this.isDiscontinuity);
                this.isDiscontinuity = false;
            }
            return true;
        }

        private Charset getCharset(String string, String string2) {
            if (string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u8") || string2 != null && string2.equals("application/vnd.apple.mpegurl")) {
                if (Charset.isSupported(HLSConnectionHolder.CHARSET_UTF_8)) {
                    return Charset.forName(HLSConnectionHolder.CHARSET_UTF_8);
                }
            } else if ((string != null && HLSConnectionHolder.stripParameters(string).endsWith(".m3u") || string2 != null && string2.equals("audio/mpegurl")) && Charset.isSupported(HLSConnectionHolder.CHARSET_US_ASCII)) {
                return Charset.forName(HLSConnectionHolder.CHARSET_US_ASCII);
            }
            return null;
        }
    }

    private class PlaylistThread
    extends Thread {
        public static final int STATE_INIT = 0;
        public static final int STATE_EXIT = 1;
        public static final int STATE_RELOAD_PLAYLIST = 2;
        private BlockingQueue<Integer> stateQueue = new LinkedBlockingQueue<Integer>();
        private URI playlistURI = null;
        private Playlist reloadPlaylist = null;
        private final Object reloadLock = new Object();
        private volatile boolean stopped = false;

        private PlaylistThread() {
            this.setName("JFXMedia HLS Playlist Thread");
            this.setDaemon(true);
        }

        private void setPlaylistURI(URI uRI) {
            this.playlistURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setReloadPlaylist(Playlist playlist) {
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist = playlist;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    int n2 = this.stateQueue.take();
                    switch (n2) {
                        case 0: {
                            this.stateInit();
                            break;
                        }
                        case 1: {
                            this.stopped = true;
                            break;
                        }
                        case 2: {
                            this.stateReloadPlaylist();
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }

        private void putState(int n2) {
            if (this.stateQueue != null) {
                try {
                    this.stateQueue.put(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void stateInit() {
            if (this.playlistURI == null) {
                return;
            }
            PlaylistParser playlistParser = new PlaylistParser();
            playlistParser.load(this.playlistURI);
            if (playlistParser.isVariantPlaylist()) {
                HLSConnectionHolder.this.variantPlaylist = new VariantPlaylist(this.playlistURI);
                while (playlistParser.hasNext()) {
                    HLSConnectionHolder.this.variantPlaylist.addPlaylistInfo(playlistParser.getString(), playlistParser.getInteger());
                }
            } else {
                if (HLSConnectionHolder.this.currentPlaylist == null) {
                    HLSConnectionHolder.this.currentPlaylist = new Playlist(playlistParser.isLivePlaylist(), playlistParser.getTargetDuration());
                    HLSConnectionHolder.this.currentPlaylist.setPlaylistURI(this.playlistURI);
                }
                if (HLSConnectionHolder.this.currentPlaylist.setSequenceNumber(playlistParser.getSequenceNumber())) {
                    while (playlistParser.hasNext()) {
                        HLSConnectionHolder.this.currentPlaylist.addMediaFile(playlistParser.getString(), playlistParser.getDouble(), playlistParser.getBoolean());
                    }
                }
                if (HLSConnectionHolder.this.variantPlaylist != null) {
                    HLSConnectionHolder.this.variantPlaylist.addPlaylist(HLSConnectionHolder.this.currentPlaylist);
                }
            }
            if (HLSConnectionHolder.this.variantPlaylist != null) {
                while (HLSConnectionHolder.this.variantPlaylist.hasNext()) {
                    try {
                        HLSConnectionHolder.this.currentPlaylist = new Playlist(HLSConnectionHolder.this.variantPlaylist.getPlaylistURI());
                        HLSConnectionHolder.this.currentPlaylist.update(null);
                        HLSConnectionHolder.this.variantPlaylist.addPlaylist(HLSConnectionHolder.this.currentPlaylist);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            if (HLSConnectionHolder.this.variantPlaylist != null) {
                HLSConnectionHolder.this.currentPlaylist = HLSConnectionHolder.this.variantPlaylist.getPlaylist(0);
                HLSConnectionHolder.this.isBitrateAdjustable = true;
            }
            if (HLSConnectionHolder.this.currentPlaylist.isLive()) {
                this.setReloadPlaylist(HLSConnectionHolder.this.currentPlaylist);
                this.putState(2);
            }
            HLSConnectionHolder.this.readySignal.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stateReloadPlaylist() {
            try {
                long l2;
                Object object = this.reloadLock;
                synchronized (object) {
                    l2 = this.reloadPlaylist.getTargetDuration() / 2L;
                }
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            Object object = this.reloadLock;
            synchronized (object) {
                this.reloadPlaylist.update(null);
            }
            this.putState(2);
        }
    }
}

