/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

public final class GradientColorMap {
    public static final int CYCLE_NONE = 0;
    public static final int CYCLE_REPEAT = 1;
    public static final int CYCLE_REFLECT = 2;
    int cycleMethod;
    private static final int LG_RAMP_SIZE = 8;
    private static final int RAMP_SIZE = 256;
    int[] fractions = null;
    int[] rgba = null;
    int[] colors = null;

    GradientColorMap(int[] nArray, int[] nArray2, int n2) {
        int[] nArray3;
        int[] nArray4;
        this.cycleMethod = n2;
        int n3 = nArray.length;
        if (nArray[0] != 0) {
            nArray4 = new int[n3 + 1];
            nArray3 = new int[n3 + 1];
            System.arraycopy(nArray, 0, nArray4, 1, n3);
            System.arraycopy(nArray2, 0, nArray3, 1, n3);
            nArray4[0] = 0;
            nArray3[0] = nArray2[0];
            nArray = nArray4;
            nArray2 = nArray3;
            ++n3;
        }
        if (nArray[n3 - 1] != 65536) {
            nArray4 = new int[n3 + 1];
            nArray3 = new int[n3 + 1];
            System.arraycopy(nArray, 0, nArray4, 0, n3);
            System.arraycopy(nArray2, 0, nArray3, 0, n3);
            nArray4[n3] = 65536;
            nArray3[n3] = nArray2[n3 - 1];
            nArray = nArray4;
            nArray2 = nArray3;
        }
        this.fractions = new int[nArray.length];
        System.arraycopy(nArray, 0, this.fractions, 0, nArray.length);
        this.rgba = new int[nArray2.length];
        System.arraycopy(nArray2, 0, this.rgba, 0, nArray2.length);
        this.createRamp();
    }

    private int pad(int n2) {
        switch (this.cycleMethod) {
            case 0: {
                if (n2 < 0) {
                    return 0;
                }
                if (n2 > 65535) {
                    return 65535;
                }
                return n2;
            }
            case 1: {
                return n2 & 0xFFFF;
            }
            case 2: {
                if (n2 < 0) {
                    n2 = -n2;
                }
                if ((n2 &= 0x1FFFF) > 65535) {
                    n2 = 131071 - n2;
                }
                return n2;
            }
        }
        throw new RuntimeException("Unknown cycle method: " + this.cycleMethod);
    }

    private int findStop(int n2) {
        int n3 = this.fractions.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (this.fractions[i2] <= n2) continue;
            return i2;
        }
        return 1;
    }

    private void accumColor(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8) {
        int n3 = this.findStop(n2);
        int n4 = this.fractions[n3] - this.fractions[n3 - 1];
        nArray5[0] = nArray5[0] + (nArray[n3 - 1] + (n2 -= this.fractions[n3 - 1]) * (nArray[n3] - nArray[n3 - 1]) / n4);
        nArray6[0] = nArray6[0] + (nArray2[n3 - 1] + n2 * (nArray2[n3] - nArray2[n3 - 1]) / n4);
        nArray7[0] = nArray7[0] + (nArray3[n3 - 1] + n2 * (nArray3[n3] - nArray3[n3 - 1]) / n4);
        nArray8[0] = nArray8[0] + (nArray4[n3 - 1] + n2 * (nArray4[n3] - nArray4[n3 - 1]) / n4);
    }

    private int getColorAA(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8) {
        int n3;
        int n4 = this.findStop(n2);
        if (this.fractions[n4 - 1] < this.pad(n2 - (n3 = 192)) && this.pad(n2 + n3) < this.fractions[n4]) {
            n3 = 0;
        }
        int n5 = 64;
        int n6 = 0;
        for (int i2 = -n3; i2 <= n3; i2 += n5) {
            int n7 = this.pad(n2 + i2);
            this.accumColor(n7, nArray, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8);
            ++n6;
        }
        nArray8[0] = nArray8[0] / n6;
        nArray5[0] = nArray5[0] / n6;
        nArray6[0] = nArray6[0] / n6;
        nArray7[0] = nArray7[0] / n6;
        return nArray8[0] << 24 | nArray5[0] << 16 | nArray6[0] << 8 | nArray7[0];
    }

    private void createRamp() {
        int n2;
        this.colors = new int[256];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n3 = this.fractions.length;
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray5[n2] = this.rgba[n2] >> 24 & 0xFF;
            nArray6[n2] = this.rgba[n2] >> 16 & 0xFF;
            nArray7[n2] = this.rgba[n2] >> 8 & 0xFF;
            nArray8[n2] = this.rgba[n2] & 0xFF;
        }
        n2 = 255;
        int n4 = 8;
        this.colors[0] = this.rgba[0];
        this.colors[n2] = this.rgba[n3 - 1];
        for (int i2 = 1; i2 < n2; ++i2) {
            nArray[0] = 0;
            nArray4[0] = 0;
            nArray3[0] = 0;
            nArray2[0] = 0;
            this.colors[i2] = this.getColorAA(i2 << n4, nArray6, nArray7, nArray8, nArray5, nArray2, nArray3, nArray4, nArray);
        }
    }
}

