/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DContextSource;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DTextureData;
import com.sun.prism.d3d.D3DTextureResource;
import com.sun.prism.impl.BaseTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class D3DTexture
extends BaseTexture<D3DTextureResource>
implements D3DContextSource {
    D3DTexture(D3DContext d3DContext, PixelFormat pixelFormat, Texture.WrapMode wrapMode, long l2, int n2, int n3, int n4, int n5, boolean bl) {
        this(d3DContext, pixelFormat, wrapMode, l2, n2, n3, 0, 0, n4, n5, bl, 0, false);
    }

    D3DTexture(D3DContext d3DContext, PixelFormat pixelFormat, Texture.WrapMode wrapMode, long l2, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8, boolean bl2) {
        super(new D3DTextureResource(new D3DTextureData(d3DContext, l2, bl, n2, n3, pixelFormat, n8)), pixelFormat, wrapMode, n2, n3, n4, n5, n6, n7, n2, n3, bl2);
    }

    D3DTexture(D3DTexture d3DTexture, Texture.WrapMode wrapMode) {
        super(d3DTexture, wrapMode, false);
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode wrapMode) {
        return new D3DTexture(this, wrapMode);
    }

    public long getNativeSourceHandle() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getResource();
    }

    public long getNativeTextureObject() {
        return D3DResourceFactory.nGetNativeTextureObject(this.getNativeSourceHandle());
    }

    @Override
    public D3DContext getContext() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getContext();
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        PixelFormat pixelFormat;
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Unsupported format " + mediaFrame.getPixelFormat());
        }
        mediaFrame.holdFrame();
        ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(0);
        D3DContext d3DContext = this.getContext();
        if (!bl) {
            d3DContext.flushVertexBuffer();
        }
        int n2 = (pixelFormat = mediaFrame.getPixelFormat()).getDataType() == PixelFormat.DataType.INT ? D3DResourceFactory.nUpdateTextureI(d3DContext.getContextHandle(), this.getNativeSourceHandle(), byteBuffer.asIntBuffer(), null, 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0)) : D3DResourceFactory.nUpdateTextureB(d3DContext.getContextHandle(), this.getNativeSourceHandle(), byteBuffer, null, pixelFormat.ordinal(), 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0));
        D3DContext.validate(n2);
        mediaFrame.releaseFrame();
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        this.checkUpdateParams(buffer, pixelFormat, n2, n3, n4, n5, n6, n7, n8);
        if (!bl) {
            this.getContext().flushVertexBuffer();
        }
        int n9 = this.getContentX();
        int n10 = this.getContentY();
        int n11 = this.getContentWidth();
        int n12 = this.getContentHeight();
        int n13 = this.getPhysicalWidth();
        int n14 = this.getPhysicalHeight();
        this.update(buffer, pixelFormat, n9 + n2, n10 + n3, n4, n5, n6, n7, n8);
        switch (this.getWrapMode()) {
            case CLAMP_TO_EDGE: {
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: {
                boolean bl2;
                boolean bl3 = n11 < n13 && n2 + n6 == n11;
                boolean bl4 = bl2 = n12 < n14 && n3 + n7 == n12;
                if (bl3) {
                    this.update(buffer, pixelFormat, n9 + n11, n10 + n3, n4 + n6 - 1, n5, 1, n7, n8);
                }
                if (!bl2) break;
                this.update(buffer, pixelFormat, n9 + n2, n10 + n12, n4, n5 + n7 - 1, n6, 1, n8);
                if (!bl3) break;
                this.update(buffer, pixelFormat, n9 + n11, n10 + n12, n4 + n6 - 1, n5 + n7 - 1, 1, 1, n8);
                break;
            }
            case REPEAT: {
                break;
            }
            case REPEAT_SIMULATED: {
                boolean bl5;
                boolean bl6 = n11 < n13 && n2 == 0;
                boolean bl7 = bl5 = n12 < n14 && n3 == 0;
                if (bl6) {
                    this.update(buffer, pixelFormat, n9 + n11, n10 + n3, n4, n5, 1, n7, n8);
                }
                if (!bl5) break;
                this.update(buffer, pixelFormat, n9 + n2, n10 + n12, n4, n5, n6, 1, n8);
                if (!bl6) break;
                this.update(buffer, pixelFormat, n9 + n11, n10 + n12, n4, n5, 1, 1, n8);
                break;
            }
        }
    }

    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        D3DContext d3DContext = this.getContext();
        if (pixelFormat.getDataType() == PixelFormat.DataType.INT) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            n9 = D3DResourceFactory.nUpdateTextureI(d3DContext.getContextHandle(), this.getNativeSourceHandle(), intBuffer, nArray, n2, n3, n4, n5, n6, n7, n8);
        } else if (pixelFormat.getDataType() == PixelFormat.DataType.FLOAT) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            float[] fArray = floatBuffer.hasArray() ? floatBuffer.array() : null;
            n9 = D3DResourceFactory.nUpdateTextureF(d3DContext.getContextHandle(), this.getNativeSourceHandle(), floatBuffer, fArray, n2, n3, n4, n5, n6, n7, n8);
        } else {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byteBuffer.rewind();
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            n9 = D3DResourceFactory.nUpdateTextureB(d3DContext.getContextHandle(), this.getNativeSourceHandle(), byteBuffer, byArray, pixelFormat.ordinal(), n2, n3, n4, n5, n6, n7, n8);
        }
        D3DContext.validate(n9);
    }
}

