/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Quat4f;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.prism.Mesh;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.MeshTempState;
import com.sun.prism.impl.MeshUtil;
import com.sun.prism.impl.MeshVertex;
import java.util.Arrays;
import java.util.HashMap;
import javafx.scene.shape.VertexFormat;

public abstract class BaseMesh
extends BaseGraphicsResource
implements Mesh {
    private int nVerts;
    private int nTVerts;
    private int nFaces;
    private float[] pos;
    private float[] uv;
    private int[] faces;
    private int[] smoothing;
    private boolean allSameSmoothing;
    private boolean allHardEdges;
    protected static final int POINT_SIZE = 3;
    protected static final int NORMAL_SIZE = 3;
    protected static final int TEXCOORD_SIZE = 2;
    protected static final int POINT_SIZE_VB = 3;
    protected static final int TEXCOORD_SIZE_VB = 2;
    protected static final int NORMAL_SIZE_VB = 4;
    protected static final int VERTEX_SIZE_VB = 9;
    public static final int FACE_MEMBERS_SIZE = 7;
    private boolean[] dirtyVertices;
    private float[] cachedNormals;
    private float[] cachedTangents;
    private float[] cachedBitangents;
    private float[] vertexBuffer;
    private int[] indexBuffer;
    private short[] indexBufferShort;
    private int indexBufferSize;
    private int numberOfVertices;
    private HashMap<Integer, MeshGeomComp2VB> point2vbMap;
    private HashMap<Integer, MeshGeomComp2VB> normal2vbMap;
    private HashMap<Integer, MeshGeomComp2VB> texCoord2vbMap;

    protected BaseMesh(Disposer.Record record) {
        super(record);
    }

    public abstract boolean buildNativeGeometry(float[] var1, int var2, int[] var3, int var4);

    public abstract boolean buildNativeGeometry(float[] var1, int var2, short[] var3, int var4);

    private void convertNormalsToQuats(MeshTempState meshTempState, int n2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, boolean[] blArray) {
        Vec3f vec3f = meshTempState.vec3f1;
        Vec3f vec3f2 = meshTempState.vec3f2;
        Vec3f vec3f3 = meshTempState.vec3f3;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (blArray == null || blArray[n3]) {
                int n5 = n3 * 3;
                vec3f.x = fArray[n5];
                vec3f.y = fArray[n5 + 1];
                vec3f.z = fArray[n5 + 2];
                vec3f.normalize();
                vec3f2.x = fArray2[n5];
                vec3f2.y = fArray2[n5 + 1];
                vec3f2.z = fArray2[n5 + 2];
                vec3f3.x = fArray3[n5];
                vec3f3.y = fArray3[n5 + 1];
                vec3f3.z = fArray3[n5 + 2];
                meshTempState.triNormals[0].set(vec3f);
                meshTempState.triNormals[1].set(vec3f2);
                meshTempState.triNormals[2].set(vec3f3);
                MeshUtil.fixTSpace(meshTempState.triNormals);
                this.buildVSQuat(meshTempState.triNormals, meshTempState.quat);
                fArray4[n4 + 5] = meshTempState.quat.x;
                fArray4[n4 + 6] = meshTempState.quat.y;
                fArray4[n4 + 7] = meshTempState.quat.z;
                fArray4[n4 + 8] = meshTempState.quat.w;
            }
            ++n3;
            n4 += 9;
        }
    }

    private boolean doBuildPNTGeometry(float[] fArray, float[] fArray2, float[] fArray3, int[] nArray) {
        int n2;
        int n3;
        if (this.point2vbMap == null) {
            this.point2vbMap = new HashMap();
        } else {
            this.point2vbMap.clear();
        }
        if (this.normal2vbMap == null) {
            this.normal2vbMap = new HashMap();
        } else {
            this.normal2vbMap.clear();
        }
        if (this.texCoord2vbMap == null) {
            this.texCoord2vbMap = new HashMap();
        } else {
            this.texCoord2vbMap.clear();
        }
        int n4 = VertexFormat.POINT_NORMAL_TEXCOORD.getVertexIndexSize();
        int n5 = n4 * 3;
        int n6 = VertexFormat.POINT_NORMAL_TEXCOORD.getPointIndexOffset();
        int n7 = VertexFormat.POINT_NORMAL_TEXCOORD.getNormalIndexOffset();
        int n8 = VertexFormat.POINT_NORMAL_TEXCOORD.getTexCoordIndexOffset();
        int n9 = fArray.length / 3;
        int n10 = fArray2.length / 3;
        int n11 = fArray3.length / 2;
        int n12 = nArray.length / n5;
        assert (n9 > 0 && n10 > 0 && n11 > 0 && n12 > 0);
        this.cachedNormals = new float[n9 * 3];
        this.cachedTangents = new float[n9 * 3];
        this.cachedBitangents = new float[n9 * 3];
        this.vertexBuffer = new float[n9 * 9];
        this.indexBuffer = new int[n12 * 3];
        int n13 = 0;
        int n14 = 0;
        MeshTempState meshTempState = MeshTempState.getInstance();
        for (n3 = 0; n3 < 3; ++n3) {
            if (meshTempState.triPoints[n3] == null) {
                meshTempState.triPoints[n3] = new Vec3f();
            }
            if (meshTempState.triTexCoords[n3] != null) continue;
            meshTempState.triTexCoords[n3] = new Vec2f();
        }
        for (n3 = 0; n3 < n12; ++n3) {
            int n15;
            int n16;
            n2 = n3 * n5;
            for (n16 = 0; n16 < 3; ++n16) {
                int n17;
                int n18;
                n15 = n2 + n16 * n4;
                int n19 = n15 + n6;
                int n20 = n15 + n7;
                int n21 = n15 + n8;
                Integer n22 = n14 / 9;
                if (this.vertexBuffer.length <= n14) {
                    n18 = n14 / 9;
                    n17 = n18 + Math.max(n18 >> 3, 6);
                    float[] fArray4 = new float[n17 * 9];
                    System.arraycopy(this.vertexBuffer, 0, fArray4, 0, this.vertexBuffer.length);
                    this.vertexBuffer = fArray4;
                    fArray4 = new float[n17 * 3];
                    System.arraycopy(this.cachedNormals, 0, fArray4, 0, this.cachedNormals.length);
                    this.cachedNormals = fArray4;
                    fArray4 = new float[n17 * 3];
                    System.arraycopy(this.cachedTangents, 0, fArray4, 0, this.cachedTangents.length);
                    this.cachedTangents = fArray4;
                    fArray4 = new float[n17 * 3];
                    System.arraycopy(this.cachedBitangents, 0, fArray4, 0, this.cachedBitangents.length);
                    this.cachedBitangents = fArray4;
                }
                n18 = nArray[n19] * 3;
                n17 = nArray[n20] * 3;
                int n23 = nArray[n21] * 2;
                meshTempState.triPointIndex[n16] = n18;
                meshTempState.triTexCoordIndex[n16] = n23;
                meshTempState.triVerts[n16] = n14 / 9;
                this.vertexBuffer[n14] = fArray[n18];
                this.vertexBuffer[n14 + 1] = fArray[n18 + 1];
                this.vertexBuffer[n14 + 2] = fArray[n18 + 2];
                this.vertexBuffer[n14 + 3] = fArray3[n23];
                this.vertexBuffer[n14 + 4] = fArray3[n23 + 1];
                int n24 = meshTempState.triVerts[n16] * 3;
                this.cachedNormals[n24] = fArray2[n17];
                this.cachedNormals[n24 + 1] = fArray2[n17 + 1];
                this.cachedNormals[n24 + 2] = fArray2[n17 + 2];
                n14 += 9;
                MeshGeomComp2VB meshGeomComp2VB = this.point2vbMap.get(n18);
                if (meshGeomComp2VB == null) {
                    meshGeomComp2VB = new MeshGeomComp2VB(n18, n22);
                    this.point2vbMap.put(n18, meshGeomComp2VB);
                } else {
                    meshGeomComp2VB.addLoc(n22);
                }
                MeshGeomComp2VB meshGeomComp2VB2 = this.normal2vbMap.get(n17);
                if (meshGeomComp2VB2 == null) {
                    meshGeomComp2VB2 = new MeshGeomComp2VB(n17, n22);
                    this.normal2vbMap.put(n17, meshGeomComp2VB2);
                } else {
                    meshGeomComp2VB2.addLoc(n22);
                }
                MeshGeomComp2VB meshGeomComp2VB3 = this.texCoord2vbMap.get(n23);
                if (meshGeomComp2VB3 == null) {
                    meshGeomComp2VB3 = new MeshGeomComp2VB(n23, n22);
                    this.texCoord2vbMap.put(n23, meshGeomComp2VB3);
                } else {
                    meshGeomComp2VB3.addLoc(n22);
                }
                this.indexBuffer[n13++] = n22;
            }
            for (n16 = 0; n16 < 3; ++n16) {
                meshTempState.triPoints[n16].x = fArray[meshTempState.triPointIndex[n16]];
                meshTempState.triPoints[n16].y = fArray[meshTempState.triPointIndex[n16] + 1];
                meshTempState.triPoints[n16].z = fArray[meshTempState.triPointIndex[n16] + 2];
                meshTempState.triTexCoords[n16].x = fArray3[meshTempState.triTexCoordIndex[n16]];
                meshTempState.triTexCoords[n16].y = fArray3[meshTempState.triTexCoordIndex[n16] + 1];
            }
            MeshUtil.computeTBNNormalized(meshTempState.triPoints[0], meshTempState.triPoints[1], meshTempState.triPoints[2], meshTempState.triTexCoords[0], meshTempState.triTexCoords[1], meshTempState.triTexCoords[2], meshTempState.triNormals);
            for (n16 = 0; n16 < 3; ++n16) {
                n15 = meshTempState.triVerts[n16] * 3;
                this.cachedTangents[n15] = meshTempState.triNormals[1].x;
                this.cachedTangents[n15 + 1] = meshTempState.triNormals[1].y;
                this.cachedTangents[n15 + 2] = meshTempState.triNormals[1].z;
                this.cachedBitangents[n15] = meshTempState.triNormals[2].x;
                this.cachedBitangents[n15 + 1] = meshTempState.triNormals[2].y;
                this.cachedBitangents[n15 + 2] = meshTempState.triNormals[2].z;
            }
        }
        this.numberOfVertices = n14 / 9;
        this.convertNormalsToQuats(meshTempState, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, null);
        this.indexBufferSize = n12 * 3;
        if (this.numberOfVertices > 65536) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        if (this.indexBufferShort == null || this.indexBufferShort.length < this.indexBufferSize) {
            this.indexBufferShort = new short[this.indexBufferSize];
        }
        n3 = 0;
        for (n2 = 0; n2 < n12; ++n2) {
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
        }
        this.indexBuffer = null;
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    private boolean updatePNTGeometry(float[] fArray, int[] nArray, float[] fArray2, int[] nArray2, float[] fArray3, int[] nArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.dirtyVertices == null) {
            this.dirtyVertices = new boolean[this.numberOfVertices];
        }
        Arrays.fill(this.dirtyVertices, false);
        int n6 = nArray[0] / 3;
        int n7 = nArray[1] / 3;
        if (nArray[1] % 3 > 0) {
            ++n7;
        }
        if (n7 > 0) {
            for (n5 = 0; n5 < n7; ++n5) {
                int n8;
                n4 = (n6 + n5) * 3;
                MeshGeomComp2VB meshGeomComp2VB = this.point2vbMap.get(n4);
                assert (meshGeomComp2VB != null);
                if (meshGeomComp2VB == null) continue;
                int[] nArray4 = meshGeomComp2VB.getLocs();
                int n9 = meshGeomComp2VB.getValidLocs();
                if (nArray4 != null) {
                    for (n8 = 0; n8 < n9; ++n8) {
                        n3 = nArray4[n8] * 9;
                        this.vertexBuffer[n3] = fArray[n4];
                        this.vertexBuffer[n3 + 1] = fArray[n4 + 1];
                        this.vertexBuffer[n3 + 2] = fArray[n4 + 2];
                        this.dirtyVertices[nArray4[n8]] = true;
                    }
                    continue;
                }
                n8 = meshGeomComp2VB.getLoc();
                n3 = n8 * 9;
                this.vertexBuffer[n3] = fArray[n4];
                this.vertexBuffer[n3 + 1] = fArray[n4 + 1];
                this.vertexBuffer[n3 + 2] = fArray[n4 + 2];
                this.dirtyVertices[n8] = true;
            }
        }
        n5 = nArray3[0] / 2;
        n4 = nArray3[1] / 2;
        if (nArray3[1] % 2 > 0) {
            ++n4;
        }
        if (n4 > 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n10;
                int n11;
                int n12 = (n5 + i2) * 2;
                MeshGeomComp2VB meshGeomComp2VB = this.texCoord2vbMap.get(n12);
                assert (meshGeomComp2VB != null);
                if (meshGeomComp2VB == null) continue;
                int[] nArray5 = meshGeomComp2VB.getLocs();
                n3 = meshGeomComp2VB.getValidLocs();
                if (nArray5 != null) {
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = nArray5[n11] * 9 + 3;
                        this.vertexBuffer[n10] = fArray3[n12];
                        this.vertexBuffer[n10 + 1] = fArray3[n12 + 1];
                        this.dirtyVertices[nArray5[n11]] = true;
                    }
                    continue;
                }
                n11 = meshGeomComp2VB.getLoc();
                n10 = n11 * 9 + 3;
                this.vertexBuffer[n10] = fArray3[n12];
                this.vertexBuffer[n10 + 1] = fArray3[n12 + 1];
                this.dirtyVertices[n11] = true;
            }
        }
        int n13 = nArray2[0] / 3;
        int n14 = nArray2[1] / 3;
        if (nArray2[1] % 3 > 0) {
            ++n14;
        }
        if (n14 > 0) {
            MeshTempState meshTempState = MeshTempState.getInstance();
            for (int i3 = 0; i3 < n14; ++i3) {
                int n15;
                int n16;
                n3 = (n13 + i3) * 3;
                MeshGeomComp2VB meshGeomComp2VB = this.normal2vbMap.get(n3);
                assert (meshGeomComp2VB != null);
                if (meshGeomComp2VB == null) continue;
                int[] nArray6 = meshGeomComp2VB.getLocs();
                int n17 = meshGeomComp2VB.getValidLocs();
                if (nArray6 != null) {
                    for (n16 = 0; n16 < n17; ++n16) {
                        n15 = nArray6[n16] * 3;
                        this.cachedNormals[n15] = fArray2[n3];
                        this.cachedNormals[n15 + 1] = fArray2[n3 + 1];
                        this.cachedNormals[n15 + 2] = fArray2[n3 + 2];
                        this.dirtyVertices[nArray6[n16]] = true;
                    }
                    continue;
                }
                n16 = meshGeomComp2VB.getLoc();
                n15 = n16 * 3;
                this.cachedNormals[n15] = fArray2[n3];
                this.cachedNormals[n15 + 1] = fArray2[n3 + 1];
                this.cachedNormals[n15 + 2] = fArray2[n3 + 2];
                this.dirtyVertices[n16] = true;
            }
        }
        MeshTempState meshTempState = MeshTempState.getInstance();
        for (n2 = 0; n2 < 3; ++n2) {
            if (meshTempState.triPoints[n2] == null) {
                meshTempState.triPoints[n2] = new Vec3f();
            }
            if (meshTempState.triTexCoords[n2] != null) continue;
            meshTempState.triTexCoords[n2] = new Vec2f();
        }
        for (n2 = 0; n2 < this.numberOfVertices; n2 += 3) {
            int n18;
            if (!this.dirtyVertices[n2] && !this.dirtyVertices[n2 + 1] && !this.dirtyVertices[n2 + 2]) continue;
            n3 = n2 * 9;
            for (n18 = 0; n18 < 3; ++n18) {
                meshTempState.triPoints[n18].x = this.vertexBuffer[n3];
                meshTempState.triPoints[n18].y = this.vertexBuffer[n3 + 1];
                meshTempState.triPoints[n18].z = this.vertexBuffer[n3 + 2];
                meshTempState.triTexCoords[n18].x = this.vertexBuffer[n3 + 3];
                meshTempState.triTexCoords[n18].y = this.vertexBuffer[n3 + 3 + 1];
                n3 += 9;
            }
            MeshUtil.computeTBNNormalized(meshTempState.triPoints[0], meshTempState.triPoints[1], meshTempState.triPoints[2], meshTempState.triTexCoords[0], meshTempState.triTexCoords[1], meshTempState.triTexCoords[2], meshTempState.triNormals);
            n18 = n2 * 3;
            for (int i4 = 0; i4 < 3; ++i4) {
                this.cachedTangents[n18] = meshTempState.triNormals[1].x;
                this.cachedTangents[n18 + 1] = meshTempState.triNormals[1].y;
                this.cachedTangents[n18 + 2] = meshTempState.triNormals[1].z;
                this.cachedBitangents[n18] = meshTempState.triNormals[2].x;
                this.cachedBitangents[n18 + 1] = meshTempState.triNormals[2].y;
                this.cachedBitangents[n18 + 2] = meshTempState.triNormals[2].z;
                n18 += 3;
            }
        }
        this.convertNormalsToQuats(meshTempState, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, this.dirtyVertices);
        if (this.indexBuffer != null) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    @Override
    public boolean buildGeometry(boolean bl, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2, float[] fArray3, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        if (bl) {
            return this.buildPNTGeometry(fArray, nArray, fArray2, nArray2, fArray3, nArray3, nArray4, nArray5);
        }
        return this.buildPTGeometry(fArray, fArray3, nArray4, nArray6);
    }

    private boolean buildPNTGeometry(float[] fArray, int[] nArray, float[] fArray2, int[] nArray2, float[] fArray3, int[] nArray3, int[] nArray4, int[] nArray5) {
        boolean bl;
        boolean bl2 = nArray[1] > 0;
        boolean bl3 = nArray2[1] > 0;
        boolean bl4 = nArray3[1] > 0;
        boolean bl5 = nArray5[1] > 0;
        boolean bl6 = bl = !bl2 && !bl3 && !bl4 && !bl5;
        if (bl5) {
            bl = true;
        }
        if (!(bl || this.vertexBuffer == null || this.indexBuffer == null && this.indexBufferShort == null)) {
            return this.updatePNTGeometry(fArray, nArray, fArray2, nArray2, fArray3, nArray3);
        }
        return this.doBuildPNTGeometry(fArray, fArray2, fArray3, nArray4);
    }

    private boolean buildPTGeometry(float[] fArray, float[] fArray2, int[] nArray, int[] nArray2) {
        this.nVerts = fArray.length / 3;
        this.nTVerts = fArray2.length / 2;
        this.nFaces = nArray.length / (VertexFormat.POINT_TEXCOORD.getVertexIndexSize() * 3);
        assert (this.nVerts > 0 && this.nFaces > 0 && this.nTVerts > 0);
        this.pos = fArray;
        this.uv = fArray2;
        this.faces = nArray;
        this.smoothing = (int[])(nArray2.length == this.nFaces ? nArray2 : null);
        MeshTempState meshTempState = MeshTempState.getInstance();
        if (meshTempState.pool == null || meshTempState.pool.length < this.nFaces * 3) {
            meshTempState.pool = new MeshVertex[this.nFaces * 3];
        }
        if (meshTempState.indexBuffer == null || meshTempState.indexBuffer.length < this.nFaces * 3) {
            meshTempState.indexBuffer = new int[this.nFaces * 3];
        }
        if (meshTempState.pVertex == null || meshTempState.pVertex.length < this.nVerts) {
            meshTempState.pVertex = new MeshVertex[this.nVerts];
        } else {
            Arrays.fill(meshTempState.pVertex, 0, meshTempState.pVertex.length, null);
        }
        this.checkSmoothingGroup();
        this.computeTBNormal(meshTempState.pool, meshTempState.pVertex, meshTempState.indexBuffer);
        int n2 = MeshVertex.processVertices(meshTempState.pVertex, this.nVerts, this.allHardEdges, this.allSameSmoothing);
        if (meshTempState.vertexBuffer == null || meshTempState.vertexBuffer.length < n2 * 9) {
            meshTempState.vertexBuffer = new float[n2 * 9];
        }
        this.buildVertexBuffer(meshTempState.pVertex, meshTempState.vertexBuffer);
        if (n2 > 65536) {
            this.buildIndexBuffer(meshTempState.pool, meshTempState.indexBuffer, null);
            return this.buildNativeGeometry(meshTempState.vertexBuffer, n2 * 9, meshTempState.indexBuffer, this.nFaces * 3);
        }
        if (meshTempState.indexBufferShort == null || meshTempState.indexBufferShort.length < this.nFaces * 3) {
            meshTempState.indexBufferShort = new short[this.nFaces * 3];
        }
        this.buildIndexBuffer(meshTempState.pool, meshTempState.indexBuffer, meshTempState.indexBufferShort);
        return this.buildNativeGeometry(meshTempState.vertexBuffer, n2 * 9, meshTempState.indexBufferShort, this.nFaces * 3);
    }

    private void computeTBNormal(MeshVertex[] meshVertexArray, MeshVertex[] meshVertexArray2, int[] nArray) {
        MeshTempState meshTempState = MeshTempState.getInstance();
        int[] nArray2 = meshTempState.smFace;
        int[] nArray3 = meshTempState.triVerts;
        Vec3f[] vec3fArray = meshTempState.triPoints;
        Vec2f[] vec2fArray = meshTempState.triTexCoords;
        Vec3f[] vec3fArray2 = meshTempState.triNormals;
        String string = BaseMesh.class.getName();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.nFaces; ++i2) {
            int n4;
            int n5 = i2 * 3;
            nArray2 = this.getFace(i2, nArray2);
            nArray3[0] = nArray2[FaceMembers.POINT0.ordinal()];
            nArray3[1] = nArray2[FaceMembers.POINT1.ordinal()];
            nArray3[2] = nArray2[FaceMembers.POINT2.ordinal()];
            if (MeshUtil.isDeadFace(nArray3) && PlatformLogger.getLogger(string).isLoggable(PlatformLogger.Level.FINE)) {
                PlatformLogger.getLogger(string).fine("Dead face [" + nArray3[0] + ", " + nArray3[1] + ", " + nArray3[2] + "] @ face group " + i2 + "; nEmptyFaces = " + ++n2);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                vec3fArray[n4] = this.getVertex(nArray3[n4], vec3fArray[n4]);
            }
            nArray3[0] = nArray2[FaceMembers.TEXCOORD0.ordinal()];
            nArray3[1] = nArray2[FaceMembers.TEXCOORD1.ordinal()];
            nArray3[2] = nArray2[FaceMembers.TEXCOORD2.ordinal()];
            for (n4 = 0; n4 < 3; ++n4) {
                vec2fArray[n4] = this.getTVertex(nArray3[n4], vec2fArray[n4]);
            }
            MeshUtil.computeTBNNormalized(vec3fArray[0], vec3fArray[1], vec3fArray[2], vec2fArray[0], vec2fArray[1], vec2fArray[2], vec3fArray2);
            for (n4 = 0; n4 < 3; ++n4) {
                int n6;
                int n7;
                meshVertexArray[n3] = meshVertexArray[n3] == null ? new MeshVertex() : meshVertexArray[n3];
                for (n7 = 0; n7 < 3; ++n7) {
                    meshVertexArray[n3].norm[n7].set(vec3fArray2[n7]);
                }
                meshVertexArray[n3].smGroup = nArray2[FaceMembers.SMOOTHING_GROUP.ordinal()];
                meshVertexArray[n3].fIdx = i2;
                meshVertexArray[n3].tVert = nArray3[n4];
                meshVertexArray[n3].index = -1;
                n7 = n4 == 0 ? FaceMembers.POINT0.ordinal() : (n4 == 1 ? FaceMembers.POINT1.ordinal() : FaceMembers.POINT2.ordinal());
                meshVertexArray[n3].pVert = n6 = nArray2[n7];
                nArray[n5 + n4] = n6;
                meshVertexArray[n3].next = meshVertexArray2[n6];
                meshVertexArray2[n6] = meshVertexArray[n3];
                ++n3;
            }
        }
    }

    private void buildVSQuat(Vec3f[] vec3fArray, Quat4f quat4f) {
        Vec3f vec3f = MeshTempState.getInstance().vec3f1;
        vec3f.cross(vec3fArray[1], vec3fArray[2]);
        float f2 = vec3fArray[0].dot(vec3f);
        if (f2 < 0.0f) {
            vec3fArray[2].mul(-1.0f);
        }
        MeshUtil.buildQuat(vec3fArray, quat4f);
        if (f2 < 0.0f) {
            if (quat4f.w == 0.0f) {
                quat4f.w = 1.0E-10f;
            }
            quat4f.scale(-1.0f);
        }
    }

    private void buildVertexBuffer(MeshVertex[] meshVertexArray, float[] fArray) {
        Quat4f quat4f = MeshTempState.getInstance().quat;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.nVerts; ++i2) {
            MeshVertex meshVertex = meshVertexArray[i2];
            while (meshVertex != null) {
                if (meshVertex.index == n2) {
                    int n4 = meshVertex.pVert * 3;
                    fArray[n3++] = this.pos[n4];
                    fArray[n3++] = this.pos[n4 + 1];
                    fArray[n3++] = this.pos[n4 + 2];
                    n4 = meshVertex.tVert * 2;
                    fArray[n3++] = this.uv[n4];
                    fArray[n3++] = this.uv[n4 + 1];
                    this.buildVSQuat(meshVertex.norm, quat4f);
                    fArray[n3++] = quat4f.x;
                    fArray[n3++] = quat4f.y;
                    fArray[n3++] = quat4f.z;
                    fArray[n3++] = quat4f.w;
                    ++n2;
                }
                meshVertex = meshVertex.next;
            }
        }
    }

    private void buildIndexBuffer(MeshVertex[] meshVertexArray, int[] nArray, short[] sArray) {
        for (int i2 = 0; i2 < this.nFaces; ++i2) {
            int n2;
            int n3 = i2 * 3;
            if (nArray[n3] != -1) {
                for (n2 = 0; n2 < 3; ++n2) {
                    assert (meshVertexArray[n3].fIdx == i2);
                    if (sArray != null) {
                        sArray[n3 + n2] = (short)meshVertexArray[n3 + n2].index;
                    } else {
                        nArray[n3 + n2] = meshVertexArray[n3 + n2].index;
                    }
                    meshVertexArray[n3 + n2].next = null;
                }
                continue;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (sArray != null) {
                    sArray[n3 + n2] = 0;
                    continue;
                }
                nArray[n3 + n2] = 0;
            }
        }
    }

    public int getNumVerts() {
        return this.nVerts;
    }

    public int getNumTVerts() {
        return this.nTVerts;
    }

    public int getNumFaces() {
        return this.nFaces;
    }

    public Vec3f getVertex(int n2, Vec3f vec3f) {
        if (vec3f == null) {
            vec3f = new Vec3f();
        }
        int n3 = n2 * 3;
        vec3f.set(this.pos[n3], this.pos[n3 + 1], this.pos[n3 + 2]);
        return vec3f;
    }

    public Vec2f getTVertex(int n2, Vec2f vec2f) {
        if (vec2f == null) {
            vec2f = new Vec2f();
        }
        int n3 = n2 * 2;
        vec2f.set(this.uv[n3], this.uv[n3 + 1]);
        return vec2f;
    }

    private void checkSmoothingGroup() {
        if (this.smoothing == null || this.smoothing.length == 0) {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
            return;
        }
        int n2 = 0;
        while (n2 + 1 < this.smoothing.length) {
            if (this.smoothing[n2] != this.smoothing[n2 + 1]) {
                this.allSameSmoothing = false;
                this.allHardEdges = false;
                return;
            }
            ++n2;
        }
        if (this.smoothing[0] == 0) {
            this.allSameSmoothing = false;
            this.allHardEdges = true;
        } else {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
        }
    }

    public int[] getFace(int n2, int[] nArray) {
        int n3 = n2 * 6;
        if (nArray == null || nArray.length < 7) {
            nArray = new int[7];
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = this.faces[n3 + i2];
        }
        nArray[6] = this.smoothing != null ? this.smoothing[n2] : 1;
        return nArray;
    }

    boolean test_isVertexBufferNull() {
        return this.vertexBuffer == null;
    }

    int test_getVertexBufferLength() {
        return this.vertexBuffer.length;
    }

    int test_getNumberOfVertices() {
        return this.numberOfVertices;
    }

    class MeshGeomComp2VB {
        private final int key;
        private final int loc;
        private int[] locs;
        private int validLocs;

        MeshGeomComp2VB(int n2, int n3) {
            assert (n3 >= 0);
            this.key = n2;
            this.loc = n3;
            this.locs = null;
            this.validLocs = 0;
        }

        void addLoc(int n2) {
            if (this.locs == null) {
                this.locs = new int[3];
                this.locs[0] = this.loc;
                this.locs[1] = n2;
                this.validLocs = 2;
            } else if (this.locs.length > this.validLocs) {
                this.locs[this.validLocs] = n2;
                ++this.validLocs;
            } else {
                int[] nArray = new int[this.validLocs * 2];
                System.arraycopy(this.locs, 0, nArray, 0, this.locs.length);
                this.locs = nArray;
                this.locs[this.validLocs] = n2;
                ++this.validLocs;
            }
        }

        int getKey() {
            return this.key;
        }

        int getLoc() {
            return this.loc;
        }

        int[] getLocs() {
            return this.locs;
        }

        int getValidLocs() {
            return this.validLocs;
        }
    }

    public static enum FaceMembers {
        POINT0,
        TEXCOORD0,
        POINT1,
        TEXCOORD1,
        POINT2,
        TEXCOORD2,
        SMOOTHING_GROUP;

    }
}

