/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryUncaughtExceptionHandler;
import io.sentry.connection.Connection;
import io.sentry.connection.EventSendCallback;
import io.sentry.connection.LockedDownException;
import io.sentry.connection.TooManyRequestsException;
import io.sentry.context.Context;
import io.sentry.context.ContextManager;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.event.helper.ShouldSendEventCallback;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryClient {
    private static final Logger logger = LoggerFactory.getLogger(SentryClient.class);
    private static final Logger lockdownLogger = LoggerFactory.getLogger(SentryClient.class.getName() + ".lockdown");
    protected String release;
    protected String dist;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = new HashMap<String, String>();
    protected Set<String> mdcTags = new HashSet<String>();
    protected Map<String, Object> extra = new HashMap<String, Object>();
    private final Set<ShouldSendEventCallback> shouldSendEventCallbacks = new HashSet<ShouldSendEventCallback>();
    private final Connection connection;
    private final List<EventBuilderHelper> builderHelpers = new CopyOnWriteArrayList<EventBuilderHelper>();
    private final ContextManager contextManager;
    private SentryUncaughtExceptionHandler uncaughtExceptionHandler;

    public SentryClient(Connection connection, ContextManager contextManager) {
        this.connection = connection;
        this.contextManager = contextManager;
    }

    public void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper builderHelper : this.builderHelpers) {
            builderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event) {
        for (ShouldSendEventCallback shouldSendEventCallback : this.shouldSendEventCallbacks) {
            if (shouldSendEventCallback.shouldSend(event)) continue;
            logger.trace("Not sending Event because of ShouldSendEventCallback: {}", (Object)shouldSendEventCallback);
            return;
        }
        try {
            this.connection.send(event);
        }
        catch (LockedDownException | TooManyRequestsException e2) {
            logger.debug("Dropping an Event due to lockdown: " + event);
        }
        catch (Exception e3) {
            logger.error("An exception occurred while sending the event to Sentry.", e3);
        }
        finally {
            this.getContext().setLastEventId(event.getId());
        }
    }

    public void sendEvent(EventBuilder eventBuilder) {
        if (!Util.isNullOrEmpty(this.release)) {
            eventBuilder.withRelease(this.release.trim());
            if (!Util.isNullOrEmpty(this.dist)) {
                eventBuilder.withDist(this.dist.trim());
            }
        }
        if (!Util.isNullOrEmpty(this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (!Util.isNullOrEmpty(this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        for (Map.Entry<String, String> tagEntry : this.tags.entrySet()) {
            eventBuilder.withTag(tagEntry.getKey(), tagEntry.getValue());
        }
        for (Map.Entry<String, Object> extraEntry : this.extra.entrySet()) {
            eventBuilder.withExtra(extraEntry.getKey(), extraEntry.getValue());
        }
        this.runBuilderHelpers(eventBuilder);
        Event event = eventBuilder.build();
        this.sendEvent(event);
    }

    public void sendMessage(String message) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(message).withLevel(Event.Level.INFO);
        this.sendEvent(eventBuilder);
    }

    public void sendException(Throwable throwable) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(throwable.getMessage()).withLevel(Event.Level.ERROR).withSentryInterface(new ExceptionInterface(throwable));
        this.sendEvent(eventBuilder);
    }

    public void removeBuilderHelper(EventBuilderHelper builderHelper) {
        logger.debug("Removing '{}' from the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.remove(builderHelper);
    }

    public void addBuilderHelper(EventBuilderHelper builderHelper) {
        logger.debug("Adding '{}' to the list of builder helpers.", (Object)builderHelper);
        this.builderHelpers.add(builderHelper);
    }

    public List<EventBuilderHelper> getBuilderHelpers() {
        return Collections.unmodifiableList(this.builderHelpers);
    }

    public void closeConnection() {
        if (this.uncaughtExceptionHandler != null) {
            this.uncaughtExceptionHandler.disable();
        }
        try {
            this.connection.close();
        }
        catch (IOException e2) {
            throw new RuntimeException("Couldn't close the Sentry connection", e2);
        }
    }

    public void clearContext() {
        this.contextManager.clear();
    }

    public Context getContext() {
        return this.contextManager.getContext();
    }

    public String getRelease() {
        return this.release;
    }

    public String getDist() {
        return this.dist;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Set<String> getMdcTags() {
        return Collections.unmodifiableSet(this.mdcTags);
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setDist(String dist) {
        this.dist = dist;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void addTag(String name, String value) {
        this.tags.put(name, value);
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags == null ? new HashMap<String, String>() : tags;
    }

    @Deprecated
    public void setExtraTags(Set<String> extraTags) {
        this.setMdcTags(extraTags);
    }

    public void setMdcTags(Set<String> mdcTags) {
        this.mdcTags = mdcTags == null ? new HashSet<String>() : mdcTags;
    }

    @Deprecated
    public void addExtraTag(String extraName) {
        this.addMdcTag(extraName);
    }

    public void addMdcTag(String tagName) {
        this.mdcTags.add(tagName);
    }

    public void addExtra(String name, Object value) {
        this.extra.put(name, value);
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra == null ? new HashMap<String, Object>() : extra;
    }

    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.connection.addEventSendCallback(eventSendCallback);
    }

    public void addShouldSendEventCallback(ShouldSendEventCallback shouldSendEventCallback) {
        this.shouldSendEventCallbacks.add(shouldSendEventCallback);
    }

    protected void setupUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = SentryUncaughtExceptionHandler.setup();
    }

    public String toString() {
        return "SentryClient{release='" + this.release + '\'' + ", dist='" + this.dist + '\'' + ", environment='" + this.environment + '\'' + ", serverName='" + this.serverName + '\'' + ", tags=" + this.tags + ", mdcTags=" + this.mdcTags + ", extra=" + this.extra + ", connection=" + this.connection + ", builderHelpers=" + this.builderHelpers + ", contextManager=" + this.contextManager + ", uncaughtExceptionHandler=" + this.uncaughtExceptionHandler + '}';
    }
}

