/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.buffer;

import io.sentry.buffer.Buffer;
import io.sentry.event.Event;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBuffer
implements Buffer {
    public static final String FILE_SUFFIX = ".sentry-event";
    private static final Logger logger = LoggerFactory.getLogger(DiskBuffer.class);
    private int maxEvents;
    private final File bufferDir;

    public DiskBuffer(File bufferDir, int maxEvents) {
        this.bufferDir = bufferDir;
        this.maxEvents = maxEvents;
        String errMsg = "Could not create or write to disk buffer dir: " + bufferDir.getAbsolutePath();
        try {
            bufferDir.mkdirs();
            if (!bufferDir.isDirectory() || !bufferDir.canWrite()) {
                throw new RuntimeException(errMsg);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(errMsg, e2);
        }
        logger.debug(Integer.toString(this.getNumStoredEvents()) + " stored events found in dir: " + bufferDir.getAbsolutePath());
    }

    @Override
    public void add(Event event) {
        if (this.getNumStoredEvents() >= this.maxEvents) {
            logger.warn("Not adding Event because at least " + Integer.toString(this.maxEvents) + " events are already stored: " + event.getId());
            return;
        }
        File eventFile = new File(this.bufferDir.getAbsolutePath(), event.getId().toString() + FILE_SUFFIX);
        if (eventFile.exists()) {
            logger.trace("Not adding Event to offline storage because it already exists: " + eventFile.getAbsolutePath());
            return;
        }
        logger.debug("Adding Event to offline storage: " + eventFile.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(eventFile);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(event);
        }
        catch (Exception e2) {
            logger.error("Error writing Event to offline storage: " + event.getId(), e2);
        }
        logger.debug(Integer.toString(this.getNumStoredEvents()) + " stored events are now in dir: " + this.bufferDir.getAbsolutePath());
    }

    @Override
    public void discard(Event event) {
        File eventFile = new File(this.bufferDir, event.getId().toString() + FILE_SUFFIX);
        if (eventFile.exists()) {
            logger.debug("Discarding Event from offline storage: " + eventFile.getAbsolutePath());
            if (!eventFile.delete()) {
                logger.warn("Failed to delete Event: " + eventFile.getAbsolutePath());
            }
        }
    }

    private Event fileToEvent(File eventFile) {
        Object eventObj;
        try (FileInputStream fileInputStream = new FileInputStream(new File(eventFile.getAbsolutePath()));
             ObjectInputStream ois = new ObjectInputStream(fileInputStream);){
            eventObj = ois.readObject();
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (Exception e3) {
            logger.error("Error reading Event file: " + eventFile.getAbsolutePath(), e3);
            if (!eventFile.delete()) {
                logger.warn("Failed to delete Event: " + eventFile.getAbsolutePath());
            }
            return null;
        }
        try {
            return (Event)eventObj;
        }
        catch (Exception e4) {
            logger.error("Error casting Object to Event: " + eventFile.getAbsolutePath(), e4);
            if (!eventFile.delete()) {
                logger.warn("Failed to delete Event: " + eventFile.getAbsolutePath());
            }
            return null;
        }
    }

    private Event getNextEvent(Iterator<File> files) {
        while (files.hasNext()) {
            Event event;
            File file = files.next();
            if (!file.getAbsolutePath().endsWith(FILE_SUFFIX) || (event = this.fileToEvent(file)) == null) continue;
            return event;
        }
        return null;
    }

    @Override
    public Iterator<Event> getEvents() {
        final Iterator<File> files = Arrays.asList(this.bufferDir.listFiles()).iterator();
        return new Iterator<Event>(){
            private Event next;
            {
                this.next = DiskBuffer.this.getNextEvent(files);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Event next() {
                Event toReturn = this.next;
                this.next = DiskBuffer.this.getNextEvent(files);
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int getNumStoredEvents() {
        int count = 0;
        for (File file : this.bufferDir.listFiles()) {
            if (!file.getAbsolutePath().endsWith(FILE_SUFFIX)) continue;
            ++count;
        }
        return count;
    }
}

