/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.context;

import io.sentry.event.Breadcrumb;
import io.sentry.event.User;
import io.sentry.util.CircularFifoQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Context
implements Serializable {
    private static final int DEFAULT_BREADCRUMB_LIMIT = 100;
    private final int breadcrumbLimit;
    private volatile UUID lastEventId;
    private volatile CircularFifoQueue<Breadcrumb> breadcrumbs;
    private volatile User user;
    private volatile Map<String, String> tags;
    private volatile Map<String, Object> extra;

    public Context() {
        this(100);
    }

    public Context(int breadcrumbLimit) {
        this.breadcrumbLimit = breadcrumbLimit;
    }

    public synchronized void clear() {
        this.setLastEventId(null);
        this.clearBreadcrumbs();
        this.clearUser();
        this.clearTags();
        this.clearExtra();
    }

    public synchronized List<Breadcrumb> getBreadcrumbs() {
        if (this.breadcrumbs == null || this.breadcrumbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Breadcrumb> copyList = new ArrayList<Breadcrumb>(this.breadcrumbs.size());
        copyList.addAll(this.breadcrumbs);
        return copyList;
    }

    public synchronized Map<String, String> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.tags);
    }

    public synchronized Map<String, Object> getExtra() {
        if (this.extra == null || this.extra.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.extra);
    }

    public synchronized void addTag(String name, String value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(name, value);
    }

    public synchronized void removeTag(String name) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(name);
    }

    public synchronized void clearTags() {
        this.tags = null;
    }

    public synchronized void addExtra(String name, Object value) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        this.extra.put(name, value);
    }

    public synchronized void removeExtra(String name) {
        if (this.extra == null) {
            return;
        }
        this.extra.remove(name);
    }

    public synchronized void clearExtra() {
        this.extra = null;
    }

    public synchronized void recordBreadcrumb(Breadcrumb breadcrumb) {
        if (this.breadcrumbs == null) {
            this.breadcrumbs = new CircularFifoQueue(this.breadcrumbLimit);
        }
        this.breadcrumbs.add(breadcrumb);
    }

    public synchronized void clearBreadcrumbs() {
        this.breadcrumbs = null;
    }

    public void setLastEventId(UUID id) {
        this.lastEventId = id;
    }

    public UUID getLastEventId() {
        return this.lastEventId;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void clearUser() {
        this.setUser(null);
    }

    public User getUser() {
        return this.user;
    }
}

