/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class Breadcrumb
implements Serializable {
    private final Type type;
    private final Date timestamp;
    private final Level level;
    private final String message;
    private final String category;
    private final Map<String, String> data;

    Breadcrumb(Type type, Date timestamp, Level level, String message, String category, Map<String, String> data) {
        if (timestamp == null) {
            timestamp = new Date();
        }
        if (message == null && (data == null || data.size() < 1)) {
            throw new IllegalArgumentException("one of 'message' or 'data' must be set");
        }
        this.type = type;
        this.timestamp = timestamp;
        this.level = level;
        this.message = message;
        this.category = category;
        this.data = data;
    }

    public Type getType() {
        return this.type;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Breadcrumb that = (Breadcrumb)o2;
        return this.type == that.type && Objects.equals(this.timestamp, that.timestamp) && this.level == that.level && Objects.equals(this.message, that.message) && Objects.equals(this.category, that.category) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.timestamp, this.level, this.message, this.category, this.data});
    }

    public static enum Type {
        DEFAULT("default"),
        HTTP("http"),
        NAVIGATION("navigation"),
        USER("user");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Level {
        DEBUG("debug"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error"),
        CRITICAL("critical");

        private final String value;

        private Level(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

