/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event.interfaces;

import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.SentryStackTraceElement;
import io.sentry.jvmti.Frame;
import java.util.Arrays;

public class StackTraceInterface
implements SentryInterface {
    public static final String STACKTRACE_INTERFACE = "sentry.interfaces.Stacktrace";
    private final SentryStackTraceElement[] stackTrace;
    private final int framesCommonWithEnclosing;

    public StackTraceInterface(StackTraceElement[] stackTrace) {
        this(stackTrace, new StackTraceElement[0], null);
    }

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace) {
        this(stackTrace, enclosingStackTrace, null);
    }

    public StackTraceInterface(StackTraceElement[] stackTrace, StackTraceElement[] enclosingStackTrace, Frame[] cachedFrames) {
        this.stackTrace = SentryStackTraceElement.fromStackTraceElements(stackTrace, cachedFrames);
        int m3 = stackTrace.length - 1;
        for (int n2 = enclosingStackTrace.length - 1; m3 >= 0 && n2 >= 0 && stackTrace[m3].equals(enclosingStackTrace[n2]); --m3, --n2) {
        }
        this.framesCommonWithEnclosing = stackTrace.length - 1 - m3;
    }

    public StackTraceInterface(SentryStackTraceElement[] stackTrace) {
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
        this.framesCommonWithEnclosing = 0;
    }

    @Override
    public String getInterfaceName() {
        return STACKTRACE_INTERFACE;
    }

    public SentryStackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public int getFramesCommonWithEnclosing() {
        return this.framesCommonWithEnclosing;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        StackTraceInterface that = (StackTraceInterface)o2;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        return "StackTraceInterface{stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }
}

