/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;

public class SwingFXUtils {
    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage object, WritableImage writableImage) {
        int[] nArray;
        Object object2;
        Object object3;
        int n2 = ((BufferedImage)object).getWidth();
        int n3 = ((BufferedImage)object).getHeight();
        switch (((BufferedImage)object).getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                object3 = new BufferedImage(n2, n3, 3);
                object2 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object2).drawImage((Image)object, 0, 0, null);
                ((Graphics)object2).dispose();
                object = object3;
            }
        }
        if (writableImage != null) {
            int n4 = (int)writableImage.getWidth();
            int n5 = (int)writableImage.getHeight();
            if (n4 < n2 || n5 < n3) {
                writableImage = null;
            } else if (n2 < n4 || n3 < n5) {
                nArray = new int[n4];
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                WritablePixelFormat<IntBuffer> writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                if (n2 < n4) {
                    pixelWriter.setPixels(n2, 0, n4 - n2, n3, writablePixelFormat, nArray, 0, 0);
                }
                if (n3 < n5) {
                    pixelWriter.setPixels(0, n3, n4, n5 - n3, writablePixelFormat, nArray, 0, 0);
                }
            }
        }
        if (writableImage == null) {
            writableImage = new WritableImage(n2, n3);
        }
        object3 = writableImage.getPixelWriter();
        object2 = (DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer();
        nArray = ((DataBufferInt)object2).getData();
        int n6 = ((BufferedImage)object).getRaster().getDataBuffer().getOffset();
        int n7 = 0;
        SampleModel sampleModel = ((BufferedImage)object).getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n7 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        }
        WritablePixelFormat<IntBuffer> writablePixelFormat = ((BufferedImage)object).isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        object3.setPixels(0, 0, n2, n3, writablePixelFormat, nArray, n6, n7);
        return writableImage;
    }

    static int getBestBufferedImageType(PixelFormat<?> pixelFormat, BufferedImage bufferedImage, boolean bl) {
        int n2;
        if (bufferedImage != null && ((n2 = bufferedImage.getType()) == 2 || n2 == 3 || bl && (n2 == 4 || n2 == 1))) {
            return n2;
        }
        switch (pixelFormat.getType()) {
            default: {
                return 3;
            }
            case BYTE_BGRA: 
            case INT_ARGB: {
                return 2;
            }
            case BYTE_RGB: {
                return 1;
            }
            case BYTE_INDEXED: 
        }
        return pixelFormat.isPremultiplied() ? 3 : 2;
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 3: {
                return PixelFormat.getIntArgbPreInstance();
            }
            case 2: {
                return PixelFormat.getIntArgbInstance();
            }
        }
        throw new InternalError("Failed to validate BufferedImage type");
    }

    private static boolean checkFXImageOpaque(PixelReader pixelReader, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Color color = pixelReader.getColor(i2, i3);
                if (color.getOpacity() == 1.0) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage fromFXImage(javafx.scene.image.Image image, BufferedImage bufferedImage) {
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            return null;
        }
        int n2 = (int)image.getWidth();
        int n3 = (int)image.getHeight();
        PixelFormat pixelFormat = pixelReader.getPixelFormat();
        boolean bl = false;
        switch (pixelFormat.getType()) {
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: 
            case BYTE_BGRA: 
            case INT_ARGB: {
                if (bufferedImage == null || bufferedImage.getType() != 4 && bufferedImage.getType() != 1) break;
                bl = SwingFXUtils.checkFXImageOpaque(pixelReader, n2, n3);
                break;
            }
            case BYTE_RGB: {
                bl = true;
            }
        }
        int n4 = SwingFXUtils.getBestBufferedImageType(pixelReader.getPixelFormat(), bufferedImage, bl);
        if (bufferedImage != null) {
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            if (n5 < n2 || n6 < n3 || bufferedImage.getType() != n4) {
                bufferedImage = null;
            } else if (n2 < n5 || n3 < n6) {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.Clear);
                graphics2D.fillRect(0, 0, n5, n6);
                graphics2D.dispose();
            }
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n2, n3, n4);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n7 = bufferedImage.getRaster().getDataBuffer().getOffset();
        int n8 = 0;
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n8 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        }
        WritablePixelFormat<IntBuffer> writablePixelFormat = SwingFXUtils.getAssociatedPixelFormat(bufferedImage);
        pixelReader.getPixels(0, 0, n2, n3, writablePixelFormat, nArray, n7, n8);
        return bufferedImage;
    }
}

