/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.Disposer;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.embed.swing.newimpl.SwingNodeInteropN;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.TKStage;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.JComponent;
import javax.swing.Timer;
import jdk.swing.interop.LightweightFrameWrapper;

public class SwingNode
extends Node {
    private static boolean isThreadMerged;
    private double fxWidth;
    private double fxHeight;
    private int swingPrefWidth;
    private int swingPrefHeight;
    private int swingMaxWidth;
    private int swingMaxHeight;
    private int swingMinWidth;
    private int swingMinHeight;
    private volatile JComponent content;
    private volatile Object lwFrame;
    private NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private Timer deactivate;
    private SwingNodeInteropN swNodeIOP;
    private EventHandler windowHiddenHandler;
    private Window hWindow;
    private List<Runnable> peerRequests;
    private final InvalidationListener locationListener;
    private final EventHandler<FocusUngrabEvent> ungrabHandler;
    private final ChangeListener<Boolean> windowVisibleListener;
    private final ChangeListener<Window> sceneWindowListener;

    private final Object getLightweightFrame() {
        return this.lwFrame;
    }

    private ReentrantLock getPaintLock() {
        return this.paintLock;
    }

    public SwingNode() {
        SwingNodeHelper.initHelper(this);
        this.windowHiddenHandler = event -> {
            Window window;
            TKStage tKStage;
            if (this.lwFrame != null && event.getTarget() instanceof Window && (tKStage = WindowHelper.getPeer(window = (Window)event.getTarget())) != null) {
                if (isThreadMerged) {
                    this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, null);
                } else {
                    tKStage.postponeClose();
                    SwingNodeHelper.runOnEDT(() -> this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, 0L, () -> SwingNodeHelper.runOnFxThread(() -> tKStage.closePostponed())));
                }
            }
        };
        this.hWindow = null;
        this.peerRequests = new ArrayList<Runnable>();
        this.locationListener = observable -> this.locateLwFrame();
        this.ungrabHandler = focusUngrabEvent -> {
            if (!this.skipBackwardUnrgabNotification && this.lwFrame != null) {
                AccessController.doPrivileged(new PostEventAction(this.swNodeIOP.createUngrabEvent(this.lwFrame)));
            }
        };
        this.windowVisibleListener = (observableValue, bl, bl2) -> {
            if (!bl2.booleanValue()) {
                this.disposeLwFrame();
            } else {
                this.setContent(this.content);
            }
        };
        this.sceneWindowListener = (observableValue, window, window2) -> {
            if (window != null) {
                this.removeWindowListeners((Window)window);
            }
            this.notifyNativeHandle((Window)window2);
            if (window2 != null) {
                this.addWindowListeners((Window)window2);
            }
        };
        this.swNodeIOP = new SwingNodeInteropN();
        this.setFocusTraversable(true);
        this.setEventHandler(javafx.scene.input.MouseEvent.ANY, new SwingMouseEventHandler());
        this.setEventHandler(KeyEvent.ANY, new SwingKeyEventHandler());
        this.setEventHandler(ScrollEvent.SCROLL, new SwingScrollEventHandler());
        this.focusedProperty().addListener((observableValue, bl, bl2) -> this.activateLwFrame((boolean)bl2));
        Font.getFamilies();
    }

    private void notifyNativeHandle(Window window) {
        if (this.hWindow != window) {
            if (this.hWindow != null) {
                this.hWindow.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            if (window != null) {
                window.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.windowHiddenHandler);
            }
            this.hWindow = window;
        }
        if (this.lwFrame != null) {
            TKStage tKStage;
            long l2 = 0L;
            if (window != null && (tKStage = WindowHelper.getPeer(window)) != null) {
                l2 = tKStage.getRawHandle();
            }
            this.swNodeIOP.overrideNativeWindowHandle(this.lwFrame, l2, null);
        }
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
        SwingNodeHelper.runOnEDT(() -> this.setContentImpl(jComponent));
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent jComponent) {
        if (this.lwFrame != null) {
            this.swNodeIOP.disposeFrame(this.lwFrame);
            this.lwFrame = null;
        }
        if (jComponent != null) {
            Window window;
            this.lwFrame = this.swNodeIOP.createLightweightFrame();
            SwingNodeWindowFocusListener swingNodeWindowFocusListener = new SwingNodeWindowFocusListener(this);
            this.swNodeIOP.addWindowFocusListener(this.lwFrame, swingNodeWindowFocusListener);
            if (this.getScene() != null && (window = this.getScene().getWindow()) != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, window.getRenderScaleX(), window.getRenderScaleY());
            }
            this.swNodeIOP.setContent(this.lwFrame, this.swNodeIOP.createSwingNodeContent(jComponent, this));
            this.swNodeIOP.setVisible(this.lwFrame, true);
            Disposer.addRecord(this, this.swNodeIOP.createSwingNodeDisposer(this.lwFrame));
            if (this.getScene() != null) {
                this.notifyNativeHandle(this.getScene().getWindow());
            }
            SwingNodeHelper.runOnFxThread(() -> {
                this.locateLwFrame();
                if (this.focusedProperty().get()) {
                    this.activateLwFrame(true);
                }
            });
        }
    }

    void setImageBuffer(int[] nArray, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
        Runnable runnable = () -> this.peer.setImageBuffer(IntBuffer.wrap(nArray), n2, n3, n4, n5, n4, n5, n6, d2, d3);
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.clear();
                this.peerRequests.add(runnable);
            }
        });
    }

    void setImageBounds(int n2, int n3, int n4, int n5) {
        Runnable runnable = () -> this.peer.setImageBounds(n2, n3, n4, n5, n4, n5);
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.add(runnable);
            }
        });
    }

    void repaintDirtyRegion(int n2, int n3, int n4, int n5) {
        Runnable runnable = () -> {
            this.peer.repaintDirtyRegion(n2, n3, n4, n5);
            NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        };
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.peer != null) {
                runnable.run();
            } else {
                this.peerRequests.add(runnable);
            }
        });
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d2, double d3) {
        super.resize(d2, d3);
        if (d2 != this.fxWidth || d3 != this.fxHeight) {
            this.fxWidth = d2;
            this.fxHeight = d3;
            NodeHelper.geomChanged(this);
            NodeHelper.markDirty(this, DirtyBits.NODE_GEOMETRY);
            SwingNodeHelper.runOnEDT(() -> {
                if (this.lwFrame != null) {
                    this.locateLwFrame();
                }
            });
        }
    }

    @Override
    public double prefWidth(double d2) {
        return this.swingPrefWidth;
    }

    @Override
    public double prefHeight(double d2) {
        return this.swingPrefHeight;
    }

    @Override
    public double maxWidth(double d2) {
        return this.swingMaxWidth;
    }

    @Override
    public double maxHeight(double d2) {
        return this.swingMaxHeight;
    }

    @Override
    public double minWidth(double d2) {
        return this.swingMinWidth;
    }

    @Override
    public double minHeight(double d2) {
        return this.swingMinHeight;
    }

    private boolean doComputeContains(double d2, double d3) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
            this.notifyNativeHandle(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.widthProperty().addListener(this.locationListener);
        window.heightProperty().addListener(this.locationListener);
        window.renderScaleXProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
        this.setLwFrameScale(window.getRenderScaleX(), window.getRenderScaleY());
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.widthProperty().removeListener(this.locationListener);
        window.heightProperty().removeListener(this.locationListener);
        window.renderScaleXProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    private NGNode doCreatePeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable runnable : this.peerRequests) {
            runnable.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            this.addSceneListeners(this.getScene());
        }
        this.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                this.removeSceneListeners((Scene)scene);
                this.disposeLwFrame();
            }
            if (scene2 != null) {
                if (this.content != null && this.lwFrame == null) {
                    this.setContent(this.content);
                }
                this.addSceneListeners((Scene)scene2);
            }
        });
        NodeHelper.treeVisibleProperty(this).addListener((observableValue, bl, bl2) -> this.setLwFrameVisible((boolean)bl2));
        return this.peer;
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.NODE_VISIBLE) || NodeHelper.isDirty(this, DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        Window window = this.getScene().getWindow();
        double d2 = window.getRenderScaleX();
        double d3 = window.getRenderScaleY();
        Point2D point2D = this.localToScene(0.0, 0.0);
        int n2 = (int)window.getX();
        int n3 = (int)window.getY();
        int n4 = (int)window.getWidth();
        int n5 = (int)window.getHeight();
        int n6 = (int)Math.round(window.getX() + this.getScene().getX() + point2D.getX());
        int n7 = (int)Math.round(window.getY() + this.getScene().getY() + point2D.getY());
        int n8 = (int)this.fxWidth;
        int n9 = (int)this.fxHeight;
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, d2, d3);
                this.swNodeIOP.setBounds(this.lwFrame, n6, n7, n8, n9);
                this.swNodeIOP.setHostBounds(this.lwFrame, n2, n3, n4, n5);
            }
        });
    }

    private void activateLwFrame(boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        if (PlatformUtil.isLinux()) {
            if (this.deactivate == null || !this.deactivate.isRunning()) {
                if (!bl) {
                    this.deactivate = new Timer(50, actionEvent -> {
                        if (this.lwFrame != null) {
                            this.swNodeIOP.emulateActivation(this.lwFrame, false);
                        }
                    });
                    this.deactivate.start();
                    return;
                }
            } else {
                this.deactivate.stop();
            }
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.emulateActivation(this.lwFrame, bl);
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.disposeFrame(this.lwFrame);
                this.lwFrame = null;
            }
        });
    }

    private void setLwFrameVisible(boolean bl) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.setVisible(this.lwFrame, bl);
            }
        });
    }

    private void setLwFrameScale(double d2, double d3) {
        if (this.lwFrame == null) {
            return;
        }
        SwingNodeHelper.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.swNodeIOP.notifyDisplayChanged(this.lwFrame, d2, d3);
            }
        });
    }

    private BaseBounds doComputeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.fxWidth, (float)this.fxHeight, 0.0f);
        baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    private void ungrabFocus(boolean bl) {
        if (PlatformUtil.isLinux()) {
            return;
        }
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && WindowHelper.getPeer(this.getScene().getWindow()) != null) {
            this.skipBackwardUnrgabNotification = !bl;
            WindowHelper.getPeer(this.getScene().getWindow()).ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                isThreadMerged = Boolean.valueOf(System.getProperty("javafx.embed.singleThread"));
                return null;
            }
        });
        SwingNodeHelper.setSwingNodeAccessor(new SwingNodeHelper.SwingNodeAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((SwingNode)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((SwingNode)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds baseBounds, BaseTransform baseTransform) {
                return ((SwingNode)node).doComputeGeomBounds(baseBounds, baseTransform);
            }

            @Override
            public boolean doComputeContains(Node node, double d2, double d3) {
                return ((SwingNode)node).doComputeContains(d2, d3);
            }

            @Override
            public Object getLightweightFrame(SwingNode swingNode) {
                return swingNode.getLightweightFrame();
            }

            @Override
            public ReentrantLock getPaintLock(SwingNode swingNode) {
                return swingNode.getPaintLock();
            }

            @Override
            public void setImageBuffer(SwingNode swingNode, int[] nArray, int n2, int n3, int n4, int n5, int n6, double d2, double d3) {
                swingNode.setImageBuffer(nArray, n2, n3, n4, n5, n6, d2, d3);
            }

            @Override
            public void setImageBounds(SwingNode swingNode, int n2, int n3, int n4, int n5) {
                swingNode.setImageBounds(n2, n3, n4, n5);
            }

            @Override
            public void repaintDirtyRegion(SwingNode swingNode, int n2, int n3, int n4, int n5) {
                swingNode.repaintDirtyRegion(n2, n3, n4, n5);
            }

            @Override
            public void ungrabFocus(SwingNode swingNode, boolean bl) {
                swingNode.ungrabFocus(bl);
            }

            @Override
            public void setSwingPrefWidth(SwingNode swingNode, int n2) {
                swingNode.swingPrefWidth = n2;
            }

            @Override
            public void setSwingPrefHeight(SwingNode swingNode, int n2) {
                swingNode.swingPrefHeight = n2;
            }

            @Override
            public void setSwingMaxWidth(SwingNode swingNode, int n2) {
                swingNode.swingMaxWidth = n2;
            }

            @Override
            public void setSwingMaxHeight(SwingNode swingNode, int n2) {
                swingNode.swingMaxHeight = n2;
            }

            @Override
            public void setSwingMinWidth(SwingNode swingNode, int n2) {
                swingNode.swingMinWidth = n2;
            }

            @Override
            public void setSwingMinHeight(SwingNode swingNode, int n2) {
                swingNode.swingMinHeight = n2;
            }

            @Override
            public void setGrabbed(SwingNode swingNode, boolean bl) {
                swingNode.grabbed = bl;
            }
        });
    }

    private class SwingKeyEventHandler
    implements EventHandler<KeyEvent> {
        private SwingKeyEventHandler() {
        }

        @Override
        public void handle(KeyEvent keyEvent) {
            String string;
            int n2;
            LightweightFrameWrapper lightweightFrameWrapper = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (lightweightFrameWrapper == null) {
                return;
            }
            if (keyEvent.getCharacter().isEmpty()) {
                return;
            }
            if (keyEvent.getCode() == KeyCode.LEFT || keyEvent.getCode() == KeyCode.RIGHT || keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN || keyEvent.getCode() == KeyCode.TAB) {
                keyEvent.consume();
            }
            if ((n2 = SwingEvents.fxKeyEventTypeToKeyID(keyEvent)) < 0) {
                return;
            }
            int n3 = SwingEvents.fxKeyModsToKeyMods(keyEvent);
            int n4 = keyEvent.getCode().getCode();
            char c2 = keyEvent.getCharacter().charAt(0);
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && (string = keyEvent.getText()).length() == 1) {
                c2 = string.charAt(0);
            }
            long l2 = System.currentTimeMillis();
            java.awt.event.KeyEvent keyEvent2 = SwingNode.this.swNodeIOP.createKeyEvent(lightweightFrameWrapper, n2, l2, n3, n4, c2);
            AccessController.doPrivileged(new PostEventAction(keyEvent2));
        }
    }

    private class SwingScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private SwingScrollEventHandler() {
        }

        @Override
        public void handle(ScrollEvent scrollEvent) {
            double d2;
            boolean bl;
            LightweightFrameWrapper lightweightFrameWrapper = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (lightweightFrameWrapper == null) {
                return;
            }
            int n2 = SwingEvents.fxScrollModsToMouseWheelMods(scrollEvent);
            boolean bl2 = bl = (n2 & 0x40) != 0;
            if (!bl && scrollEvent.getDeltaY() != 0.0) {
                this.sendMouseWheelEvent(lightweightFrameWrapper, scrollEvent.getX(), scrollEvent.getY(), n2, scrollEvent.getDeltaY() / scrollEvent.getMultiplierY());
            }
            double d3 = d2 = bl && scrollEvent.getDeltaY() != 0.0 ? scrollEvent.getDeltaY() / scrollEvent.getMultiplierY() : scrollEvent.getDeltaX() / scrollEvent.getMultiplierX();
            if (d2 != 0.0) {
                this.sendMouseWheelEvent(lightweightFrameWrapper, scrollEvent.getX(), scrollEvent.getY(), n2 |= 0x40, d2);
            }
        }

        private void sendMouseWheelEvent(Object object, double d2, double d3, int n2, double d4) {
            int n3 = (int)d4;
            int n4 = (int)Math.signum(d4);
            if ((double)n4 * d4 < 1.0) {
                n3 = n4;
            }
            int n5 = (int)Math.round(d2);
            int n6 = (int)Math.round(d3);
            MouseWheelEvent mouseWheelEvent = SwingNode.this.swNodeIOP.createMouseWheelEvent(object, n2, n5, n6, -n3);
            AccessController.doPrivileged(new PostEventAction(mouseWheelEvent));
        }
    }

    private class SwingMouseEventHandler
    implements EventHandler<javafx.scene.input.MouseEvent> {
        private final Set<MouseButton> mouseClickedAllowed = new HashSet<MouseButton>();

        private SwingMouseEventHandler() {
        }

        @Override
        public void handle(javafx.scene.input.MouseEvent mouseEvent) {
            LightweightFrameWrapper lightweightFrameWrapper = SwingNode.this.swNodeIOP.getLightweightFrame();
            if (lightweightFrameWrapper == null) {
                return;
            }
            int n2 = SwingEvents.fxMouseEventTypeToMouseID(mouseEvent);
            if (n2 < 0) {
                return;
            }
            mouseEvent.consume();
            EventType<? extends javafx.scene.input.MouseEvent> eventType = mouseEvent.getEventType();
            if (eventType == javafx.scene.input.MouseEvent.MOUSE_PRESSED) {
                this.mouseClickedAllowed.add(mouseEvent.getButton());
            } else if (eventType != javafx.scene.input.MouseEvent.MOUSE_RELEASED) {
                if (eventType == javafx.scene.input.MouseEvent.MOUSE_DRAGGED) {
                    this.mouseClickedAllowed.clear();
                } else if (eventType == javafx.scene.input.MouseEvent.MOUSE_CLICKED) {
                    if (mouseEvent.getClickCount() == 1 && !this.mouseClickedAllowed.contains((Object)mouseEvent.getButton())) {
                        return;
                    }
                    this.mouseClickedAllowed.remove((Object)mouseEvent.getButton());
                }
            }
            int n3 = SwingEvents.fxMouseModsToMouseMods(mouseEvent);
            boolean bl = mouseEvent.isPopupTrigger();
            int n4 = SwingEvents.fxMouseButtonToMouseButton(mouseEvent);
            long l2 = System.currentTimeMillis();
            int n5 = (int)Math.round(mouseEvent.getX());
            int n6 = (int)Math.round(mouseEvent.getY());
            int n7 = (int)Math.round(mouseEvent.getScreenX());
            int n8 = (int)Math.round(mouseEvent.getScreenY());
            MouseEvent mouseEvent2 = SwingNode.this.swNodeIOP.createMouseEvent(lightweightFrameWrapper, n2, l2, n3, n5, n6, n7, n8, mouseEvent.getClickCount(), bl, n4);
            AccessController.doPrivileged(new PostEventAction(mouseEvent2));
        }
    }

    private class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        PostEventAction(AWTEvent aWTEvent) {
            this.event = aWTEvent;
        }

        @Override
        public Void run() {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(this.event);
            return null;
        }
    }

    private static class SwingNodeWindowFocusListener
    implements WindowFocusListener {
        private WeakReference<SwingNode> swingNodeRef;

        SwingNodeWindowFocusListener(SwingNode swingNode) {
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public void windowGainedFocus(java.awt.event.WindowEvent windowEvent) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.requestFocus();
                }
            });
        }

        @Override
        public void windowLostFocus(java.awt.event.WindowEvent windowEvent) {
            SwingNodeHelper.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.ungrabFocus(true);
                }
            });
        }
    }
}

