/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.FadeTransition;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.StyleOrigin;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.util.Duration;

public abstract class TableRowSkinBase<T, C extends IndexedCell, R extends IndexedCell>
extends CellSkinBase<C> {
    private static boolean IS_STUB_TOOLKIT = Toolkit.getToolkit().toString().contains("StubToolkit");
    private static boolean DO_ANIMATIONS = !IS_STUB_TOOLKIT && !PlatformUtil.isEmbedded();
    private static final Duration FADE_DURATION = Duration.millis(200.0);
    static final Map<TableColumnBase<?, ?>, Double> maxDisclosureWidthMap = new WeakHashMap();
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    WeakHashMap<TableColumnBase, Reference<R>> cellsMap;
    final List<R> cells = new ArrayList<R>();
    private int fullRefreshCounter = 100;
    boolean isDirty = false;
    boolean updateCells = false;
    double fixedCellSize;
    boolean fixedCellSizeEnabled;
    private ListChangeListener<TableColumnBase> visibleLeafColumnsListener = change -> {
        this.isDirty = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
    };
    private WeakListChangeListener<TableColumnBase> weakVisibleLeafColumnsListener = new WeakListChangeListener<TableColumnBase>(this.visibleLeafColumnsListener);

    public TableRowSkinBase(C c2) {
        super(c2);
        ((IndexedCell)this.getSkinnable()).setPickOnBounds(false);
        this.recreateCells();
        this.updateCells(true);
        this.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        ((Cell)c2).itemProperty().addListener(observable -> this.requestCellUpdate());
        this.registerChangeListener(((IndexedCell)c2).indexProperty(), observableValue -> {
            if (((IndexedCell)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
    }

    protected abstract R createCell(TableColumnBase<T, ?> var1);

    protected abstract void updateCell(R var1, C var2);

    protected abstract TableColumnBase<T, ?> getTableColumn(R var1);

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected ObjectProperty<Node> graphicProperty() {
        return null;
    }

    @Override
    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d2, d3, d4, d5);
            return;
        }
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        boolean bl = this.isIndentationRequired();
        boolean bl2 = this.isDisclosureNodeVisible();
        int n2 = 0;
        Node node = null;
        if (bl) {
            TableColumnBase tableColumnBase = this.getTreeColumn();
            n2 = tableColumnBase == null ? 0 : observableList.indexOf(tableColumnBase);
            n2 = n2 < 0 ? 0 : n2;
            int n3 = this.getIndentationLevel(indexedCell);
            if (!this.isShowRoot()) {
                --n3;
            }
            d7 = this.getIndentationPerLevel();
            d8 = (double)n3 * d7;
            d9 = d6 = maxDisclosureWidthMap.containsKey(tableColumnBase) ? maxDisclosureWidthMap.get(tableColumnBase) : 0.0;
            node = this.getDisclosureNode();
            if (node != null) {
                node.setVisible(bl2);
                if (bl2 && (d9 = node.prefWidth(d5)) > d6) {
                    maxDisclosureWidthMap.put(tableColumnBase, d9);
                    VirtualFlow<C> virtualFlow = this.getVirtualFlow();
                    int n4 = ((IndexedCell)this.getSkinnable()).getIndex();
                    for (int i2 = 0; i2 < virtualFlow.cells.size(); ++i2) {
                        IndexedCell indexedCell2 = (IndexedCell)virtualFlow.cells.get(i2);
                        if (indexedCell2 == null || indexedCell2.isEmpty()) continue;
                        indexedCell2.requestLayout();
                        indexedCell2.layout();
                    }
                }
            }
        }
        d6 = this.snappedTopInset() + this.snappedBottomInset();
        double d11 = this.snappedLeftInset() + this.snappedRightInset();
        double d12 = indexedCell.getHeight();
        int n5 = indexedCell.getIndex();
        if (n5 < 0) {
            return;
        }
        int n6 = this.cells.size();
        for (int i3 = 0; i3 < n6; ++i3) {
            double d13;
            IndexedCell indexedCell3 = (IndexedCell)this.cells.get(i3);
            TableColumnBase<T, ?> tableColumnBase = this.getTableColumn(indexedCell3);
            boolean bl3 = true;
            if (this.fixedCellSizeEnabled) {
                bl3 = this.isColumnPartiallyOrFullyVisible(tableColumnBase);
                d7 = this.fixedCellSize;
            } else {
                d7 = Math.max(d12, indexedCell3.prefHeight(-1.0));
                d7 = this.snapSizeY(d7) - this.snapSizeY(d6);
            }
            if (bl3) {
                if (this.fixedCellSizeEnabled && indexedCell3.getParent() == null) {
                    this.getChildren().add(indexedCell3);
                }
                d13 = indexedCell3.prefWidth(d7) - this.snapSizeX(d11);
                boolean bl4 = d5 <= 24.0;
                StyleOrigin styleOrigin = ((StyleableObjectProperty)indexedCell3.alignmentProperty()).getStyleOrigin();
                if (!bl4 && styleOrigin == null) {
                    indexedCell3.setAlignment(Pos.TOP_LEFT);
                }
                if (bl && i3 == n2) {
                    ObjectProperty<Node> objectProperty;
                    Node node2;
                    if (bl2) {
                        double d14 = node.prefHeight(d9);
                        if (d13 > 0.0 && d13 < d9 + d8) {
                            this.fadeOut(node);
                        } else {
                            this.fadeIn(node);
                            node.resize(d9, d14);
                            node.relocate(d2 + d8, bl4 ? d5 / 2.0 - d14 / 2.0 : d3 + indexedCell3.getPadding().getTop());
                            node.toFront();
                        }
                    }
                    Node node3 = node2 = (objectProperty = this.graphicProperty()) == null ? null : (Node)objectProperty.get();
                    if (node2 != null) {
                        d10 = node2.prefWidth(-1.0) + 3.0;
                        double d15 = node2.prefHeight(d10);
                        if (d13 > 0.0 && d13 < d9 + d8 + d10) {
                            this.fadeOut(node2);
                        } else {
                            this.fadeIn(node2);
                            node2.relocate(d2 + d8 + d9, bl4 ? d5 / 2.0 - d15 / 2.0 : d3 + indexedCell3.getPadding().getTop());
                            node2.toFront();
                        }
                    }
                }
                indexedCell3.resize(d13, d7);
                indexedCell3.relocate(d2, this.snappedTopInset());
                indexedCell3.requestLayout();
            } else {
                d13 = this.snapSizeX(indexedCell3.prefWidth(-1.0)) - this.snapSizeX(d11);
                if (this.fixedCellSizeEnabled) {
                    this.getChildren().remove(indexedCell3);
                }
            }
            d2 += d13;
        }
    }

    int getIndentationLevel(C c2) {
        return 0;
    }

    double getIndentationPerLevel() {
        return 0.0;
    }

    boolean isIndentationRequired() {
        return false;
    }

    TableColumnBase getTreeColumn() {
        return null;
    }

    Node getDisclosureNode() {
        return null;
    }

    boolean isDisclosureNodeVisible() {
        return false;
    }

    boolean isShowRoot() {
        return true;
    }

    void updateCells(boolean bl) {
        if (bl) {
            if (this.fullRefreshCounter == 0) {
                this.recreateCells();
            }
            --this.fullRefreshCounter;
        }
        boolean bl2 = this.cells.isEmpty();
        this.cells.clear();
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        int n2 = indexedCell.getIndex();
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n3 = observableList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumnBase eventTarget = (TableColumnBase)observableList.get(i2);
            IndexedCell indexedCell2 = null;
            if (this.cellsMap.containsKey(eventTarget) && (indexedCell2 = (IndexedCell)this.cellsMap.get(eventTarget).get()) == null) {
                this.cellsMap.remove(eventTarget);
            }
            if (indexedCell2 == null) {
                indexedCell2 = (IndexedCell)this.createCellAndCache(eventTarget);
            }
            this.updateCell(indexedCell2, indexedCell);
            indexedCell2.updateIndex(n2);
            this.cells.add(indexedCell2);
        }
        if (this.fixedCellSizeEnabled) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : this.getChildren()) {
                if (!(node instanceof IndexedCell) || this.getTableColumn((IndexedCell)node).isVisible()) continue;
                arrayList.add(node);
            }
            this.getChildren().removeAll((Collection<?>)arrayList);
        } else if (!this.fixedCellSizeEnabled && (bl || bl2)) {
            this.getChildren().setAll((Collection<Node>)this.cells);
        }
    }

    VirtualFlow<C> getVirtualFlow() {
        for (Object object = this.getSkinnable(); object != null; object = ((Node)object).getParent()) {
            if (!(object instanceof VirtualFlow)) continue;
            return (VirtualFlow)object;
        }
        return null;
    }

    @Override
    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        for (IndexedCell indexedCell : this.cells) {
            d7 += indexedCell.prefWidth(d2);
        }
        return d7;
    }

    @Override
    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double d7 = 0.0;
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            d7 = Math.max(d7, indexedCell.prefHeight(-1.0));
        }
        double d8 = Math.max(d7, Math.max(this.getCellSize(), ((IndexedCell)this.getSkinnable()).minHeight(-1.0)));
        return d8;
    }

    @Override
    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize();
        }
        double d7 = 0.0;
        int n2 = this.cells.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i2);
            d7 = Math.max(d7, indexedCell.minHeight(-1.0));
        }
        return d7;
    }

    @Override
    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }

    final void checkState() {
        if (this.isDirty) {
            this.updateCells(true);
            this.isDirty = false;
            this.updateCells = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    private boolean isColumnPartiallyOrFullyVisible(TableColumnBase tableColumnBase) {
        Object object;
        if (tableColumnBase == null || !tableColumnBase.isVisible()) {
            return false;
        }
        VirtualFlow<C> virtualFlow = this.getVirtualFlow();
        double d2 = virtualFlow == null ? 0.0 : virtualFlow.getHbar().getValue();
        double d3 = 0.0;
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2 && !(object = (TableColumnBase)observableList.get(i2)).equals(tableColumnBase); ++i2) {
            d3 += ((TableColumnBase)object).getWidth();
        }
        double d4 = d3 + tableColumnBase.getWidth();
        object = ((IndexedCell)this.getSkinnable()).getPadding();
        double d5 = ((IndexedCell)this.getSkinnable()).getWidth() - ((Insets)object).getLeft() + ((Insets)object).getRight();
        return (d3 >= d2 || d4 > d2) && (d3 < d5 + d2 || d4 <= d5 + d2);
    }

    private void requestCellUpdate() {
        this.updateCells = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
        int n2 = ((IndexedCell)this.getSkinnable()).getIndex();
        int n3 = this.cells.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ((IndexedCell)this.cells.get(i2)).updateIndex(n2);
        }
    }

    private void recreateCells() {
        Collection<Object> collection;
        if (this.cellsMap != null) {
            collection = this.cellsMap.values();
            for (Object object : collection) {
                IndexedCell indexedCell = (IndexedCell)((Reference)object).get();
                if (indexedCell == null) continue;
                indexedCell.updateIndex(-1);
                indexedCell.getSkin().dispose();
                indexedCell.setSkin(null);
            }
            this.cellsMap.clear();
        }
        collection = this.getVisibleLeafColumns();
        this.cellsMap = new WeakHashMap(collection.size());
        this.fullRefreshCounter = 100;
        this.getChildren().clear();
        for (Object object : collection) {
            if (this.cellsMap.containsKey(object)) continue;
            this.createCellAndCache((TableColumnBase<T, ?>)object);
        }
    }

    private R createCellAndCache(TableColumnBase<T, ?> tableColumnBase) {
        R r2 = this.createCell(tableColumnBase);
        this.cellsMap.put(tableColumnBase, new WeakReference<R>(r2));
        return r2;
    }

    private void fadeOut(Node node) {
        if (node.getOpacity() < 1.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(0.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(0.0);
        fadeTransition.play();
    }

    private void fadeIn(Node node) {
        if (node.getOpacity() > 0.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(1.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
    }
}

