/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableCellSkinBase;
import javafx.scene.control.skin.TableRowSkinBase;
import javafx.scene.control.skin.TreeTableRowSkin;

public class TreeTableCellSkin<S, T>
extends TableCellSkinBase<TreeItem<S>, T, TreeTableCell<S, T>> {
    private final BehaviorBase<TreeTableCell<S, T>> behavior;

    public TreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell);
        this.behavior = new TreeTableCellBehavior<S, T>(treeTableCell);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    public ReadOnlyObjectProperty<TreeTableColumn<S, T>> tableColumnProperty() {
        return ((TreeTableCell)this.getSkinnable()).tableColumnProperty();
    }

    @Override
    double leftLabelPadding() {
        double d2 = super.leftLabelPadding();
        double d3 = this.getCellSize();
        TreeTableCell treeTableCell = (TreeTableCell)this.getSkinnable();
        TreeTableColumn treeTableColumn = treeTableCell.getTableColumn();
        if (treeTableColumn == null) {
            return d2;
        }
        TreeTableView treeTableView = treeTableCell.getTreeTableView();
        if (treeTableView == null) {
            return d2;
        }
        int n2 = treeTableView.getVisibleLeafIndex(treeTableColumn);
        TreeTableColumn treeTableColumn2 = treeTableView.getTreeColumn();
        if (treeTableColumn2 == null && n2 != 0 || treeTableColumn2 != null && !treeTableColumn.equals(treeTableColumn2)) {
            return d2;
        }
        TreeTableRow treeTableRow = treeTableCell.getTreeTableRow();
        if (treeTableRow == null) {
            return d2;
        }
        TreeItem treeItem = treeTableRow.getTreeItem();
        if (treeItem == null) {
            return d2;
        }
        int n3 = treeTableView.getTreeItemLevel(treeItem);
        if (!treeTableView.isShowRoot()) {
            --n3;
        }
        double d4 = 10.0;
        if (treeTableRow.getSkin() instanceof TreeTableRowSkin) {
            d4 = ((TreeTableRowSkin)treeTableRow.getSkin()).getIndentationPerLevel();
        }
        d2 += (double)n3 * d4;
        Map<TableColumnBase<?, ?>, Double> map = TableRowSkinBase.maxDisclosureWidthMap;
        d2 += map.containsKey(treeTableColumn2) ? map.get(treeTableColumn2) : 0.0;
        Node node = treeItem.getGraphic();
        return d2 += node == null ? 0.0 : node.prefWidth(d3);
    }
}

