/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTree
implements Tree {
    protected List<Object> children;

    public BaseTree() {
    }

    public BaseTree(Tree node) {
    }

    @Override
    public Tree getChild(int i2) {
        if (this.children == null || i2 >= this.children.size()) {
            return null;
        }
        return (Tree)this.children.get(i2);
    }

    public List<? extends Object> getChildren() {
        return this.children;
    }

    public Tree getFirstChildWithType(int type) {
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            Tree t2 = (Tree)this.children.get(i2);
            if (t2.getType() != type) continue;
            return t2;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void addChild(Tree t2) {
        if (t2 == null) {
            return;
        }
        BaseTree childTree = (BaseTree)t2;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n2 = childTree.children.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Tree c2 = (Tree)childTree.children.get(i2);
                        this.children.add(c2);
                        c2.setParent(this);
                        c2.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(t2);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<? extends Tree> kids) {
        for (int i2 = 0; i2 < kids.size(); ++i2) {
            Tree t2 = kids.get(i2);
            this.addChild(t2);
        }
    }

    @Override
    public void setChild(int i2, Tree t2) {
        if (t2 == null) {
            return;
        }
        if (t2.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i2, t2);
        t2.setParent(this);
        t2.setChildIndex(i2);
    }

    public void insertChild(int i2, Object t2) {
        if (i2 < 0 || i2 > this.getChildCount()) {
            throw new IndexOutOfBoundsException(i2 + " out or range");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.add(i2, t2);
        this.freshenParentAndChildIndexes(i2);
    }

    @Override
    public Object deleteChild(int i2) {
        if (this.children == null) {
            return null;
        }
        Tree killed = (Tree)this.children.remove(i2);
        this.freshenParentAndChildIndexes(i2);
        return killed;
    }

    @Override
    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t2) {
        List<Object> newChildren;
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        BaseTree newTree = (BaseTree)t2;
        if (newTree.isNil()) {
            newChildren = newTree.children;
        } else {
            newChildren = new ArrayList<Object>(1);
            newChildren.add(newTree);
        }
        int replacingWithHowMany = newChildren.size();
        int numNewChildren = newChildren.size();
        int delta = replacingHowMany - replacingWithHowMany;
        if (delta == 0) {
            int j2 = 0;
            for (int i2 = startChildIndex; i2 <= stopChildIndex; ++i2) {
                BaseTree child = (BaseTree)newChildren.get(j2);
                this.children.set(i2, child);
                child.setParent(this);
                child.setChildIndex(i2);
                ++j2;
            }
        } else if (delta > 0) {
            int indexToDelete;
            for (int j3 = 0; j3 < numNewChildren; ++j3) {
                this.children.set(startChildIndex + j3, newChildren.get(j3));
            }
            for (int c2 = indexToDelete = startChildIndex + numNewChildren; c2 <= stopChildIndex; ++c2) {
                this.children.remove(indexToDelete);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            for (int j4 = 0; j4 < replacingHowMany; ++j4) {
                this.children.set(startChildIndex + j4, newChildren.get(j4));
            }
            int numToInsert = replacingWithHowMany - replacingHowMany;
            for (int j5 = replacingHowMany; j5 < replacingWithHowMany; ++j5) {
                this.children.add(startChildIndex + j5, newChildren.get(j5));
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List<Object> createChildrenList() {
        return new ArrayList<Object>();
    }

    @Override
    public boolean isNil() {
        return false;
    }

    @Override
    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n2 = this.getChildCount();
        for (int c2 = offset; c2 < n2; ++c2) {
            Tree child = this.getChild(c2);
            child.setChildIndex(c2);
            child.setParent(this);
        }
    }

    public void freshenParentAndChildIndexesDeeply() {
        this.freshenParentAndChildIndexesDeeply(0);
    }

    public void freshenParentAndChildIndexesDeeply(int offset) {
        int n2 = this.getChildCount();
        for (int c2 = offset; c2 < n2; ++c2) {
            BaseTree child = (BaseTree)this.getChild(c2);
            child.setChildIndex(c2);
            child.setParent(this);
            child.freshenParentAndChildIndexesDeeply();
        }
    }

    public void sanityCheckParentAndChildIndexes() {
        this.sanityCheckParentAndChildIndexes(null, -1);
    }

    public void sanityCheckParentAndChildIndexes(Tree parent, int i2) {
        if (parent != this.getParent()) {
            throw new IllegalStateException("parents don't match; expected " + parent + " found " + this.getParent());
        }
        if (i2 != this.getChildIndex()) {
            throw new IllegalStateException("child indexes don't match; expected " + i2 + " found " + this.getChildIndex());
        }
        int n2 = this.getChildCount();
        for (int c2 = 0; c2 < n2; ++c2) {
            CommonTree child = (CommonTree)this.getChild(c2);
            child.sanityCheckParentAndChildIndexes(this, c2);
        }
    }

    @Override
    public int getChildIndex() {
        return 0;
    }

    @Override
    public void setChildIndex(int index) {
    }

    @Override
    public Tree getParent() {
        return null;
    }

    @Override
    public void setParent(Tree t2) {
    }

    @Override
    public boolean hasAncestor(int ttype) {
        return this.getAncestor(ttype) != null;
    }

    @Override
    public Tree getAncestor(int ttype) {
        Tree t2 = this;
        for (t2 = t2.getParent(); t2 != null; t2 = t2.getParent()) {
            if (t2.getType() != ttype) continue;
            return t2;
        }
        return null;
    }

    public List<? extends Tree> getAncestors() {
        if (this.getParent() == null) {
            return null;
        }
        ArrayList<Tree> ancestors = new ArrayList<Tree>();
        Tree t2 = this;
        for (t2 = t2.getParent(); t2 != null; t2 = t2.getParent()) {
            ancestors.add(0, t2);
        }
        return ancestors;
    }

    @Override
    public String toStringTree() {
        if (this.children == null || this.children.isEmpty()) {
            return this.toString();
        }
        StringBuilder buf = new StringBuilder();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            Tree t2 = (Tree)this.children.get(i2);
            if (i2 > 0) {
                buf.append(' ');
            }
            buf.append(t2.toStringTree());
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getCharPositionInLine() {
        return 0;
    }

    @Override
    public abstract String toString();
}

