/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.misc.CharSupport;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockEndState;
import org.antlr.v4.runtime.atn.CodePointTransitions;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.EpsilonTransition;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;

public class ATNOptimizer {
    public static void optimize(Grammar g2, ATN atn) {
        ATNOptimizer.optimizeSets(g2, atn);
        ATNOptimizer.optimizeStates(atn);
    }

    private static void optimizeSets(Grammar g2, ATN atn) {
        if (g2.isParser()) {
            return;
        }
        int removedStates = 0;
        List<DecisionState> decisions = atn.decisionToState;
        for (DecisionState decision : decisions) {
            int i2;
            if (decision.ruleIndex >= 0) {
                Rule rule = g2.getRule(decision.ruleIndex);
                if (Character.isLowerCase(rule.name.charAt(0))) continue;
            }
            IntervalSet setTransitions = new IntervalSet(new int[0]);
            for (i2 = 0; i2 < decision.getNumberOfTransitions(); ++i2) {
                Transition epsTransition = decision.transition(i2);
                if (!(epsTransition instanceof EpsilonTransition) || epsTransition.target.getNumberOfTransitions() != 1) continue;
                Transition transition = epsTransition.target.transition(0);
                if (!(transition.target instanceof BlockEndState) || transition instanceof NotSetTransition || !(transition instanceof AtomTransition) && !(transition instanceof RangeTransition) && !(transition instanceof SetTransition)) continue;
                setTransitions.add(i2);
            }
            for (i2 = setTransitions.getIntervals().size() - 1; i2 >= 0; --i2) {
                Transition newTransition;
                Interval interval = setTransitions.getIntervals().get(i2);
                if (interval.length() <= 1) continue;
                ATNState blockEndState = decision.transition((int)interval.a).target.transition((int)0).target;
                IntervalSet matchSet = new IntervalSet(new int[0]);
                for (int j2 = interval.a; j2 <= interval.b; ++j2) {
                    Transition matchTransition = decision.transition((int)j2).target.transition(0);
                    if (matchTransition instanceof NotSetTransition) {
                        throw new UnsupportedOperationException("Not yet implemented.");
                    }
                    IntervalSet set = matchTransition.label();
                    List<Interval> intervals = set.getIntervals();
                    int n2 = intervals.size();
                    block4: for (int k2 = 0; k2 < n2; ++k2) {
                        Interval setInterval = intervals.get(k2);
                        int a2 = setInterval.a;
                        int b2 = setInterval.b;
                        if (a2 == -1 || b2 == -1) continue;
                        for (int v2 = a2; v2 <= b2; ++v2) {
                            if (!matchSet.contains(v2)) continue;
                            g2.tool.errMgr.grammarError(ErrorType.CHARACTERS_COLLISION_IN_SET, g2.fileName, null, CharSupport.getANTLRCharLiteralForChar(v2), CharSupport.getIntervalSetEscapedString(matchSet));
                            continue block4;
                        }
                    }
                    matchSet.addAll(set);
                }
                if (matchSet.getIntervals().size() == 1) {
                    if (matchSet.size() == 1) {
                        newTransition = CodePointTransitions.createWithCodePoint(blockEndState, matchSet.getMinElement());
                    } else {
                        Interval matchInterval = matchSet.getIntervals().get(0);
                        newTransition = CodePointTransitions.createWithCodePointRange(blockEndState, matchInterval.a, matchInterval.b);
                    }
                } else {
                    newTransition = new SetTransition(blockEndState, matchSet);
                }
                decision.transition((int)interval.a).target.setTransition(0, newTransition);
                for (int j3 = interval.a + 1; j3 <= interval.b; ++j3) {
                    Transition removed = decision.removeTransition(interval.a + 1);
                    atn.removeState(removed.target);
                    ++removedStates;
                }
            }
        }
    }

    private static void optimizeStates(ATN atn) {
        ArrayList<ATNState> compressed = new ArrayList<ATNState>();
        int i2 = 0;
        for (ATNState s2 : atn.states) {
            if (s2 == null) continue;
            compressed.add(s2);
            s2.stateNumber = i2++;
        }
        atn.states.clear();
        atn.states.addAll(compressed);
    }

    private ATNOptimizer() {
    }
}

