/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.v4.codegen.OutputModelFactory;
import org.antlr.v4.codegen.model.Action;
import org.antlr.v4.codegen.model.CodeBlockForOuterMostAlt;
import org.antlr.v4.codegen.model.ElementFrequenciesVisitor;
import org.antlr.v4.codegen.model.ExceptionClause;
import org.antlr.v4.codegen.model.ModelElement;
import org.antlr.v4.codegen.model.OutputModelObject;
import org.antlr.v4.codegen.model.SrcOp;
import org.antlr.v4.codegen.model.decl.AltLabelStructDecl;
import org.antlr.v4.codegen.model.decl.AttributeDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.Decl;
import org.antlr.v4.codegen.model.decl.StructDecl;
import org.antlr.v4.misc.FrequencySet;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.parse.GrammarASTAdaptor;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.OrderedHashSet;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.GrammarAST;

public class RuleFunction
extends OutputModelObject {
    public String name;
    public List<String> modifiers;
    public String ctxType;
    public Collection<String> ruleLabels;
    public Collection<String> tokenLabels;
    public ATNState startState;
    public int index;
    public Rule rule;
    public AltLabelStructDecl[] altToContext;
    public boolean hasLookaheadBlock;
    @ModelElement
    public List<SrcOp> code;
    @ModelElement
    public OrderedHashSet<Decl> locals;
    @ModelElement
    public Collection<AttributeDecl> args = null;
    @ModelElement
    public StructDecl ruleCtx;
    @ModelElement
    public Map<String, AltLabelStructDecl> altLabelCtxs;
    @ModelElement
    public Map<String, Action> namedActions;
    @ModelElement
    public Action finallyAction;
    @ModelElement
    public List<ExceptionClause> exceptions;
    @ModelElement
    public List<SrcOp> postamble;

    public RuleFunction(OutputModelFactory factory, Rule r2) {
        super(factory);
        Collection<Attribute> decls;
        this.name = r2.name;
        this.rule = r2;
        if (r2.modifiers != null && !r2.modifiers.isEmpty()) {
            this.modifiers = new ArrayList<String>();
            for (GrammarAST grammarAST : r2.modifiers) {
                this.modifiers.add(grammarAST.getText());
            }
        }
        this.modifiers = Utils.nodesToStrings(r2.modifiers);
        this.index = r2.index;
        this.ruleCtx = new StructDecl(factory, r2);
        this.altToContext = new AltLabelStructDecl[r2.getOriginalNumberOfAlts() + 1];
        this.addContextGetters(factory, r2);
        if (r2.args != null && (decls = r2.args.attributes.values()).size() > 0) {
            this.args = new ArrayList<AttributeDecl>();
            this.ruleCtx.addDecls(decls);
            for (Attribute a2 : decls) {
                this.args.add(new AttributeDecl(factory, a2));
            }
            this.ruleCtx.ctorAttrs = this.args;
        }
        if (r2.retvals != null) {
            this.ruleCtx.addDecls(r2.retvals.attributes.values());
        }
        if (r2.locals != null) {
            this.ruleCtx.addDecls(r2.locals.attributes.values());
        }
        this.ruleLabels = r2.getElementLabelNames();
        this.tokenLabels = r2.getTokenRefs();
        if (r2.exceptions != null) {
            this.exceptions = new ArrayList<ExceptionClause>();
            for (GrammarAST grammarAST : r2.exceptions) {
                ActionAST catchArg = (ActionAST)grammarAST.getChild(0);
                ActionAST catchAction = (ActionAST)grammarAST.getChild(1);
                this.exceptions.add(new ExceptionClause(factory, catchArg, catchAction));
            }
        }
        this.startState = factory.getGrammar().atn.ruleToStartState[r2.index];
    }

    public void addContextGetters(OutputModelFactory factory, Rule r2) {
        List<AltAST> altsNoLabels = r2.getUnlabeledAltASTs();
        if (altsNoLabels != null) {
            Set<Decl> decls = this.getDeclsForAllElements(altsNoLabels);
            for (Decl decl : decls) {
                this.ruleCtx.addDecl(decl);
            }
        }
        this.altLabelCtxs = new HashMap<String, AltLabelStructDecl>();
        Map<String, List<Pair<Integer, AltAST>>> labels = r2.getAltLabels();
        if (labels != null) {
            for (Map.Entry entry : labels.entrySet()) {
                String label = (String)entry.getKey();
                ArrayList<AltAST> alts = new ArrayList<AltAST>();
                for (Pair pair : (List)entry.getValue()) {
                    alts.add((AltAST)pair.b);
                }
                Set<Decl> decls = this.getDeclsForAllElements(alts);
                for (Pair pair : (List)entry.getValue()) {
                    Integer altNum = (Integer)pair.a;
                    this.altToContext[altNum.intValue()] = new AltLabelStructDecl(factory, r2, altNum, label);
                    if (!this.altLabelCtxs.containsKey(label)) {
                        this.altLabelCtxs.put(label, this.altToContext[altNum]);
                    }
                    for (Decl d3 : decls) {
                        this.altToContext[altNum].addDecl(d3);
                    }
                }
            }
        }
    }

    public void fillNamedActions(OutputModelFactory factory, Rule r2) {
        if (r2.finallyAction != null) {
            this.finallyAction = new Action(factory, r2.finallyAction);
        }
        this.namedActions = new HashMap<String, Action>();
        for (String name : r2.namedActions.keySet()) {
            ActionAST ast = r2.namedActions.get(name);
            this.namedActions.put(name, new Action(factory, ast));
        }
    }

    public Set<Decl> getDeclsForAllElements(List<AltAST> altASTs) {
        HashSet<String> needsList = new HashSet<String>();
        HashSet<String> nonOptional = new HashSet<String>();
        ArrayList<GrammarAST> allRefs = new ArrayList<GrammarAST>();
        boolean firstAlt = true;
        for (AltAST ast : altASTs) {
            IntervalSet reftypes = new IntervalSet(57, 66);
            List<GrammarAST> refs = ast.getNodesWithType(reftypes);
            allRefs.addAll(refs);
            Pair<FrequencySet<String>, FrequencySet<String>> minAndAltFreq = this.getElementFrequenciesForAlt(ast);
            FrequencySet minFreq = (FrequencySet)minAndAltFreq.a;
            FrequencySet altFreq = (FrequencySet)minAndAltFreq.b;
            for (GrammarAST t2 : refs) {
                String refLabelName = t2.getText();
                if (altFreq.count(refLabelName) > 1) {
                    needsList.add(refLabelName);
                }
                if (!firstAlt || minFreq.count(refLabelName) == 0) continue;
                nonOptional.add(refLabelName);
            }
            for (String ref : nonOptional.toArray(new String[nonOptional.size()])) {
                if (minFreq.count(ref) != 0) continue;
                nonOptional.remove(ref);
            }
            firstAlt = false;
        }
        LinkedHashSet<Decl> decls = new LinkedHashSet<Decl>();
        for (GrammarAST t3 : allRefs) {
            String refLabelName = t3.getText();
            List<Decl> d2 = this.getDeclForAltElement(t3, refLabelName, needsList.contains(refLabelName), !nonOptional.contains(refLabelName));
            decls.addAll(d2);
        }
        return decls;
    }

    protected Pair<FrequencySet<String>, FrequencySet<String>> getElementFrequenciesForAlt(AltAST ast) {
        try {
            ElementFrequenciesVisitor visitor = new ElementFrequenciesVisitor(new CommonTreeNodeStream(new GrammarASTAdaptor(), ast));
            visitor.outerAlternative();
            if (visitor.frequencies.size() != 1) {
                this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, new Object[0]);
                return new Pair<FrequencySet<String>, FrequencySet<String>>(new FrequencySet(), new FrequencySet());
            }
            return new Pair<FrequencySet<String>, FrequencySet<String>>(visitor.getMinFrequencies(), visitor.frequencies.peek());
        }
        catch (RecognitionException ex) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
            return new Pair<FrequencySet<String>, FrequencySet<String>>(new FrequencySet(), new FrequencySet());
        }
    }

    public List<Decl> getDeclForAltElement(GrammarAST t2, String refLabelName, boolean needList, boolean optional) {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        if (t2.getType() == 57) {
            Rule rref = this.factory.getGrammar().getRule(t2.getText());
            String ctxName = this.factory.getGenerator().getTarget().getRuleFunctionContextStructName(rref);
            if (needList) {
                if (this.factory.getGenerator().getTarget().supportsOverloadedMethods()) {
                    decls.add(new ContextRuleListGetterDecl(this.factory, refLabelName, ctxName));
                }
                decls.add(new ContextRuleListIndexedGetterDecl(this.factory, refLabelName, ctxName));
            } else {
                decls.add(new ContextRuleGetterDecl(this.factory, refLabelName, ctxName, optional));
            }
        } else if (needList) {
            if (this.factory.getGenerator().getTarget().supportsOverloadedMethods()) {
                decls.add(new ContextTokenListGetterDecl(this.factory, refLabelName));
            }
            decls.add(new ContextTokenListIndexedGetterDecl(this.factory, refLabelName));
        } else {
            decls.add(new ContextTokenGetterDecl(this.factory, refLabelName, optional));
        }
        return decls;
    }

    public void addLocalDecl(Decl d2) {
        if (this.locals == null) {
            this.locals = new OrderedHashSet();
        }
        this.locals.add(d2);
        d2.isLocal = true;
    }

    public void addContextDecl(String altLabel, Decl d2) {
        AltLabelStructDecl altCtx;
        CodeBlockForOuterMostAlt alt = d2.getOuterMostAltCodeBlock();
        if (alt != null && this.altLabelCtxs != null && (altCtx = this.altLabelCtxs.get(altLabel)) != null) {
            altCtx.addDecl(d2);
            return;
        }
        this.ruleCtx.addDecl(d2);
    }
}

