/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.OrderedHashSet;

public class Graph<T> {
    protected Map<T, Node<T>> nodes = new LinkedHashMap<T, Node<T>>();

    public void addEdge(T a2, T b2) {
        Node<T> a_node = this.getNode(a2);
        Node<T> b_node = this.getNode(b2);
        a_node.addEdge(b_node);
    }

    public Node<T> getNode(T a2) {
        Node<T> existing = this.nodes.get(a2);
        if (existing != null) {
            return existing;
        }
        Node<T> n2 = new Node<T>(a2);
        this.nodes.put(a2, n2);
        return n2;
    }

    public List<T> sort() {
        OrderedHashSet<Node<T>> visited = new OrderedHashSet<Node<T>>();
        ArrayList sorted = new ArrayList();
        while (visited.size() < this.nodes.size()) {
            Node<T> tNode;
            Node<T> n2 = null;
            Iterator<Node<T>> iterator = this.nodes.values().iterator();
            while (iterator.hasNext() && visited.contains(n2 = (tNode = iterator.next()))) {
            }
            if (n2 == null) continue;
            this.DFS(n2, visited, sorted);
        }
        return sorted;
    }

    public void DFS(Node<T> n2, Set<Node<T>> visited, ArrayList<T> sorted) {
        if (visited.contains(n2)) {
            return;
        }
        visited.add(n2);
        if (n2.edges != null) {
            for (Node target : n2.edges) {
                this.DFS(target, visited, sorted);
            }
        }
        sorted.add(n2.payload);
    }

    public static class Node<T> {
        public T payload;
        public List<Node<T>> edges = Collections.EMPTY_LIST;

        public Node(T payload) {
            this.payload = payload;
        }

        public void addEdge(Node<T> n2) {
            if (this.edges == Collections.EMPTY_LIST) {
                this.edges = new ArrayList<Node<T>>();
            }
            if (!this.edges.contains(n2)) {
                this.edges.add(n2);
            }
        }

        public String toString() {
            return this.payload.toString();
        }
    }
}

