/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.semantics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.v4.automata.LexerATNFactory;
import org.antlr.v4.semantics.SymbolCollector;
import org.antlr.v4.tool.Alternative;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.AttributeDict;
import org.antlr.v4.tool.ErrorManager;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.LabelElementPair;
import org.antlr.v4.tool.LabelType;
import org.antlr.v4.tool.LeftRecursiveRule;
import org.antlr.v4.tool.LexerGrammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.TerminalAST;

public class SymbolChecks {
    Grammar g;
    SymbolCollector collector;
    Map<String, Rule> nameToRuleMap = new HashMap<String, Rule>();
    Set<String> tokenIDs = new HashSet<String>();
    Map<String, Set<String>> actionScopeToActionNames = new HashMap<String, Set<String>>();
    public ErrorManager errMgr;
    protected final Set<String> reservedNames = new HashSet<String>();

    public SymbolChecks(Grammar g2, SymbolCollector collector) {
        this.reservedNames.addAll(LexerATNFactory.getCommonConstants());
        this.g = g2;
        this.collector = collector;
        this.errMgr = g2.tool.errMgr;
        for (GrammarAST tokenId : collector.tokenIDRefs) {
            this.tokenIDs.add(tokenId.getText());
        }
    }

    public void process() {
        if (this.g.rules != null) {
            for (Rule r2 : this.g.rules.values()) {
                this.nameToRuleMap.put(r2.name, r2);
            }
        }
        this.checkReservedNames(this.g.rules.values());
        this.checkActionRedefinitions(this.collector.namedActions);
        this.checkForLabelConflicts(this.g.rules.values());
    }

    public void checkActionRedefinitions(List<GrammarAST> actions) {
        if (actions == null) {
            return;
        }
        String scope = this.g.getDefaultActionScope();
        for (GrammarAST ampersandAST : actions) {
            String name;
            GrammarAST nameNode = (GrammarAST)ampersandAST.getChild(0);
            if (ampersandAST.getChildCount() == 2) {
                name = nameNode.getText();
            } else {
                scope = nameNode.getText();
                name = ampersandAST.getChild(1).getText();
            }
            Set<String> scopeActions = this.actionScopeToActionNames.get(scope);
            if (scopeActions == null) {
                scopeActions = new HashSet<String>();
                this.actionScopeToActionNames.put(scope, scopeActions);
            }
            if (!scopeActions.contains(name)) {
                scopeActions.add(name);
                continue;
            }
            this.errMgr.grammarError(ErrorType.ACTION_REDEFINITION, this.g.fileName, nameNode.token, name);
        }
    }

    public void checkForLabelConflicts(Collection<Rule> rules) {
        for (Rule r2 : rules) {
            this.checkForAttributeConflicts(r2);
            HashMap<String, LabelElementPair> labelNameSpace = new HashMap<String, LabelElementPair>();
            for (int i2 = 1; i2 <= r2.numberOfAlts; ++i2) {
                Alternative a2 = r2.alt[i2];
                for (List pairs : a2.labelDefs.values()) {
                    if (r2.hasAltSpecificContexts()) {
                        HashMap labelPairs = new HashMap();
                        for (LabelElementPair p2 : pairs) {
                            List<LabelElementPair> list;
                            String labelName = this.findAltLabelName(p2.label);
                            if (labelName == null) continue;
                            if (labelPairs.containsKey(labelName)) {
                                list = (List)labelPairs.get(labelName);
                            } else {
                                list = new ArrayList();
                                labelPairs.put(labelName, list);
                            }
                            list.add(p2);
                        }
                        for (List internalPairs : labelPairs.values()) {
                            labelNameSpace.clear();
                            this.checkLabelPairs(r2, labelNameSpace, internalPairs);
                        }
                        continue;
                    }
                    this.checkLabelPairs(r2, labelNameSpace, pairs);
                }
            }
        }
    }

    private void checkLabelPairs(Rule r2, Map<String, LabelElementPair> labelNameSpace, List<LabelElementPair> pairs) {
        for (LabelElementPair p2 : pairs) {
            this.checkForLabelConflict(r2, p2.label);
            String name = p2.label.getText();
            LabelElementPair prev = labelNameSpace.get(name);
            if (prev == null) {
                labelNameSpace.put(name, p2);
                continue;
            }
            this.checkForTypeMismatch(r2, prev, p2);
        }
    }

    private String findAltLabelName(CommonTree label) {
        if (label == null) {
            return null;
        }
        if (label instanceof AltAST) {
            AltAST altAST = (AltAST)label;
            if (altAST.altLabel != null) {
                return altAST.altLabel.toString();
            }
            if (altAST.leftRecursiveAltInfo != null) {
                return altAST.leftRecursiveAltInfo.altLabel.toString();
            }
            return this.findAltLabelName(label.parent);
        }
        return this.findAltLabelName(label.parent);
    }

    private void checkForTypeMismatch(Rule r2, LabelElementPair prevLabelPair, LabelElementPair labelPair) {
        Token token;
        if (prevLabelPair.type != labelPair.type) {
            token = r2 instanceof LeftRecursiveRule ? ((GrammarAST)r2.ast.getChild(0)).getToken() : labelPair.label.token;
            this.errMgr.grammarError(ErrorType.LABEL_TYPE_CONFLICT, this.g.fileName, token, labelPair.label.getText(), (Object)((Object)labelPair.type) + "!=" + (Object)((Object)prevLabelPair.type));
        }
        if (!prevLabelPair.element.getText().equals(labelPair.element.getText()) && (prevLabelPair.type.equals((Object)LabelType.RULE_LABEL) || prevLabelPair.type.equals((Object)LabelType.RULE_LIST_LABEL)) && (labelPair.type.equals((Object)LabelType.RULE_LABEL) || labelPair.type.equals((Object)LabelType.RULE_LIST_LABEL))) {
            token = r2 instanceof LeftRecursiveRule ? ((GrammarAST)r2.ast.getChild(0)).getToken() : labelPair.label.token;
            String prevLabelOp = prevLabelPair.type.equals((Object)LabelType.RULE_LIST_LABEL) ? "+=" : "=";
            String labelOp = labelPair.type.equals((Object)LabelType.RULE_LIST_LABEL) ? "+=" : "=";
            this.errMgr.grammarError(ErrorType.LABEL_TYPE_CONFLICT, this.g.fileName, token, labelPair.label.getText() + labelOp + labelPair.element.getText(), prevLabelPair.label.getText() + prevLabelOp + prevLabelPair.element.getText());
        }
    }

    public void checkForLabelConflict(Rule r2, GrammarAST labelID) {
        ErrorType etype;
        String name = labelID.getText();
        if (this.nameToRuleMap.containsKey(name)) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_RULE;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r2.name);
        }
        if (this.tokenIDs.contains(name)) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_TOKEN;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r2.name);
        }
        if (r2.args != null && r2.args.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_ARG;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r2.name);
        }
        if (r2.retvals != null && r2.retvals.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_RETVAL;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r2.name);
        }
        if (r2.locals != null && r2.locals.get(name) != null) {
            etype = ErrorType.LABEL_CONFLICTS_WITH_LOCAL;
            this.errMgr.grammarError(etype, this.g.fileName, labelID.token, name, r2.name);
        }
    }

    public void checkForAttributeConflicts(Rule r2) {
        this.checkDeclarationRuleConflicts(r2, r2.args, this.nameToRuleMap.keySet(), ErrorType.ARG_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r2, r2.args, this.tokenIDs, ErrorType.ARG_CONFLICTS_WITH_TOKEN);
        this.checkDeclarationRuleConflicts(r2, r2.retvals, this.nameToRuleMap.keySet(), ErrorType.RETVAL_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r2, r2.retvals, this.tokenIDs, ErrorType.RETVAL_CONFLICTS_WITH_TOKEN);
        this.checkDeclarationRuleConflicts(r2, r2.locals, this.nameToRuleMap.keySet(), ErrorType.LOCAL_CONFLICTS_WITH_RULE);
        this.checkDeclarationRuleConflicts(r2, r2.locals, this.tokenIDs, ErrorType.LOCAL_CONFLICTS_WITH_TOKEN);
        this.checkLocalConflictingDeclarations(r2, r2.retvals, r2.args, ErrorType.RETVAL_CONFLICTS_WITH_ARG);
        this.checkLocalConflictingDeclarations(r2, r2.locals, r2.args, ErrorType.LOCAL_CONFLICTS_WITH_ARG);
        this.checkLocalConflictingDeclarations(r2, r2.locals, r2.retvals, ErrorType.LOCAL_CONFLICTS_WITH_RETVAL);
    }

    protected void checkDeclarationRuleConflicts(Rule r2, AttributeDict attributes, Set<String> ruleNames, ErrorType errorType) {
        if (attributes == null) {
            return;
        }
        for (Attribute attribute : attributes.attributes.values()) {
            if (!ruleNames.contains(attribute.name)) continue;
            this.errMgr.grammarError(errorType, this.g.fileName, attribute.token != null ? attribute.token : ((GrammarAST)r2.ast.getChild((int)0)).token, attribute.name, r2.name);
        }
    }

    protected void checkLocalConflictingDeclarations(Rule r2, AttributeDict attributes, AttributeDict referenceAttributes, ErrorType errorType) {
        if (attributes == null || referenceAttributes == null) {
            return;
        }
        Set<String> conflictingKeys = attributes.intersection(referenceAttributes);
        for (String key : conflictingKeys) {
            this.errMgr.grammarError(errorType, this.g.fileName, attributes.get((String)key).token != null ? attributes.get((String)key).token : ((GrammarAST)r2.ast.getChild((int)0)).token, key, r2.name);
        }
    }

    protected void checkReservedNames(Collection<Rule> rules) {
        for (Rule rule : rules) {
            if (!this.reservedNames.contains(rule.name)) continue;
            this.errMgr.grammarError(ErrorType.RESERVED_RULE_NAME, this.g.fileName, ((GrammarAST)rule.ast.getChild(0)).getToken(), rule.name);
        }
    }

    public void checkForModeConflicts(Grammar g2) {
        if (g2.isLexer()) {
            LexerGrammar lexerGrammar = (LexerGrammar)g2;
            for (String modeName : lexerGrammar.modes.keySet()) {
                Rule rule;
                if (!modeName.equals("DEFAULT_MODE") && this.reservedNames.contains(modeName)) {
                    rule = (Rule)((List)lexerGrammar.modes.get(modeName)).iterator().next();
                    g2.tool.errMgr.grammarError(ErrorType.MODE_CONFLICTS_WITH_COMMON_CONSTANTS, g2.fileName, rule.ast.parent.getToken(), modeName);
                }
                if (g2.getTokenType(modeName) == 0) continue;
                rule = (Rule)((List)lexerGrammar.modes.get(modeName)).iterator().next();
                g2.tool.errMgr.grammarError(ErrorType.MODE_CONFLICTS_WITH_TOKEN, g2.fileName, rule.ast.parent.getToken(), modeName);
            }
        }
    }

    public void checkForUnreachableTokens(Grammar g2) {
        if (g2.isLexer()) {
            LexerGrammar lexerGrammar = (LexerGrammar)g2;
            for (List rules : lexerGrammar.modes.values()) {
                int i2;
                ArrayList<Rule> stringLiteralRules = new ArrayList<Rule>();
                ArrayList<List<String>> stringLiteralValues = new ArrayList<List<String>>();
                for (i2 = 0; i2 < rules.size(); ++i2) {
                    Rule rule = (Rule)rules.get(i2);
                    List<String> ruleStringAlts = this.getSingleTokenValues(rule);
                    if (ruleStringAlts == null || ruleStringAlts.size() <= 0) continue;
                    stringLiteralRules.add(rule);
                    stringLiteralValues.add(ruleStringAlts);
                }
                for (i2 = 0; i2 < stringLiteralRules.size(); ++i2) {
                    List firstTokenStringValues = (List)stringLiteralValues.get(i2);
                    Rule rule1 = (Rule)stringLiteralRules.get(i2);
                    this.checkForOverlap(g2, rule1, rule1, firstTokenStringValues, (List)stringLiteralValues.get(i2));
                    if (rule1.isFragment()) continue;
                    for (int j2 = i2 + 1; j2 < stringLiteralRules.size(); ++j2) {
                        Rule rule2 = (Rule)stringLiteralRules.get(j2);
                        if (rule2.isFragment()) continue;
                        this.checkForOverlap(g2, rule1, (Rule)stringLiteralRules.get(j2), firstTokenStringValues, (List)stringLiteralValues.get(j2));
                    }
                }
            }
        }
    }

    private List<String> getSingleTokenValues(Rule rule) {
        ArrayList<String> values = new ArrayList<String>();
        for (Alternative alt : rule.alt) {
            AltAST rootNode;
            if (alt == null) continue;
            Tree tree = rootNode = alt.ast.getChildCount() == 2 && alt.ast.getChild(0) instanceof AltAST && alt.ast.getChild(1) instanceof GrammarAST ? alt.ast.getChild(0) : alt.ast;
            if (rootNode.getTokenStartIndex() == -1) continue;
            boolean ignore = false;
            StringBuilder currentValue = new StringBuilder();
            for (int i2 = 0; i2 < rootNode.getChildCount(); ++i2) {
                Tree child = rootNode.getChild(i2);
                if (!(child instanceof TerminalAST)) {
                    ignore = true;
                    break;
                }
                TerminalAST terminalAST = (TerminalAST)child;
                if (terminalAST.token.getType() != 62) {
                    ignore = true;
                    break;
                }
                String text = terminalAST.token.getText();
                currentValue.append(text.substring(1, text.length() - 1));
            }
            if (ignore) continue;
            values.add(currentValue.toString());
        }
        return values;
    }

    private void checkForOverlap(Grammar g2, Rule rule1, Rule rule2, List<String> firstTokenStringValues, List<String> secondTokenStringValues) {
        for (int i2 = 0; i2 < firstTokenStringValues.size(); ++i2) {
            int secondTokenInd = rule1 == rule2 ? i2 + 1 : 0;
            String str1 = firstTokenStringValues.get(i2);
            for (int j2 = secondTokenInd; j2 < secondTokenStringValues.size(); ++j2) {
                String str2 = secondTokenStringValues.get(j2);
                if (!str1.equals(str2)) continue;
                this.errMgr.grammarError(ErrorType.TOKEN_UNREACHABLE, g2.fileName, ((GrammarAST)rule2.ast.getChild((int)0)).token, rule2.name, str2, rule1.name);
            }
        }
    }

    public void checkRuleArgs(Grammar g2, List<GrammarAST> rulerefs) {
        if (rulerefs == null) {
            return;
        }
        for (GrammarAST ref : rulerefs) {
            String ruleName = ref.getText();
            Rule r2 = g2.getRule(ruleName);
            GrammarAST arg = (GrammarAST)ref.getFirstChildWithType(8);
            if (arg != null && (r2 == null || r2.args == null)) {
                this.errMgr.grammarError(ErrorType.RULE_HAS_NO_ARGS, g2.fileName, ref.token, ruleName);
                continue;
            }
            if (arg != null || r2 == null || r2.args == null) continue;
            this.errMgr.grammarError(ErrorType.MISSING_RULE_ARGS, g2.fileName, ref.token, ruleName);
        }
    }

    public void checkForQualifiedRuleIssues(Grammar g2, List<GrammarAST> qualifiedRuleRefs) {
        for (GrammarAST dot : qualifiedRuleRefs) {
            GrammarAST grammar = (GrammarAST)dot.getChild(0);
            GrammarAST rule = (GrammarAST)dot.getChild(1);
            g2.tool.log("semantics", grammar.getText() + "." + rule.getText());
            Grammar delegate = g2.getImportedGrammar(grammar.getText());
            if (delegate == null) {
                this.errMgr.grammarError(ErrorType.NO_SUCH_GRAMMAR_SCOPE, g2.fileName, grammar.token, grammar.getText(), rule.getText());
                continue;
            }
            if (g2.getRule(grammar.getText(), rule.getText()) != null) continue;
            this.errMgr.grammarError(ErrorType.NO_SUCH_RULE_IN_SCOPE, g2.fileName, rule.token, grammar.getText(), rule.getText());
        }
    }
}

