/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import org.apache.lucene.analysis.util.StemmerUtil;

public class ArabicStemmer {
    public static final char ALEF = '\u0627';
    public static final char BEH = '\u0628';
    public static final char TEH_MARBUTA = '\u0629';
    public static final char TEH = '\u062a';
    public static final char FEH = '\u0641';
    public static final char KAF = '\u0643';
    public static final char LAM = '\u0644';
    public static final char NOON = '\u0646';
    public static final char HEH = '\u0647';
    public static final char WAW = '\u0648';
    public static final char YEH = '\u064a';
    public static final char[][] prefixes = new char[][]{"\u0627\u0644".toCharArray(), "\u0648\u0627\u0644".toCharArray(), "\u0628\u0627\u0644".toCharArray(), "\u0643\u0627\u0644".toCharArray(), "\u0641\u0627\u0644".toCharArray(), "\u0644\u0644".toCharArray(), "\u0648".toCharArray()};
    public static final char[][] suffixes = new char[][]{"\u0647\u0627".toCharArray(), "\u0627\u0646".toCharArray(), "\u0627\u062a".toCharArray(), "\u0648\u0646".toCharArray(), "\u064a\u0646".toCharArray(), "\u064a\u0647".toCharArray(), "\u064a\u0629".toCharArray(), "\u0647".toCharArray(), "\u0629".toCharArray(), "\u064a".toCharArray()};

    public int stem(char[] s2, int len) {
        len = this.stemPrefix(s2, len);
        len = this.stemSuffix(s2, len);
        return len;
    }

    public int stemPrefix(char[] s2, int len) {
        for (int i2 = 0; i2 < prefixes.length; ++i2) {
            if (!this.startsWithCheckLength(s2, len, prefixes[i2])) continue;
            return StemmerUtil.deleteN(s2, 0, len, prefixes[i2].length);
        }
        return len;
    }

    public int stemSuffix(char[] s2, int len) {
        for (int i2 = 0; i2 < suffixes.length; ++i2) {
            if (!this.endsWithCheckLength(s2, len, suffixes[i2])) continue;
            len = StemmerUtil.deleteN(s2, len - suffixes[i2].length, len, suffixes[i2].length);
        }
        return len;
    }

    boolean startsWithCheckLength(char[] s2, int len, char[] prefix) {
        if (prefix.length == 1 && len < 4) {
            return false;
        }
        if (len < prefix.length + 2) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.length; ++i2) {
            if (s2[i2] == prefix[i2]) continue;
            return false;
        }
        return true;
    }

    boolean endsWithCheckLength(char[] s2, int len, char[] suffix) {
        if (len < suffix.length + 2) {
            return false;
        }
        for (int i2 = 0; i2 < suffix.length; ++i2) {
            if (s2[len - suffix.length + i2] == suffix[i2]) continue;
            return false;
        }
        return true;
    }
}

