/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.CompoundWordTokenFilterBase;

public class DictionaryCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    public DictionaryCompoundWordTokenFilter(TokenStream input, CharArraySet dictionary) {
        super(input, dictionary);
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary must not be null");
        }
    }

    public DictionaryCompoundWordTokenFilter(TokenStream input, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary must not be null");
        }
    }

    @Override
    protected void decompose() {
        int len = this.termAtt.length();
        for (int i2 = 0; i2 <= len - this.minSubwordSize; ++i2) {
            CompoundWordTokenFilterBase.CompoundToken longestMatchToken = null;
            for (int j2 = this.minSubwordSize; j2 <= this.maxSubwordSize && i2 + j2 <= len; ++j2) {
                if (!this.dictionary.contains(this.termAtt.buffer(), i2, j2)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.txt.length() >= j2) continue;
                        longestMatchToken = new CompoundWordTokenFilterBase.CompoundToken(i2, j2);
                        continue;
                    }
                    longestMatchToken = new CompoundWordTokenFilterBase.CompoundToken(i2, j2);
                    continue;
                }
                this.tokens.add(new CompoundWordTokenFilterBase.CompoundToken(i2, j2));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

