/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.util.Locale;

public class GermanStemmer {
    private StringBuilder sb = new StringBuilder();
    private int substCount = 0;
    private static final Locale locale = new Locale("de", "DE");

    protected String stem(String term) {
        if (!this.isStemmable(term = term.toLowerCase(locale))) {
            return term;
        }
        this.sb.delete(0, this.sb.length());
        this.sb.insert(0, term);
        this.substitute(this.sb);
        this.strip(this.sb);
        this.optimize(this.sb);
        this.resubstitute(this.sb);
        this.removeParticleDenotion(this.sb);
        return this.sb.toString();
    }

    private boolean isStemmable(String term) {
        for (int c2 = 0; c2 < term.length(); ++c2) {
            if (Character.isLetter(term.charAt(c2))) continue;
            return false;
        }
        return true;
    }

    private void strip(StringBuilder buffer) {
        boolean doMore = true;
        while (doMore && buffer.length() > 3) {
            if (buffer.length() + this.substCount > 5 && buffer.substring(buffer.length() - 2, buffer.length()).equals("nd")) {
                buffer.delete(buffer.length() - 2, buffer.length());
                continue;
            }
            if (buffer.length() + this.substCount > 4 && buffer.substring(buffer.length() - 2, buffer.length()).equals("em")) {
                buffer.delete(buffer.length() - 2, buffer.length());
                continue;
            }
            if (buffer.length() + this.substCount > 4 && buffer.substring(buffer.length() - 2, buffer.length()).equals("er")) {
                buffer.delete(buffer.length() - 2, buffer.length());
                continue;
            }
            if (buffer.charAt(buffer.length() - 1) == 'e') {
                buffer.deleteCharAt(buffer.length() - 1);
                continue;
            }
            if (buffer.charAt(buffer.length() - 1) == 's') {
                buffer.deleteCharAt(buffer.length() - 1);
                continue;
            }
            if (buffer.charAt(buffer.length() - 1) == 'n') {
                buffer.deleteCharAt(buffer.length() - 1);
                continue;
            }
            if (buffer.charAt(buffer.length() - 1) == 't') {
                buffer.deleteCharAt(buffer.length() - 1);
                continue;
            }
            doMore = false;
        }
    }

    private void optimize(StringBuilder buffer) {
        if (buffer.length() > 5 && buffer.substring(buffer.length() - 5, buffer.length()).equals("erin*")) {
            buffer.deleteCharAt(buffer.length() - 1);
            this.strip(buffer);
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == 'z') {
            buffer.setCharAt(buffer.length() - 1, 'x');
        }
    }

    private void removeParticleDenotion(StringBuilder buffer) {
        if (buffer.length() > 4) {
            for (int c2 = 0; c2 < buffer.length() - 3; ++c2) {
                if (!buffer.substring(c2, c2 + 4).equals("gege")) continue;
                buffer.delete(c2, c2 + 2);
                return;
            }
        }
    }

    private void substitute(StringBuilder buffer) {
        this.substCount = 0;
        for (int c2 = 0; c2 < buffer.length(); ++c2) {
            if (c2 > 0 && buffer.charAt(c2) == buffer.charAt(c2 - 1)) {
                buffer.setCharAt(c2, '*');
            } else if (buffer.charAt(c2) == '\u00e4') {
                buffer.setCharAt(c2, 'a');
            } else if (buffer.charAt(c2) == '\u00f6') {
                buffer.setCharAt(c2, 'o');
            } else if (buffer.charAt(c2) == '\u00fc') {
                buffer.setCharAt(c2, 'u');
            } else if (buffer.charAt(c2) == '\u00df') {
                buffer.setCharAt(c2, 's');
                buffer.insert(c2 + 1, 's');
                ++this.substCount;
            }
            if (c2 >= buffer.length() - 1) continue;
            if (c2 < buffer.length() - 2 && buffer.charAt(c2) == 's' && buffer.charAt(c2 + 1) == 'c' && buffer.charAt(c2 + 2) == 'h') {
                buffer.setCharAt(c2, '$');
                buffer.delete(c2 + 1, c2 + 3);
                this.substCount += 2;
                continue;
            }
            if (buffer.charAt(c2) == 'c' && buffer.charAt(c2 + 1) == 'h') {
                buffer.setCharAt(c2, '\u00a7');
                buffer.deleteCharAt(c2 + 1);
                ++this.substCount;
                continue;
            }
            if (buffer.charAt(c2) == 'e' && buffer.charAt(c2 + 1) == 'i') {
                buffer.setCharAt(c2, '%');
                buffer.deleteCharAt(c2 + 1);
                ++this.substCount;
                continue;
            }
            if (buffer.charAt(c2) == 'i' && buffer.charAt(c2 + 1) == 'e') {
                buffer.setCharAt(c2, '&');
                buffer.deleteCharAt(c2 + 1);
                ++this.substCount;
                continue;
            }
            if (buffer.charAt(c2) == 'i' && buffer.charAt(c2 + 1) == 'g') {
                buffer.setCharAt(c2, '#');
                buffer.deleteCharAt(c2 + 1);
                ++this.substCount;
                continue;
            }
            if (buffer.charAt(c2) != 's' || buffer.charAt(c2 + 1) != 't') continue;
            buffer.setCharAt(c2, '!');
            buffer.deleteCharAt(c2 + 1);
            ++this.substCount;
        }
    }

    private void resubstitute(StringBuilder buffer) {
        for (int c2 = 0; c2 < buffer.length(); ++c2) {
            if (buffer.charAt(c2) == '*') {
                char x2 = buffer.charAt(c2 - 1);
                buffer.setCharAt(c2, x2);
                continue;
            }
            if (buffer.charAt(c2) == '$') {
                buffer.setCharAt(c2, 's');
                buffer.insert(c2 + 1, new char[]{'c', 'h'}, 0, 2);
                continue;
            }
            if (buffer.charAt(c2) == '\u00a7') {
                buffer.setCharAt(c2, 'c');
                buffer.insert(c2 + 1, 'h');
                continue;
            }
            if (buffer.charAt(c2) == '%') {
                buffer.setCharAt(c2, 'e');
                buffer.insert(c2 + 1, 'i');
                continue;
            }
            if (buffer.charAt(c2) == '&') {
                buffer.setCharAt(c2, 'i');
                buffer.insert(c2 + 1, 'e');
                continue;
            }
            if (buffer.charAt(c2) == '#') {
                buffer.setCharAt(c2, 'i');
                buffer.insert(c2 + 1, 'g');
                continue;
            }
            if (buffer.charAt(c2) != '!') continue;
            buffer.setCharAt(c2, 's');
            buffer.insert(c2 + 1, 't');
        }
    }
}

