/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gl;

import java.util.Map;
import org.apache.lucene.analysis.pt.RSLPStemmerBase;

public class GalicianStemmer
extends RSLPStemmerBase {
    private static final RSLPStemmerBase.Step plural;
    private static final RSLPStemmerBase.Step unification;
    private static final RSLPStemmerBase.Step adverb;
    private static final RSLPStemmerBase.Step augmentative;
    private static final RSLPStemmerBase.Step noun;
    private static final RSLPStemmerBase.Step verb;
    private static final RSLPStemmerBase.Step vowel;

    public int stem(char[] s2, int len) {
        int oldlen;
        assert (s2.length >= len + 1) : "this stemmer requires an oversized array of at least 1";
        len = plural.apply(s2, len);
        len = unification.apply(s2, len);
        len = adverb.apply(s2, len);
        do {
            oldlen = len;
        } while ((len = augmentative.apply(s2, len)) != oldlen);
        oldlen = len;
        if ((len = noun.apply(s2, len)) == oldlen) {
            len = verb.apply(s2, len);
        }
        len = vowel.apply(s2, len);
        block8: for (int i2 = 0; i2 < len; ++i2) {
            switch (s2[i2]) {
                case '\u00e1': {
                    s2[i2] = 97;
                    continue block8;
                }
                case '\u00e9': 
                case '\u00ea': {
                    s2[i2] = 101;
                    continue block8;
                }
                case '\u00ed': {
                    s2[i2] = 105;
                    continue block8;
                }
                case '\u00f3': {
                    s2[i2] = 111;
                    continue block8;
                }
                case '\u00fa': {
                    s2[i2] = 117;
                }
            }
        }
        return len;
    }

    static {
        Map<String, RSLPStemmerBase.Step> steps = GalicianStemmer.parse(GalicianStemmer.class, "galician.rslp");
        plural = steps.get("Plural");
        unification = steps.get("Unification");
        adverb = steps.get("Adverb");
        augmentative = steps.get("Augmentative");
        noun = steps.get("Noun");
        verb = steps.get("Verb");
        vowel = steps.get("Vowel");
    }
}

