/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.hunspell.ISO8859_14Decoder;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.OfflineSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.IntSequenceOutputs;
import org.apache.lucene.util.fst.Util;

public class Dictionary {
    static final char[] NOFLAGS = new char[0];
    private static final String ALIAS_KEY = "AF";
    private static final String MORPH_ALIAS_KEY = "AM";
    private static final String PREFIX_KEY = "PFX";
    private static final String SUFFIX_KEY = "SFX";
    private static final String FLAG_KEY = "FLAG";
    private static final String COMPLEXPREFIXES_KEY = "COMPLEXPREFIXES";
    private static final String CIRCUMFIX_KEY = "CIRCUMFIX";
    private static final String IGNORE_KEY = "IGNORE";
    private static final String ICONV_KEY = "ICONV";
    private static final String OCONV_KEY = "OCONV";
    private static final String FULLSTRIP_KEY = "FULLSTRIP";
    private static final String LANG_KEY = "LANG";
    private static final String KEEPCASE_KEY = "KEEPCASE";
    private static final String NEEDAFFIX_KEY = "NEEDAFFIX";
    private static final String PSEUDOROOT_KEY = "PSEUDOROOT";
    private static final String ONLYINCOMPOUND_KEY = "ONLYINCOMPOUND";
    private static final String NUM_FLAG_TYPE = "num";
    private static final String UTF8_FLAG_TYPE = "UTF-8";
    private static final String LONG_FLAG_TYPE = "long";
    private static final String PREFIX_CONDITION_REGEX_PATTERN = "%s.*";
    private static final String SUFFIX_CONDITION_REGEX_PATTERN = ".*%s";
    FST<IntsRef> prefixes;
    FST<IntsRef> suffixes;
    ArrayList<CharacterRunAutomaton> patterns = new ArrayList();
    FST<IntsRef> words;
    BytesRefHash flagLookup = new BytesRefHash();
    char[] stripData;
    int[] stripOffsets;
    byte[] affixData = new byte[64];
    private int currentAffix = 0;
    private FlagParsingStrategy flagParsingStrategy = new SimpleFlagParsingStrategy();
    private String[] aliases;
    private int aliasCount = 0;
    private String[] morphAliases;
    private int morphAliasCount = 0;
    private String[] stemExceptions = new String[8];
    private int stemExceptionCount = 0;
    boolean hasStemExceptions;
    private final Path tempPath = Dictionary.getDefaultTempDir();
    boolean ignoreCase;
    boolean complexPrefixes;
    boolean twoStageAffix;
    int circumfix = -1;
    int keepcase = -1;
    int needaffix = -1;
    int onlyincompound = -1;
    private char[] ignore;
    FST<CharsRef> iconv;
    FST<CharsRef> oconv;
    boolean needsInputCleaning;
    boolean needsOutputCleaning;
    boolean fullStrip;
    String language;
    boolean alternateCasing;
    static final Pattern ENCODING_PATTERN = Pattern.compile("^(\u00ef\u00bb\u00bf)?SET\\s+");
    static final Map<String, String> CHARSET_ALIASES;
    final char FLAG_SEPARATOR = (char)31;
    final char MORPH_SEPARATOR = (char)30;
    private static Path DEFAULT_TEMP_DIR;

    public Dictionary(Directory tempDir, String tempFileNamePrefix, InputStream affix, InputStream dictionary) throws IOException, ParseException {
        this(tempDir, tempFileNamePrefix, affix, Collections.singletonList(dictionary), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary(Directory tempDir, String tempFileNamePrefix, InputStream affix, List<InputStream> dictionaries, boolean ignoreCase) throws IOException, ParseException {
        this.ignoreCase = ignoreCase;
        this.needsInputCleaning = ignoreCase;
        this.needsOutputCleaning = false;
        this.flagLookup.add(new BytesRef());
        Path aff = Files.createTempFile(this.tempPath, "affix", "aff", new FileAttribute[0]);
        BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(aff, new OpenOption[0]));
        BufferedInputStream aff1 = null;
        BufferedInputStream aff2 = null;
        boolean success = false;
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = affix.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
            aff1 = new BufferedInputStream(Files.newInputStream(aff, new OpenOption[0]));
            String encoding = Dictionary.getDictionaryEncoding(aff1);
            CharsetDecoder decoder = this.getJavaEncoding(encoding);
            aff2 = new BufferedInputStream(Files.newInputStream(aff, new OpenOption[0]));
            this.readAffixFile(aff2, decoder);
            IntSequenceOutputs o2 = IntSequenceOutputs.getSingleton();
            Builder<IntsRef> b2 = new Builder<IntsRef>(FST.INPUT_TYPE.BYTE4, o2);
            this.readDictionaryFiles(tempDir, tempFileNamePrefix, dictionaries, decoder, b2);
            this.words = b2.finish();
            this.aliases = null;
            this.morphAliases = null;
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(out, aff1, aff2);
            if (success) {
                Files.delete(aff);
            } else {
                IOUtils.deleteFilesIgnoringExceptions(aff);
            }
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(out, aff1, aff2);
        if (success) {
            Files.delete(aff);
        } else {
            IOUtils.deleteFilesIgnoringExceptions(aff);
        }
    }

    IntsRef lookupWord(char[] word, int offset, int length) {
        return this.lookup(this.words, word, offset, length);
    }

    IntsRef lookupPrefix(char[] word, int offset, int length) {
        return this.lookup(this.prefixes, word, offset, length);
    }

    IntsRef lookupSuffix(char[] word, int offset, int length) {
        return this.lookup(this.suffixes, word, offset, length);
    }

    IntsRef lookup(FST<IntsRef> fst, char[] word, int offset, int length) {
        IntsRef NO_OUTPUT;
        if (fst == null) {
            return null;
        }
        FST.BytesReader bytesReader = fst.getBytesReader();
        FST.Arc<IntsRef> arc = fst.getFirstArc(new FST.Arc());
        IntsRef output = NO_OUTPUT = (IntsRef)fst.outputs.getNoOutput();
        int l2 = offset + length;
        try {
            int cp = 0;
            for (int i2 = offset; i2 < l2; i2 += Character.charCount(cp)) {
                cp = Character.codePointAt(word, i2, l2);
                if (fst.findTargetArc(cp, arc, arc, bytesReader) == null) {
                    return null;
                }
                if (arc.output == NO_OUTPUT) continue;
                output = fst.outputs.add(output, (IntsRef)arc.output);
            }
            if (fst.findTargetArc(-1, arc, arc, bytesReader) == null) {
                return null;
            }
            if (arc.output != NO_OUTPUT) {
                return fst.outputs.add(output, (IntsRef)arc.output);
            }
            return output;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    private void readAffixFile(InputStream affixStream, CharsetDecoder decoder) throws IOException, ParseException {
        TreeMap<String, List<Integer>> prefixes = new TreeMap<String, List<Integer>>();
        TreeMap<String, List<Integer>> suffixes = new TreeMap<String, List<Integer>>();
        HashMap<String, Integer> seenPatterns = new HashMap<String, Integer>();
        seenPatterns.put(".*", 0);
        this.patterns.add(null);
        LinkedHashMap<String, Integer> seenStrips = new LinkedHashMap<String, Integer>();
        seenStrips.put("", 0);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(affixStream, decoder));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] parts;
            if (reader.getLineNumber() == 1 && line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (line.startsWith(ALIAS_KEY)) {
                this.parseAlias(line);
                continue;
            }
            if (line.startsWith(MORPH_ALIAS_KEY)) {
                this.parseMorphAlias(line);
                continue;
            }
            if (line.startsWith(PREFIX_KEY)) {
                this.parseAffix(prefixes, line, reader, PREFIX_CONDITION_REGEX_PATTERN, seenPatterns, seenStrips);
                continue;
            }
            if (line.startsWith(SUFFIX_KEY)) {
                this.parseAffix(suffixes, line, reader, SUFFIX_CONDITION_REGEX_PATTERN, seenPatterns, seenStrips);
                continue;
            }
            if (line.startsWith(FLAG_KEY)) {
                this.flagParsingStrategy = Dictionary.getFlagParsingStrategy(line);
                continue;
            }
            if (line.equals(COMPLEXPREFIXES_KEY)) {
                this.complexPrefixes = true;
                continue;
            }
            if (line.startsWith(CIRCUMFIX_KEY)) {
                parts = line.split("\\s+");
                if (parts.length != 2) {
                    throw new ParseException("Illegal CIRCUMFIX declaration", reader.getLineNumber());
                }
                this.circumfix = this.flagParsingStrategy.parseFlag(parts[1]);
                continue;
            }
            if (line.startsWith(KEEPCASE_KEY)) {
                parts = line.split("\\s+");
                if (parts.length != 2) {
                    throw new ParseException("Illegal KEEPCASE declaration", reader.getLineNumber());
                }
                this.keepcase = this.flagParsingStrategy.parseFlag(parts[1]);
                continue;
            }
            if (line.startsWith(NEEDAFFIX_KEY) || line.startsWith(PSEUDOROOT_KEY)) {
                parts = line.split("\\s+");
                if (parts.length != 2) {
                    throw new ParseException("Illegal NEEDAFFIX declaration", reader.getLineNumber());
                }
                this.needaffix = this.flagParsingStrategy.parseFlag(parts[1]);
                continue;
            }
            if (line.startsWith(ONLYINCOMPOUND_KEY)) {
                parts = line.split("\\s+");
                if (parts.length != 2) {
                    throw new ParseException("Illegal ONLYINCOMPOUND declaration", reader.getLineNumber());
                }
                this.onlyincompound = this.flagParsingStrategy.parseFlag(parts[1]);
                continue;
            }
            if (line.startsWith(IGNORE_KEY)) {
                parts = line.split("\\s+");
                if (parts.length != 2) {
                    throw new ParseException("Illegal IGNORE declaration", reader.getLineNumber());
                }
                this.ignore = parts[1].toCharArray();
                Arrays.sort(this.ignore);
                this.needsInputCleaning = true;
                continue;
            }
            if (line.startsWith(ICONV_KEY) || line.startsWith(OCONV_KEY)) {
                parts = line.split("\\s+");
                String type = parts[0];
                if (parts.length != 2) {
                    throw new ParseException("Illegal " + (String)type + " declaration", reader.getLineNumber());
                }
                int num = Integer.parseInt(parts[1]);
                FST<CharsRef> res = this.parseConversions(reader, num);
                if (type.equals(ICONV_KEY)) {
                    this.iconv = res;
                    this.needsInputCleaning |= this.iconv != null;
                    continue;
                }
                this.oconv = res;
                this.needsOutputCleaning |= this.oconv != null;
                continue;
            }
            if (line.startsWith(FULLSTRIP_KEY)) {
                this.fullStrip = true;
                continue;
            }
            if (!line.startsWith(LANG_KEY)) continue;
            this.language = line.substring(LANG_KEY.length()).trim();
            this.alternateCasing = "tr_TR".equals(this.language) || "az_AZ".equals(this.language);
        }
        this.prefixes = this.affixFST(prefixes);
        this.suffixes = this.affixFST(suffixes);
        int totalChars = 0;
        for (String strip : seenStrips.keySet()) {
            totalChars += strip.length();
        }
        this.stripData = new char[totalChars];
        this.stripOffsets = new int[seenStrips.size() + 1];
        int currentOffset = 0;
        int currentIndex = 0;
        for (String strip : seenStrips.keySet()) {
            this.stripOffsets[currentIndex++] = currentOffset;
            strip.getChars(0, strip.length(), this.stripData, currentOffset);
            currentOffset += strip.length();
        }
        assert (currentIndex == seenStrips.size());
        this.stripOffsets[currentIndex] = currentOffset;
    }

    private FST<IntsRef> affixFST(TreeMap<String, List<Integer>> affixes) throws IOException {
        IntSequenceOutputs outputs = IntSequenceOutputs.getSingleton();
        Builder<IntsRef> builder = new Builder<IntsRef>(FST.INPUT_TYPE.BYTE4, outputs);
        IntsRefBuilder scratch = new IntsRefBuilder();
        for (Map.Entry<String, List<Integer>> entry : affixes.entrySet()) {
            Util.toUTF32(entry.getKey(), scratch);
            List<Integer> entries = entry.getValue();
            IntsRef output = new IntsRef(entries.size());
            for (Integer c2 : entries) {
                output.ints[output.length++] = c2;
            }
            builder.add(scratch.get(), output);
        }
        return builder.finish();
    }

    static String escapeDash(String re) {
        StringBuilder escaped = new StringBuilder();
        for (int i2 = 0; i2 < re.length(); ++i2) {
            char c2 = re.charAt(i2);
            if (c2 == '-') {
                escaped.append("\\-");
                continue;
            }
            escaped.append(c2);
            if (c2 != '\\' || i2 + 1 >= re.length()) continue;
            escaped.append(re.charAt(i2 + 1));
            ++i2;
        }
        return escaped.toString();
    }

    private void parseAffix(TreeMap<String, List<Integer>> affixes, String header, LineNumberReader reader, String conditionPattern, Map<String, Integer> seenPatterns, Map<String, Integer> seenStrips) throws IOException, ParseException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        StringBuilder sb = new StringBuilder();
        String[] args = header.split("\\s+");
        boolean crossProduct = args[2].equals("Y");
        boolean isSuffix = conditionPattern == SUFFIX_CONDITION_REGEX_PATTERN;
        int numLines = Integer.parseInt(args[3]);
        this.affixData = ArrayUtil.grow(this.affixData, (this.currentAffix << 3) + (numLines << 3));
        ByteArrayDataOutput affixWriter = new ByteArrayDataOutput(this.affixData, this.currentAffix << 3, numLines << 3);
        for (int i2 = 0; i2 < numLines; ++i2) {
            List<Integer> list;
            Integer stripOrd;
            String regex;
            Integer patternIndex;
            String condition;
            assert (affixWriter.getPosition() == this.currentAffix << 3);
            String line = reader.readLine();
            String[] ruleArgs = line.split("\\s+");
            if (ruleArgs.length < 4) {
                throw new ParseException("The affix file contains a rule with less than four elements: " + line, reader.getLineNumber());
            }
            char flag = this.flagParsingStrategy.parseFlag(ruleArgs[1]);
            String strip = ruleArgs[2].equals("0") ? "" : ruleArgs[2];
            String affixArg = ruleArgs[3];
            char[] appendFlags = null;
            int flagSep = affixArg.lastIndexOf(47);
            if (flagSep != -1) {
                String flagPart = affixArg.substring(flagSep + 1);
                affixArg = affixArg.substring(0, flagSep);
                if (this.aliasCount > 0) {
                    flagPart = this.getAliasValue(Integer.parseInt(flagPart));
                }
                appendFlags = this.flagParsingStrategy.parseFlags(flagPart);
                Arrays.sort(appendFlags);
                this.twoStageAffix = true;
            }
            if ("0".equals(affixArg)) {
                affixArg = "";
            }
            String string = condition = ruleArgs.length > 4 ? ruleArgs[4] : ".";
            if (condition.startsWith("[") && condition.indexOf(93) == -1) {
                condition = condition + "]";
            }
            if (condition.indexOf(45) >= 0) {
                condition = Dictionary.escapeDash(condition);
            }
            if ((patternIndex = seenPatterns.get(regex = ".".equals(condition) ? ".*" : (condition.equals(strip) ? ".*" : String.format(Locale.ROOT, conditionPattern, condition)))) == null) {
                patternIndex = this.patterns.size();
                if (patternIndex > Short.MAX_VALUE) {
                    throw new UnsupportedOperationException("Too many patterns, please report this to dev@lucene.apache.org");
                }
                seenPatterns.put(regex, patternIndex);
                CharacterRunAutomaton pattern = new CharacterRunAutomaton(new RegExp(regex, 0).toAutomaton());
                this.patterns.add(pattern);
            }
            if ((stripOrd = seenStrips.get(strip)) == null) {
                stripOrd = seenStrips.size();
                seenStrips.put(strip, stripOrd);
                if (stripOrd > 65535) {
                    throw new UnsupportedOperationException("Too many unique strips, please report this to dev@lucene.apache.org");
                }
            }
            if (appendFlags == null) {
                appendFlags = NOFLAGS;
            }
            Dictionary.encodeFlags(scratch, appendFlags);
            int appendFlagsOrd = this.flagLookup.add(scratch.get());
            if (appendFlagsOrd < 0) {
                appendFlagsOrd = -appendFlagsOrd - 1;
            } else if (appendFlagsOrd > Short.MAX_VALUE) {
                throw new UnsupportedOperationException("Too many unique append flags, please report this to dev@lucene.apache.org");
            }
            affixWriter.writeShort((short)flag);
            affixWriter.writeShort((short)stripOrd.intValue());
            int patternOrd = patternIndex << 1 | (crossProduct ? 1 : 0);
            affixWriter.writeShort((short)patternOrd);
            affixWriter.writeShort((short)appendFlagsOrd);
            if (this.needsInputCleaning) {
                CharSequence cleaned = this.cleanInput(affixArg, sb);
                affixArg = cleaned.toString();
            }
            if (isSuffix) {
                affixArg = new StringBuilder(affixArg).reverse().toString();
            }
            if ((list = affixes.get(affixArg)) == null) {
                list = new ArrayList<Integer>();
                affixes.put(affixArg, list);
            }
            list.add(this.currentAffix);
            ++this.currentAffix;
        }
    }

    private FST<CharsRef> parseConversions(LineNumberReader reader, int num) throws IOException, ParseException {
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        for (int i2 = 0; i2 < num; ++i2) {
            String line = reader.readLine();
            String[] parts = line.split("\\s+");
            if (parts.length != 3) {
                throw new ParseException("invalid syntax: " + line, reader.getLineNumber());
            }
            if (mappings.put(parts[1], parts[2]) == null) continue;
            throw new IllegalStateException("duplicate mapping specified for: " + parts[1]);
        }
        CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
        Builder<CharsRef> builder = new Builder<CharsRef>(FST.INPUT_TYPE.BYTE2, outputs);
        IntsRefBuilder scratchInts = new IntsRefBuilder();
        for (Map.Entry entry : mappings.entrySet()) {
            Util.toUTF16((CharSequence)entry.getKey(), scratchInts);
            builder.add(scratchInts.get(), new CharsRef((String)entry.getValue()));
        }
        return builder.finish();
    }

    static String getDictionaryEncoding(InputStream affix) throws IOException, ParseException {
        Matcher matcher;
        StringBuilder encoding = new StringBuilder();
        while (true) {
            int ch;
            encoding.setLength(0);
            while ((ch = affix.read()) >= 0 && ch != 10) {
                if (ch == 13) continue;
                encoding.append((char)ch);
            }
            if (encoding.length() == 0 || encoding.charAt(0) == '#' || encoding.toString().trim().length() == 0) {
                if (ch >= 0) continue;
                throw new ParseException("Unexpected end of affix file.", 0);
            }
            matcher = ENCODING_PATTERN.matcher(encoding);
            if (matcher.find()) break;
        }
        int last = matcher.end();
        return encoding.substring(last).trim();
    }

    private CharsetDecoder getJavaEncoding(String encoding) {
        if ("ISO8859-14".equals(encoding)) {
            return new ISO8859_14Decoder();
        }
        String canon = CHARSET_ALIASES.get(encoding);
        if (canon != null) {
            encoding = canon;
        }
        Charset charset = Charset.forName(encoding);
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE);
    }

    static FlagParsingStrategy getFlagParsingStrategy(String flagLine) {
        String[] parts = flagLine.split("\\s+");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Illegal FLAG specification: " + flagLine);
        }
        String flagType = parts[1];
        if (NUM_FLAG_TYPE.equals(flagType)) {
            return new NumFlagParsingStrategy();
        }
        if (UTF8_FLAG_TYPE.equals(flagType)) {
            return new SimpleFlagParsingStrategy();
        }
        if (LONG_FLAG_TYPE.equals(flagType)) {
            return new DoubleASCIIFlagParsingStrategy();
        }
        throw new IllegalArgumentException("Unknown flag type: " + flagType);
    }

    String unescapeEntry(String entry) {
        int i2;
        StringBuilder sb = new StringBuilder();
        int end = Dictionary.morphBoundary(entry);
        for (i2 = 0; i2 < end; ++i2) {
            char ch = entry.charAt(i2);
            if (ch == '\\' && i2 + 1 < entry.length()) {
                sb.append(entry.charAt(i2 + 1));
                ++i2;
                continue;
            }
            if (ch == '/') {
                sb.append('\u001f');
                continue;
            }
            if (ch == '\u001e' || ch == '\u001f') continue;
            sb.append(ch);
        }
        sb.append('\u001e');
        if (end < entry.length()) {
            for (i2 = end; i2 < entry.length(); ++i2) {
                char c2 = entry.charAt(i2);
                if (c2 == '\u001f' || c2 == '\u001e') continue;
                sb.append(c2);
            }
        }
        return sb.toString();
    }

    static int morphBoundary(String line) {
        int end = Dictionary.indexOfSpaceOrTab(line, 0);
        if (end == -1) {
            return line.length();
        }
        while (!(end < 0 || end >= line.length() || line.charAt(end) == '\t' || end + 3 < line.length() && Character.isLetter(line.charAt(end + 1)) && Character.isLetter(line.charAt(end + 2)) && line.charAt(end + 3) == ':')) {
            end = Dictionary.indexOfSpaceOrTab(line, end + 1);
        }
        if (end == -1) {
            return line.length();
        }
        return end;
    }

    static int indexOfSpaceOrTab(String text, int start) {
        int pos1 = text.indexOf(9, start);
        int pos2 = text.indexOf(32, start);
        if (pos1 >= 0 && pos2 >= 0) {
            return Math.min(pos1, pos2);
        }
        return Math.max(pos1, pos2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDictionaryFiles(Directory tempDir, String tempFileNamePrefix, List<InputStream> dictionaries, CharsetDecoder decoder, Builder<IntsRef> words) throws IOException {
        block55: {
            String sorted;
            block53: {
                IntsRefBuilder scratchInts;
                BytesRefBuilder flagsScratch;
                block54: {
                    IndexOutput unsorted;
                    block51: {
                        flagsScratch = new BytesRefBuilder();
                        scratchInts = new IntsRefBuilder();
                        StringBuilder sb = new StringBuilder();
                        unsorted = tempDir.createTempOutput(tempFileNamePrefix, "dat", IOContext.DEFAULT);
                        try (OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(unsorted);){
                            for (InputStream dictionary : dictionaries) {
                                BufferedReader lines = new BufferedReader(new InputStreamReader(dictionary, decoder));
                                String line = lines.readLine();
                                while ((line = lines.readLine()) != null) {
                                    int morphStart;
                                    if (line.isEmpty() || line.charAt(0) == '/' || line.charAt(0) == '#' || line.charAt(0) == '\t') continue;
                                    line = this.unescapeEntry(line);
                                    if (!this.hasStemExceptions && (morphStart = line.indexOf(30)) >= 0 && morphStart < line.length()) {
                                        boolean bl = this.hasStemExceptions = this.parseStemException(line.substring(morphStart + 1)) != null;
                                    }
                                    if (this.needsInputCleaning) {
                                        int flagSep = line.indexOf(31);
                                        if (flagSep == -1) {
                                            flagSep = line.indexOf(30);
                                        }
                                        if (flagSep == -1) {
                                            CharSequence cleansed = this.cleanInput(line, sb);
                                            writer.write(cleansed.toString().getBytes(StandardCharsets.UTF_8));
                                            continue;
                                        }
                                        String text = line.substring(0, flagSep);
                                        CharSequence cleansed = this.cleanInput(text, sb);
                                        if (cleansed != sb) {
                                            sb.setLength(0);
                                            sb.append(cleansed);
                                        }
                                        sb.append(line.substring(flagSep));
                                        writer.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                                        continue;
                                    }
                                    writer.write(line.getBytes(StandardCharsets.UTF_8));
                                }
                            }
                            CodecUtil.writeFooter(unsorted);
                        }
                        OfflineSorter sorter = new OfflineSorter(tempDir, tempFileNamePrefix, new Comparator<BytesRef>(){
                            BytesRef scratch1 = new BytesRef();
                            BytesRef scratch2 = new BytesRef();

                            @Override
                            public int compare(BytesRef o1, BytesRef o2) {
                                int cmp;
                                int i2;
                                this.scratch1.bytes = o1.bytes;
                                this.scratch1.offset = o1.offset;
                                this.scratch1.length = o1.length;
                                for (i2 = this.scratch1.length - 1; i2 >= 0; --i2) {
                                    if (this.scratch1.bytes[this.scratch1.offset + i2] != 31 && this.scratch1.bytes[this.scratch1.offset + i2] != 30) continue;
                                    this.scratch1.length = i2;
                                    break;
                                }
                                this.scratch2.bytes = o2.bytes;
                                this.scratch2.offset = o2.offset;
                                this.scratch2.length = o2.length;
                                for (i2 = this.scratch2.length - 1; i2 >= 0; --i2) {
                                    if (this.scratch2.bytes[this.scratch2.offset + i2] != 31 && this.scratch2.bytes[this.scratch2.offset + i2] != 30) continue;
                                    this.scratch2.length = i2;
                                    break;
                                }
                                if ((cmp = this.scratch1.compareTo(this.scratch2)) == 0) {
                                    return o1.compareTo(o2);
                                }
                                return cmp;
                            }
                        });
                        boolean success = false;
                        try {
                            sorted = sorter.sort(unsorted.getName());
                            success = true;
                            if (!success) break block51;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                tempDir.deleteFile(unsorted.getName());
                            } else {
                                IOUtils.deleteFilesIgnoringExceptions(tempDir, unsorted.getName());
                            }
                            throw throwable;
                        }
                        tempDir.deleteFile(unsorted.getName());
                        break block54;
                    }
                    IOUtils.deleteFilesIgnoringExceptions(tempDir, unsorted.getName());
                }
                boolean success2 = false;
                try {
                    try (OfflineSorter.ByteSequencesReader reader = new OfflineSorter.ByteSequencesReader(tempDir.openChecksumInput(sorted, IOContext.READONCE), sorted);){
                        BytesRef scratch;
                        String currentEntry = null;
                        IntsRefBuilder currentOrds = new IntsRefBuilder();
                        while ((scratch = reader.next()) != null) {
                            int cmp;
                            String stemException;
                            String entry;
                            int end;
                            char[] wordForm;
                            String line = scratch.utf8ToString();
                            int flagSep = line.indexOf(31);
                            if (flagSep == -1) {
                                wordForm = NOFLAGS;
                                end = line.indexOf(30);
                                entry = line.substring(0, end);
                            } else {
                                end = line.indexOf(30);
                                String flagPart = line.substring(flagSep + 1, end);
                                if (this.aliasCount > 0) {
                                    flagPart = this.getAliasValue(Integer.parseInt(flagPart));
                                }
                                wordForm = this.flagParsingStrategy.parseFlags(flagPart);
                                Arrays.sort(wordForm);
                                entry = line.substring(0, flagSep);
                            }
                            int stemExceptionID = 0;
                            if (this.hasStemExceptions && end + 1 < line.length() && (stemException = this.parseStemException(line.substring(end + 1))) != null) {
                                if (this.stemExceptionCount == this.stemExceptions.length) {
                                    int newSize = ArrayUtil.oversize(this.stemExceptionCount + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                                    this.stemExceptions = Arrays.copyOf(this.stemExceptions, newSize);
                                }
                                stemExceptionID = this.stemExceptionCount + 1;
                                this.stemExceptions[this.stemExceptionCount++] = stemException;
                            }
                            int n2 = cmp = currentEntry == null ? 1 : entry.compareTo(currentEntry);
                            if (cmp < 0) {
                                throw new IllegalArgumentException("out of order: " + entry + " < " + currentEntry);
                            }
                            Dictionary.encodeFlags(flagsScratch, wordForm);
                            int ord = this.flagLookup.add(flagsScratch.get());
                            if (ord < 0) {
                                ord = -ord - 1;
                            }
                            if (cmp > 0 && currentEntry != null) {
                                Util.toUTF32(currentEntry, scratchInts);
                                words.add(scratchInts.get(), currentOrds.get());
                            }
                            if (cmp > 0 || currentEntry == null) {
                                currentEntry = entry;
                                currentOrds = new IntsRefBuilder();
                            }
                            if (this.hasStemExceptions) {
                                currentOrds.append(ord);
                                currentOrds.append(stemExceptionID);
                                continue;
                            }
                            currentOrds.append(ord);
                        }
                        Util.toUTF32(currentEntry, scratchInts);
                        words.add(scratchInts.get(), currentOrds.get());
                        success2 = true;
                    }
                    if (!success2) break block53;
                }
                catch (Throwable throwable) {
                    if (success2) {
                        tempDir.deleteFile(sorted);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(tempDir, sorted);
                    }
                    throw throwable;
                }
                tempDir.deleteFile(sorted);
                break block55;
            }
            IOUtils.deleteFilesIgnoringExceptions(tempDir, sorted);
        }
    }

    static char[] decodeFlags(BytesRef b2) {
        if (b2.length == 0) {
            return CharsRef.EMPTY_CHARS;
        }
        int len = b2.length >>> 1;
        char[] flags = new char[len];
        int upto = 0;
        int end = b2.offset + b2.length;
        for (int i2 = b2.offset; i2 < end; i2 += 2) {
            flags[upto++] = (char)(b2.bytes[i2] << 8 | b2.bytes[i2 + 1] & 0xFF);
        }
        return flags;
    }

    static void encodeFlags(BytesRefBuilder b2, char[] flags) {
        int len = flags.length << 1;
        b2.grow(len);
        b2.clear();
        for (int i2 = 0; i2 < flags.length; ++i2) {
            char flag = flags[i2];
            b2.append((byte)(flag >> 8 & 0xFF));
            b2.append((byte)(flag & 0xFF));
        }
    }

    private void parseAlias(String line) {
        String[] ruleArgs = line.split("\\s+");
        if (this.aliases == null) {
            int count = Integer.parseInt(ruleArgs[1]);
            this.aliases = new String[count];
        } else {
            String aliasValue = ruleArgs.length == 1 ? "" : ruleArgs[1];
            this.aliases[this.aliasCount++] = aliasValue;
        }
    }

    private String getAliasValue(int id) {
        try {
            return this.aliases[id - 1];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Bad flag alias number:" + id, ex);
        }
    }

    String getStemException(int id) {
        return this.stemExceptions[id - 1];
    }

    private void parseMorphAlias(String line) {
        if (this.morphAliases == null) {
            int count = Integer.parseInt(line.substring(3));
            this.morphAliases = new String[count];
        } else {
            String arg = line.substring(2);
            this.morphAliases[this.morphAliasCount++] = arg;
        }
    }

    private String parseStemException(String morphData) {
        int index;
        if (this.morphAliasCount > 0) {
            try {
                int alias = Integer.parseInt(morphData.trim());
                morphData = this.morphAliases[alias - 1];
            }
            catch (NumberFormatException alias) {
                // empty catch block
            }
        }
        if ((index = morphData.indexOf(" st:")) < 0) {
            index = morphData.indexOf("\tst:");
        }
        if (index >= 0) {
            int endIndex = Dictionary.indexOfSpaceOrTab(morphData, index + 1);
            if (endIndex < 0) {
                endIndex = morphData.length();
            }
            return morphData.substring(index + 4, endIndex);
        }
        return null;
    }

    static boolean hasFlag(char[] flags, char flag) {
        return Arrays.binarySearch(flags, flag) >= 0;
    }

    CharSequence cleanInput(CharSequence input, StringBuilder reuse) {
        int i2;
        reuse.setLength(0);
        for (i2 = 0; i2 < input.length(); ++i2) {
            char ch = input.charAt(i2);
            if (this.ignore != null && Arrays.binarySearch(this.ignore, ch) >= 0) continue;
            if (this.ignoreCase && this.iconv == null) {
                ch = this.caseFold(ch);
            }
            reuse.append(ch);
        }
        if (this.iconv != null) {
            try {
                Dictionary.applyMappings(this.iconv, reuse);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
            if (this.ignoreCase) {
                for (i2 = 0; i2 < reuse.length(); ++i2) {
                    reuse.setCharAt(i2, this.caseFold(reuse.charAt(i2)));
                }
            }
        }
        return reuse;
    }

    char caseFold(char c2) {
        if (this.alternateCasing) {
            if (c2 == 'I') {
                return '\u0131';
            }
            if (c2 == '\u0130') {
                return 'i';
            }
            return Character.toLowerCase(c2);
        }
        return Character.toLowerCase(c2);
    }

    static void applyMappings(FST<CharsRef> fst, StringBuilder sb) throws IOException {
        FST.BytesReader bytesReader = fst.getBytesReader();
        FST.Arc<CharsRef> firstArc = fst.getFirstArc(new FST.Arc());
        CharsRef NO_OUTPUT = (CharsRef)fst.outputs.getNoOutput();
        FST.Arc<CharsRef> arc = new FST.Arc<CharsRef>();
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            char ch;
            arc.copyFrom(firstArc);
            CharsRef output = NO_OUTPUT;
            int longestMatch = -1;
            CharsRef longestOutput = null;
            for (int j2 = i2; j2 < sb.length() && fst.findTargetArc(ch = sb.charAt(j2), arc, arc, bytesReader) != null; ++j2) {
                output = fst.outputs.add(output, (CharsRef)arc.output);
                if (!arc.isFinal()) continue;
                longestOutput = fst.outputs.add(output, (CharsRef)arc.nextFinalOutput);
                longestMatch = j2;
            }
            if (longestMatch < 0) continue;
            sb.delete(i2, longestMatch + 1);
            sb.insert(i2, longestOutput);
            i2 += longestOutput.length - 1;
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public static void setDefaultTempDir(Path tempDir) {
        DEFAULT_TEMP_DIR = tempDir;
    }

    static synchronized Path getDefaultTempDir() throws IOException {
        if (DEFAULT_TEMP_DIR == null) {
            String tempDirPath = System.getProperty("java.io.tmpdir");
            if (tempDirPath == null) {
                throw new IOException("Java has no temporary folder property (java.io.tmpdir)?");
            }
            Path tempDirectory = Paths.get(tempDirPath, new String[0]);
            if (!Files.isWritable(tempDirectory)) {
                throw new IOException("Java's temporary folder not present or writeable?: " + tempDirectory.toAbsolutePath());
            }
            DEFAULT_TEMP_DIR = tempDirectory;
        }
        return DEFAULT_TEMP_DIR;
    }

    static {
        HashMap<String, String> m3 = new HashMap<String, String>();
        m3.put("microsoft-cp1251", "windows-1251");
        m3.put("TIS620-2533", "TIS-620");
        CHARSET_ALIASES = Collections.unmodifiableMap(m3);
    }

    private static class DoubleASCIIFlagParsingStrategy
    extends FlagParsingStrategy {
        private DoubleASCIIFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            if (rawFlags.length() == 0) {
                return new char[0];
            }
            StringBuilder builder = new StringBuilder();
            if (rawFlags.length() % 2 == 1) {
                throw new IllegalArgumentException("Invalid flags (should be even number of characters): " + rawFlags);
            }
            for (int i2 = 0; i2 < rawFlags.length(); i2 += 2) {
                char f1 = rawFlags.charAt(i2);
                char f2 = rawFlags.charAt(i2 + 1);
                if (f1 >= '\u0100' || f2 >= '\u0100') {
                    throw new IllegalArgumentException("Invalid flags (LONG flags must be double ASCII): " + rawFlags);
                }
                char combined = (char)(f1 << 8 | f2);
                builder.append(combined);
            }
            char[] flags = new char[builder.length()];
            builder.getChars(0, builder.length(), flags, 0);
            return flags;
        }
    }

    private static class NumFlagParsingStrategy
    extends FlagParsingStrategy {
        private NumFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            String[] rawFlagParts = rawFlags.trim().split(",");
            char[] flags = new char[rawFlagParts.length];
            int upto = 0;
            for (int i2 = 0; i2 < rawFlagParts.length; ++i2) {
                String replacement = rawFlagParts[i2].replaceAll("[^0-9]", "");
                if (replacement.isEmpty()) continue;
                flags[upto++] = (char)Integer.parseInt(replacement);
            }
            if (upto < flags.length) {
                flags = Arrays.copyOf(flags, upto);
            }
            return flags;
        }
    }

    private static class SimpleFlagParsingStrategy
    extends FlagParsingStrategy {
        private SimpleFlagParsingStrategy() {
        }

        @Override
        public char[] parseFlags(String rawFlags) {
            return rawFlags.toCharArray();
        }
    }

    static abstract class FlagParsingStrategy {
        FlagParsingStrategy() {
        }

        char parseFlag(String rawFlag) {
            char[] flags = this.parseFlags(rawFlag);
            if (flags.length != 1) {
                throw new IllegalArgumentException("expected only one flag, got: " + rawFlag);
            }
            return flags[0];
        }

        abstract char[] parseFlags(String var1);
    }
}

