/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;

final class Stemmer {
    private final Dictionary dictionary;
    private final BytesRef scratch = new BytesRef();
    private final StringBuilder segment = new StringBuilder();
    private final ByteArrayDataInput affixReader;
    private final StringBuilder scratchSegment = new StringBuilder();
    private char[] scratchBuffer = new char[32];
    private final int formStep;
    private char[] lowerBuffer = new char[8];
    private char[] titleBuffer = new char[8];
    private static final int EXACT_CASE = 0;
    private static final int TITLE_CASE = 1;
    private static final int UPPER_CASE = 2;
    final FST.BytesReader[] prefixReaders = new FST.BytesReader[3];
    final FST.Arc<IntsRef>[] prefixArcs = new FST.Arc[3];
    final FST.BytesReader[] suffixReaders = new FST.BytesReader[3];
    final FST.Arc<IntsRef>[] suffixArcs = new FST.Arc[3];

    public Stemmer(Dictionary dictionary) {
        this.dictionary = dictionary;
        this.affixReader = new ByteArrayDataInput(dictionary.affixData);
        for (int level = 0; level < 3; ++level) {
            if (dictionary.prefixes != null) {
                this.prefixArcs[level] = new FST.Arc();
                this.prefixReaders[level] = dictionary.prefixes.getBytesReader();
            }
            if (dictionary.suffixes == null) continue;
            this.suffixArcs[level] = new FST.Arc();
            this.suffixReaders[level] = dictionary.suffixes.getBytesReader();
        }
        this.formStep = dictionary.hasStemExceptions ? 2 : 1;
    }

    public List<CharsRef> stem(String word) {
        return this.stem(word.toCharArray(), word.length());
    }

    public List<CharsRef> stem(char[] word, int length) {
        int caseType;
        if (this.dictionary.needsInputCleaning) {
            this.scratchSegment.setLength(0);
            this.scratchSegment.append(word, 0, length);
            CharSequence cleaned = this.dictionary.cleanInput(this.scratchSegment, this.segment);
            this.scratchBuffer = ArrayUtil.grow(this.scratchBuffer, cleaned.length());
            length = this.segment.length();
            this.segment.getChars(0, length, this.scratchBuffer, 0);
            word = this.scratchBuffer;
        }
        if ((caseType = this.caseOf(word, length)) == 2) {
            this.caseFoldTitle(word, length);
            this.caseFoldLower(this.titleBuffer, length);
            List<CharsRef> list = this.doStem(word, length, false);
            list.addAll(this.doStem(this.titleBuffer, length, true));
            list.addAll(this.doStem(this.lowerBuffer, length, true));
            return list;
        }
        if (caseType == 1) {
            this.caseFoldLower(word, length);
            List<CharsRef> list = this.doStem(word, length, false);
            list.addAll(this.doStem(this.lowerBuffer, length, true));
            return list;
        }
        return this.doStem(word, length, false);
    }

    private int caseOf(char[] word, int length) {
        if (this.dictionary.ignoreCase || length == 0 || !Character.isUpperCase(word[0])) {
            return 0;
        }
        boolean seenUpper = false;
        boolean seenLower = false;
        for (int i2 = 1; i2 < length; ++i2) {
            boolean v2 = Character.isUpperCase(word[i2]);
            seenUpper |= v2;
            seenLower |= !v2;
        }
        if (!seenLower) {
            return 2;
        }
        if (!seenUpper) {
            return 1;
        }
        return 0;
    }

    private void caseFoldTitle(char[] word, int length) {
        this.titleBuffer = ArrayUtil.grow(this.titleBuffer, length);
        System.arraycopy(word, 0, this.titleBuffer, 0, length);
        for (int i2 = 1; i2 < length; ++i2) {
            this.titleBuffer[i2] = this.dictionary.caseFold(this.titleBuffer[i2]);
        }
    }

    private void caseFoldLower(char[] word, int length) {
        this.lowerBuffer = ArrayUtil.grow(this.lowerBuffer, length);
        System.arraycopy(word, 0, this.lowerBuffer, 0, length);
        this.lowerBuffer[0] = this.dictionary.caseFold(this.lowerBuffer[0]);
    }

    private List<CharsRef> doStem(char[] word, int length, boolean caseVariant) {
        int i2;
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        IntsRef forms = this.dictionary.lookupWord(word, 0, length);
        if (forms != null) {
            for (i2 = 0; i2 < forms.length; i2 += this.formStep) {
                boolean checkOnlyInCompound;
                boolean checkKeepCase = caseVariant && this.dictionary.keepcase != -1;
                boolean checkNeedAffix = this.dictionary.needaffix != -1;
                boolean bl = checkOnlyInCompound = this.dictionary.onlyincompound != -1;
                if (checkKeepCase || checkNeedAffix || checkOnlyInCompound) {
                    this.dictionary.flagLookup.get(forms.ints[forms.offset + i2], this.scratch);
                    char[] wordFlags = Dictionary.decodeFlags(this.scratch);
                    if (checkKeepCase && Dictionary.hasFlag(wordFlags, (char)this.dictionary.keepcase) || checkNeedAffix && Dictionary.hasFlag(wordFlags, (char)this.dictionary.needaffix) || checkOnlyInCompound && Dictionary.hasFlag(wordFlags, (char)this.dictionary.onlyincompound)) continue;
                }
                stems.add(this.newStem(word, length, forms, i2));
            }
        }
        try {
            i2 = stems.addAll(this.stem(word, length, -1, -1, -1, 0, true, true, false, false, caseVariant)) ? 1 : 0;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        return stems;
    }

    public List<CharsRef> uniqueStems(char[] word, int length) {
        List<CharsRef> stems = this.stem(word, length);
        if (stems.size() < 2) {
            return stems;
        }
        CharArraySet terms = new CharArraySet(8, this.dictionary.ignoreCase);
        ArrayList<CharsRef> deduped = new ArrayList<CharsRef>();
        for (CharsRef s2 : stems) {
            if (terms.contains(s2)) continue;
            deduped.add(s2);
            terms.add(s2);
        }
        return deduped;
    }

    private CharsRef newStem(char[] buffer, int length, IntsRef forms, int formID) {
        int exceptionID;
        String exception = this.dictionary.hasStemExceptions ? ((exceptionID = forms.ints[forms.offset + formID + 1]) > 0 ? this.dictionary.getStemException(exceptionID) : null) : null;
        if (this.dictionary.needsOutputCleaning) {
            this.scratchSegment.setLength(0);
            if (exception != null) {
                this.scratchSegment.append(exception);
            } else {
                this.scratchSegment.append(buffer, 0, length);
            }
            try {
                Dictionary.applyMappings(this.dictionary.oconv, this.scratchSegment);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
            char[] cleaned = new char[this.scratchSegment.length()];
            this.scratchSegment.getChars(0, cleaned.length, cleaned, 0);
            return new CharsRef(cleaned, 0, cleaned.length);
        }
        if (exception != null) {
            return new CharsRef(exception);
        }
        return new CharsRef(buffer, 0, length);
    }

    private List<CharsRef> stem(char[] word, int length, int previous, int prevFlag, int prefixFlag, int recursionDepth, boolean doPrefix, boolean doSuffix, boolean previousWasPrefix, boolean circumfix, boolean caseVariant) throws IOException {
        List<CharsRef> stemList;
        char[] strippedWord;
        int deAffixedLength;
        int stripEnd;
        int stripLength;
        int stripStart;
        boolean allowed;
        boolean compatible;
        char append;
        boolean crossProduct;
        int condition;
        char stripOrd;
        char flag;
        int j2;
        char ch;
        int i2;
        int limit;
        IntsRef output;
        IntsRef NO_OUTPUT;
        FST.Arc<IntsRef> arc;
        FST.BytesReader bytesReader;
        Outputs outputs;
        FST<IntsRef> fst;
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        if (doPrefix && this.dictionary.prefixes != null) {
            fst = this.dictionary.prefixes;
            outputs = fst.outputs;
            bytesReader = this.prefixReaders[recursionDepth];
            arc = this.prefixArcs[recursionDepth];
            fst.getFirstArc(arc);
            output = NO_OUTPUT = (IntsRef)outputs.getNoOutput();
            limit = this.dictionary.fullStrip ? length : length - 1;
            for (i2 = 0; i2 < limit; ++i2) {
                if (i2 > 0) {
                    ch = word[i2 - 1];
                    if (fst.findTargetArc(ch, arc, arc, bytesReader) == null) break;
                    if (arc.output != NO_OUTPUT) {
                        output = fst.outputs.add(output, (IntsRef)arc.output);
                    }
                }
                IntsRef prefixes = null;
                if (!arc.isFinal()) continue;
                prefixes = fst.outputs.add(output, (IntsRef)arc.nextFinalOutput);
                for (j2 = 0; j2 < prefixes.length; ++j2) {
                    int deAffixedStart;
                    int prefix = prefixes.ints[prefixes.offset + j2];
                    if (prefix == previous) continue;
                    this.affixReader.setPosition(8 * prefix);
                    flag = (char)(this.affixReader.readShort() & 0xFFFF);
                    stripOrd = (char)(this.affixReader.readShort() & 0xFFFF);
                    condition = this.affixReader.readShort() & 0xFFFF;
                    crossProduct = (condition & '\u0001') == 1;
                    condition >>>= 1;
                    append = (char)(this.affixReader.readShort() & 0xFFFF);
                    if (recursionDepth == 0) {
                        if (this.dictionary.onlyincompound == -1) {
                            compatible = true;
                        } else {
                            this.dictionary.flagLookup.get(append, this.scratch);
                            char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                            compatible = !Dictionary.hasFlag(appendFlags, (char)this.dictionary.onlyincompound);
                        }
                    } else if (crossProduct) {
                        this.dictionary.flagLookup.get(append, this.scratch);
                        char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                        assert (prevFlag >= 0);
                        allowed = this.dictionary.onlyincompound == -1 || !Dictionary.hasFlag(appendFlags, (char)this.dictionary.onlyincompound);
                        compatible = allowed && this.hasCrossCheckedFlag((char)prevFlag, appendFlags, false);
                    } else {
                        compatible = false;
                    }
                    if (!compatible || !this.checkCondition(condition, this.dictionary.stripData, stripStart = this.dictionary.stripOffsets[stripOrd], stripLength = (stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001']) - stripStart, word, deAffixedStart = i2, deAffixedLength = length - deAffixedStart)) continue;
                    strippedWord = new char[stripLength + deAffixedLength];
                    System.arraycopy(this.dictionary.stripData, stripStart, strippedWord, 0, stripLength);
                    System.arraycopy(word, deAffixedStart, strippedWord, stripLength, deAffixedLength);
                    stemList = this.applyAffix(strippedWord, strippedWord.length, prefix, -1, recursionDepth, true, circumfix, caseVariant);
                    stems.addAll(stemList);
                }
            }
        }
        if (doSuffix && this.dictionary.suffixes != null) {
            fst = this.dictionary.suffixes;
            outputs = fst.outputs;
            bytesReader = this.suffixReaders[recursionDepth];
            arc = this.suffixArcs[recursionDepth];
            fst.getFirstArc(arc);
            output = NO_OUTPUT = (IntsRef)outputs.getNoOutput();
            limit = this.dictionary.fullStrip ? 0 : 1;
            for (i2 = length; i2 >= limit; --i2) {
                if (i2 < length) {
                    ch = word[i2];
                    if (fst.findTargetArc(ch, arc, arc, bytesReader) == null) break;
                    if (arc.output != NO_OUTPUT) {
                        output = fst.outputs.add(output, (IntsRef)arc.output);
                    }
                }
                IntsRef suffixes = null;
                if (!arc.isFinal()) continue;
                suffixes = fst.outputs.add(output, (IntsRef)arc.nextFinalOutput);
                for (j2 = 0; j2 < suffixes.length; ++j2) {
                    int appendLength;
                    int suffix = suffixes.ints[suffixes.offset + j2];
                    if (suffix == previous) continue;
                    this.affixReader.setPosition(8 * suffix);
                    flag = (char)(this.affixReader.readShort() & 0xFFFF);
                    stripOrd = (char)(this.affixReader.readShort() & 0xFFFF);
                    condition = (char)(this.affixReader.readShort() & 0xFFFF);
                    crossProduct = (condition & '\u0001') == 1;
                    condition >>>= 1;
                    append = (char)(this.affixReader.readShort() & 0xFFFF);
                    if (recursionDepth == 0) {
                        if (this.dictionary.onlyincompound == -1) {
                            compatible = true;
                        } else {
                            this.dictionary.flagLookup.get(append, this.scratch);
                            char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                            compatible = !Dictionary.hasFlag(appendFlags, (char)this.dictionary.onlyincompound);
                        }
                    } else if (crossProduct) {
                        this.dictionary.flagLookup.get(append, this.scratch);
                        char[] appendFlags = Dictionary.decodeFlags(this.scratch);
                        assert (prevFlag >= 0);
                        allowed = this.dictionary.onlyincompound == -1 || !Dictionary.hasFlag(appendFlags, (char)this.dictionary.onlyincompound);
                        compatible = allowed && this.hasCrossCheckedFlag((char)prevFlag, appendFlags, previousWasPrefix);
                    } else {
                        compatible = false;
                    }
                    if (!compatible || !this.checkCondition(condition, word, 0, deAffixedLength = length - (appendLength = length - i2), this.dictionary.stripData, stripStart = this.dictionary.stripOffsets[stripOrd], stripLength = (stripEnd = this.dictionary.stripOffsets[stripOrd + '\u0001']) - stripStart)) continue;
                    strippedWord = new char[stripLength + deAffixedLength];
                    System.arraycopy(word, 0, strippedWord, 0, deAffixedLength);
                    System.arraycopy(this.dictionary.stripData, stripStart, strippedWord, deAffixedLength, stripLength);
                    stemList = this.applyAffix(strippedWord, strippedWord.length, suffix, prefixFlag, recursionDepth, false, circumfix, caseVariant);
                    stems.addAll(stemList);
                }
            }
        }
        return stems;
    }

    private boolean checkCondition(int condition, char[] c1, int c1off, int c1len, char[] c2, int c2off, int c2len) {
        if (condition != 0) {
            int i2;
            CharacterRunAutomaton pattern = this.dictionary.patterns.get(condition);
            int state = 0;
            for (i2 = c1off; i2 < c1off + c1len; ++i2) {
                if ((state = pattern.step(state, c1[i2])) != -1) continue;
                return false;
            }
            for (i2 = c2off; i2 < c2off + c2len; ++i2) {
                if ((state = pattern.step(state, c2[i2])) != -1) continue;
                return false;
            }
            return pattern.isAccept(state);
        }
        return true;
    }

    List<CharsRef> applyAffix(char[] strippedWord, int length, int affix, int prefixFlag, int recursionDepth, boolean prefix, boolean circumfix, boolean caseVariant) throws IOException {
        this.affixReader.setPosition(8 * affix);
        char flag = (char)(this.affixReader.readShort() & 0xFFFF);
        this.affixReader.skipBytes(2L);
        int condition = this.affixReader.readShort() & 0xFFFF;
        boolean crossProduct = (condition & '\u0001') == 1;
        condition >>>= 1;
        char append = (char)(this.affixReader.readShort() & 0xFFFF);
        ArrayList<CharsRef> stems = new ArrayList<CharsRef>();
        IntsRef forms = this.dictionary.lookupWord(strippedWord, 0, length);
        if (forms != null) {
            for (int i2 = 0; i2 < forms.length; i2 += this.formStep) {
                char[] appendFlags;
                boolean chainedPrefix;
                this.dictionary.flagLookup.get(forms.ints[forms.offset + i2], this.scratch);
                char[] wordFlags = Dictionary.decodeFlags(this.scratch);
                if (!Dictionary.hasFlag(wordFlags, flag)) continue;
                boolean bl = chainedPrefix = this.dictionary.complexPrefixes && recursionDepth == 1 && prefix;
                if (!chainedPrefix && prefixFlag >= 0 && !Dictionary.hasFlag(wordFlags, (char)prefixFlag)) {
                    this.dictionary.flagLookup.get(append, this.scratch);
                    appendFlags = Dictionary.decodeFlags(this.scratch);
                    if (!this.hasCrossCheckedFlag((char)prefixFlag, appendFlags, false)) continue;
                }
                if (this.dictionary.circumfix != -1) {
                    this.dictionary.flagLookup.get(append, this.scratch);
                    appendFlags = Dictionary.decodeFlags(this.scratch);
                    boolean suffixCircumfix = Dictionary.hasFlag(appendFlags, (char)this.dictionary.circumfix);
                    if (circumfix != suffixCircumfix) continue;
                }
                if (caseVariant && this.dictionary.keepcase != -1 && Dictionary.hasFlag(wordFlags, (char)this.dictionary.keepcase) || this.dictionary.onlyincompound != -1 && Dictionary.hasFlag(wordFlags, (char)this.dictionary.onlyincompound)) continue;
                stems.add(this.newStem(strippedWord, length, forms, i2));
            }
        }
        if (this.dictionary.circumfix != -1 && !circumfix && prefix) {
            this.dictionary.flagLookup.get(append, this.scratch);
            char[] appendFlags = Dictionary.decodeFlags(this.scratch);
            circumfix = Dictionary.hasFlag(appendFlags, (char)this.dictionary.circumfix);
        }
        if (crossProduct) {
            if (recursionDepth == 0) {
                if (prefix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, flag, ++recursionDepth, this.dictionary.complexPrefixes && this.dictionary.twoStageAffix, true, true, circumfix, caseVariant));
                } else if (!this.dictionary.complexPrefixes && this.dictionary.twoStageAffix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, prefixFlag, ++recursionDepth, false, true, false, circumfix, caseVariant));
                }
            } else if (recursionDepth == 1) {
                if (prefix && this.dictionary.complexPrefixes) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, flag, ++recursionDepth, false, true, true, circumfix, caseVariant));
                } else if (!prefix && !this.dictionary.complexPrefixes && this.dictionary.twoStageAffix) {
                    stems.addAll(this.stem(strippedWord, length, affix, flag, prefixFlag, ++recursionDepth, false, true, false, circumfix, caseVariant));
                }
            }
        }
        return stems;
    }

    private boolean hasCrossCheckedFlag(char flag, char[] flags, boolean matchEmpty) {
        return flags.length == 0 && matchEmpty || Arrays.binarySearch(flags, flag) >= 0;
    }
}

