/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.payloads.AbstractEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.util.BytesRef;

public class IdentityEncoder
extends AbstractEncoder
implements PayloadEncoder {
    protected Charset charset = StandardCharsets.UTF_8;

    public IdentityEncoder() {
    }

    public IdentityEncoder(Charset charset) {
        this.charset = charset;
    }

    @Override
    public BytesRef encode(char[] buffer, int offset, int length) {
        ByteBuffer bb2 = this.charset.encode(CharBuffer.wrap(buffer, offset, length));
        if (bb2.hasArray()) {
            return new BytesRef(bb2.array(), bb2.arrayOffset() + bb2.position(), bb2.remaining());
        }
        byte[] b2 = new byte[bb2.remaining()];
        bb2.get(b2);
        return new BytesRef(b2);
    }
}

