/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;

public class SolrSynonymParser
extends SynonymMap.Parser {
    private final boolean expand;

    public SolrSynonymParser(boolean dedup, boolean expand, Analyzer analyzer) {
        super(dedup, analyzer);
        this.expand = expand;
    }

    @Override
    public void parse(Reader in) throws IOException, ParseException {
        try (LineNumberReader br = new LineNumberReader(in);){
            this.addInternal(br);
        }
    }

    private void addInternal(BufferedReader in) throws IOException {
        String line = null;
        while ((line = in.readLine()) != null) {
            int i2;
            CharsRef[] inputs;
            String[] inputStrings;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] sides = SolrSynonymParser.split(line, "=>");
            if (sides.length > 1) {
                int i3;
                if (sides.length != 2) {
                    throw new IllegalArgumentException("more than one explicit mapping specified on the same line");
                }
                inputStrings = SolrSynonymParser.split(sides[0], ",");
                inputs = new CharsRef[inputStrings.length];
                for (int i4 = 0; i4 < inputs.length; ++i4) {
                    inputs[i4] = this.analyze(this.unescape(inputStrings[i4]).trim(), new CharsRefBuilder());
                }
                String[] outputStrings = SolrSynonymParser.split(sides[1], ",");
                CharsRef[] outputs = new CharsRef[outputStrings.length];
                for (i3 = 0; i3 < outputs.length; ++i3) {
                    outputs[i3] = this.analyze(this.unescape(outputStrings[i3]).trim(), new CharsRefBuilder());
                }
                for (i3 = 0; i3 < inputs.length; ++i3) {
                    for (int j2 = 0; j2 < outputs.length; ++j2) {
                        this.add(inputs[i3], outputs[j2], false);
                    }
                }
                continue;
            }
            inputStrings = SolrSynonymParser.split(line, ",");
            inputs = new CharsRef[inputStrings.length];
            for (i2 = 0; i2 < inputs.length; ++i2) {
                inputs[i2] = this.analyze(this.unescape(inputStrings[i2]).trim(), new CharsRefBuilder());
            }
            if (this.expand) {
                for (i2 = 0; i2 < inputs.length; ++i2) {
                    for (int j3 = 0; j3 < inputs.length; ++j3) {
                        if (i2 == j3) continue;
                        this.add(inputs[i2], inputs[j3], true);
                    }
                }
                continue;
            }
            for (i2 = 0; i2 < inputs.length; ++i2) {
                this.add(inputs[i2], inputs[0], false);
            }
        }
    }

    private static String[] split(String s2, String separator) {
        ArrayList<String> list = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s2.length();
        while (pos < end) {
            char ch;
            if (s2.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s2.charAt(pos++)) == '\\') {
                sb.append(ch);
                if (pos >= end) break;
                ch = s2.charAt(pos++);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private String unescape(String s2) {
        if (s2.indexOf("\\") >= 0) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char ch = s2.charAt(i2);
                if (ch == '\\' && i2 < s2.length() - 1) {
                    sb.append(s2.charAt(++i2));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return s2;
    }
}

