/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

public class OpenStringBuilder
implements Appendable,
CharSequence {
    protected char[] buf;
    protected int len;

    public OpenStringBuilder() {
        this(32);
    }

    public OpenStringBuilder(int size) {
        this.buf = new char[size];
    }

    public OpenStringBuilder(char[] arr, int len) {
        this.set(arr, len);
    }

    public void setLength(int len) {
        this.len = len;
    }

    public void set(char[] arr, int end) {
        this.buf = arr;
        this.len = end;
    }

    public char[] getArray() {
        return this.buf;
    }

    public int size() {
        return this.len;
    }

    @Override
    public int length() {
        return this.len;
    }

    public int capacity() {
        return this.buf.length;
    }

    @Override
    public Appendable append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        this.reserve(end - start);
        for (int i2 = start; i2 < end; ++i2) {
            this.unsafeWrite(csq.charAt(i2));
        }
        return this;
    }

    @Override
    public Appendable append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.buf[index];
    }

    public void setCharAt(int index, char ch) {
        this.buf[index] = ch;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void unsafeWrite(char b2) {
        this.buf[this.len++] = b2;
    }

    public void unsafeWrite(int b2) {
        this.unsafeWrite((char)b2);
    }

    public void unsafeWrite(char[] b2, int off, int len) {
        System.arraycopy(b2, off, this.buf, this.len, len);
        this.len += len;
    }

    protected void resize(int len) {
        char[] newbuf = new char[Math.max(this.buf.length << 1, len)];
        System.arraycopy(this.buf, 0, newbuf, 0, this.size());
        this.buf = newbuf;
    }

    public void reserve(int num) {
        if (this.len + num > this.buf.length) {
            this.resize(this.len + num);
        }
    }

    public void write(char b2) {
        if (this.len >= this.buf.length) {
            this.resize(this.len + 1);
        }
        this.unsafeWrite(b2);
    }

    public void write(int b2) {
        this.write((char)b2);
    }

    public final void write(char[] b2) {
        this.write(b2, 0, b2.length);
    }

    public void write(char[] b2, int off, int len) {
        this.reserve(len);
        this.unsafeWrite(b2, off, len);
    }

    public final void write(OpenStringBuilder arr) {
        this.write(arr.buf, 0, this.len);
    }

    public void write(String s2) {
        this.reserve(s2.length());
        s2.getChars(0, s2.length(), this.buf, this.len);
        this.len += s2.length();
    }

    public void flush() {
    }

    public final void reset() {
        this.len = 0;
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.size()];
        System.arraycopy(this.buf, 0, newbuf, 0, this.size());
        return newbuf;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.size());
    }
}

