/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BlockPackedReaderIterator;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingTermVectorsReader
extends TermVectorsReader
implements Closeable {
    private final FieldInfos fieldInfos;
    final CompressingStoredFieldsIndexReader indexReader;
    final IndexInput vectorsStream;
    private final int version;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int chunkSize;
    private final int numDocs;
    private boolean closed;
    private final BlockPackedReaderIterator reader;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long maxPointer;

    private CompressingTermVectorsReader(CompressingTermVectorsReader reader) {
        this.fieldInfos = reader.fieldInfos;
        this.vectorsStream = reader.vectorsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.chunkSize = reader.chunkSize;
        this.numDocs = reader.numDocs;
        this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
        this.version = reader.version;
        this.numChunks = reader.numChunks;
        this.numDirtyChunks = reader.numDirtyChunks;
        this.maxPointer = reader.maxPointer;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingTermVectorsReader(Directory d2, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        long maxPointer;
        CompressingStoredFieldsIndexReader indexReader;
        int version;
        boolean success;
        String segment;
        block23: {
            this.compressionMode = compressionMode;
            segment = si.name;
            success = false;
            this.fieldInfos = fn;
            this.numDocs = si.maxDoc();
            version = -1;
            indexReader = null;
            maxPointer = -1L;
            String indexName = IndexFileNames.segmentFileName(segment, segmentSuffix, "tvx");
            try (ChecksumIndexInput input = d2.openChecksumInput(indexName, context);){
                Throwable priorE = null;
                try {
                    String codecNameIdx = formatName + "Index";
                    version = CodecUtil.checkIndexHeader(input, codecNameIdx, 1, 1, si.getId(), segmentSuffix);
                    assert ((long)CodecUtil.indexHeaderLength(codecNameIdx, segmentSuffix) == input.getFilePointer());
                    indexReader = new CompressingStoredFieldsIndexReader(input, si);
                    maxPointer = input.readVLong();
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(input, priorE);
                    }
                }
                CodecUtil.checkFooter(input, priorE);
            }
        }
        this.version = version;
        this.indexReader = indexReader;
        this.maxPointer = maxPointer;
        try {
            String vectorsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "tvd");
            this.vectorsStream = d2.openInput(vectorsStreamFN, context);
            String codecNameDat = formatName + "Data";
            int version2 = CodecUtil.checkIndexHeader(this.vectorsStream, codecNameDat, 1, 1, si.getId(), segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + version + " != " + version2, this.vectorsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength(codecNameDat, segmentSuffix) == this.vectorsStream.getFilePointer());
            long pos = this.vectorsStream.getFilePointer();
            this.vectorsStream.seek(maxPointer);
            this.numChunks = this.vectorsStream.readVLong();
            this.numDirtyChunks = this.vectorsStream.readVLong();
            if (this.numDirtyChunks > this.numChunks) {
                throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.vectorsStream);
            }
            CodecUtil.retrieveChecksum(this.vectorsStream);
            this.vectorsStream.seek(pos);
            this.packedIntsVersion = this.vectorsStream.readVInt();
            this.chunkSize = this.vectorsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    int getVersion() {
        return this.version;
    }

    CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    IndexInput getVectorsStream() {
        return this.vectorsStream;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    long getNumChunks() {
        return this.numChunks;
    }

    long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.vectorsStream);
            this.closed = true;
        }
    }

    @Override
    public TermVectorsReader clone() {
        return new CompressingTermVectorsReader(this);
    }

    @Override
    public Fields get(int doc) throws IOException {
        int i2;
        int k2;
        Object lengths;
        Object startOffsets;
        int j2;
        int k3;
        LongsRef next;
        int j3;
        int termCount;
        int i3;
        PackedInts.Reader flags;
        int i4;
        int numFields;
        int totalFields;
        int skip;
        this.ensureOpen();
        long startPointer = this.indexReader.getStartPointer(doc);
        this.vectorsStream.seek(startPointer);
        int docBase = this.vectorsStream.readVInt();
        int chunkDocs = this.vectorsStream.readVInt();
        if (doc < docBase || doc >= docBase + chunkDocs || docBase + chunkDocs > this.numDocs) {
            throw new CorruptIndexException("docBase=" + docBase + ",chunkDocs=" + chunkDocs + ",doc=" + doc, this.vectorsStream);
        }
        if (chunkDocs == 1) {
            skip = 0;
            numFields = totalFields = this.vectorsStream.readVInt();
        } else {
            int i5;
            this.reader.reset(this.vectorsStream, chunkDocs);
            int sum = 0;
            for (i5 = docBase; i5 < doc; ++i5) {
                sum = (int)((long)sum + this.reader.next());
            }
            skip = sum;
            numFields = (int)this.reader.next();
            sum += numFields;
            for (i5 = doc + 1; i5 < docBase + chunkDocs; ++i5) {
                sum = (int)((long)sum + this.reader.next());
            }
            totalFields = sum;
        }
        if (numFields == 0) {
            return null;
        }
        int token = this.vectorsStream.readByte() & 0xFF;
        assert (token != 0);
        int bitsPerFieldNum = token & 0x1F;
        int totalDistinctFields = token >>> 5;
        if (totalDistinctFields == 7) {
            totalDistinctFields += this.vectorsStream.readVInt();
        }
        PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, ++totalDistinctFields, bitsPerFieldNum, 1);
        int[] fieldNums = new int[totalDistinctFields];
        for (int i6 = 0; i6 < totalDistinctFields; ++i6) {
            fieldNums[i6] = (int)it.next();
        }
        int[] fieldNumOffs = new int[numFields];
        int bitsPerOff = PackedInts.bitsRequired(fieldNums.length - 1);
        PackedInts.Reader allFieldNumOffs = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, bitsPerOff);
        switch (this.vectorsStream.readVInt()) {
            case 0: {
                PackedInts.Reader fieldFlags = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, fieldNums.length, CompressingTermVectorsWriter.FLAGS_BITS);
                PackedInts.Mutable f2 = PackedInts.getMutable(totalFields, CompressingTermVectorsWriter.FLAGS_BITS, 0.0f);
                for (i4 = 0; i4 < totalFields; ++i4) {
                    int fieldNumOff = (int)allFieldNumOffs.get(i4);
                    assert (fieldNumOff >= 0 && fieldNumOff < fieldNums.length);
                    int fgs = (int)fieldFlags.get(fieldNumOff);
                    f2.set(i4, fgs);
                }
                flags = f2;
                break;
            }
            case 1: {
                flags = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, CompressingTermVectorsWriter.FLAGS_BITS);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (int i7 = 0; i7 < numFields; ++i7) {
            fieldNumOffs[i7] = (int)allFieldNumOffs.get(skip + i7);
        }
        int bitsRequired = this.vectorsStream.readVInt();
        PackedInts.Reader numTerms = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, totalFields, bitsRequired);
        int sum = 0;
        for (i4 = 0; i4 < totalFields; ++i4) {
            sum = (int)((long)sum + numTerms.get(i4));
        }
        int totalTerms = sum;
        int docOff = 0;
        int docLen = 0;
        int[] fieldLengths = new int[numFields];
        int[][] prefixLengths = new int[numFields][];
        int[][] suffixLengths = new int[numFields][];
        this.reader.reset(this.vectorsStream, totalTerms);
        int toSkip = 0;
        for (i3 = 0; i3 < skip; ++i3) {
            toSkip = (int)((long)toSkip + numTerms.get(i3));
        }
        this.reader.skip(toSkip);
        for (i3 = 0; i3 < numFields; ++i3) {
            termCount = (int)numTerms.get(skip + i3);
            int[] fieldPrefixLengths = new int[termCount];
            prefixLengths[i3] = fieldPrefixLengths;
            j3 = 0;
            while (j3 < termCount) {
                next = this.reader.next(termCount - j3);
                for (k3 = 0; k3 < next.length; ++k3) {
                    fieldPrefixLengths[j3++] = (int)next.longs[next.offset + k3];
                }
            }
        }
        this.reader.skip((long)totalTerms - this.reader.ord());
        this.reader.reset(this.vectorsStream, totalTerms);
        toSkip = 0;
        for (i3 = 0; i3 < skip; ++i3) {
            j2 = 0;
            while ((long)j2 < numTerms.get(i3)) {
                docOff = (int)((long)docOff + this.reader.next());
                ++j2;
            }
        }
        for (i3 = 0; i3 < numFields; ++i3) {
            termCount = (int)numTerms.get(skip + i3);
            int[] fieldSuffixLengths = new int[termCount];
            suffixLengths[i3] = fieldSuffixLengths;
            j3 = 0;
            while (j3 < termCount) {
                next = this.reader.next(termCount - j3);
                for (k3 = 0; k3 < next.length; ++k3) {
                    fieldSuffixLengths[j3++] = (int)next.longs[next.offset + k3];
                }
            }
            fieldLengths[i3] = CompressingTermVectorsReader.sum(suffixLengths[i3]);
            docLen += fieldLengths[i3];
        }
        int totalLen = docOff + docLen;
        for (i3 = skip + numFields; i3 < totalFields; ++i3) {
            j2 = 0;
            while ((long)j2 < numTerms.get(i3)) {
                totalLen = (int)((long)totalLen + this.reader.next());
                ++j2;
            }
        }
        int[] termFreqs = new int[totalTerms];
        this.reader.reset(this.vectorsStream, totalTerms);
        i3 = 0;
        while (i3 < totalTerms) {
            LongsRef next2 = this.reader.next(totalTerms - i3);
            for (int k4 = 0; k4 < next2.length; ++k4) {
                termFreqs[i3++] = 1 + (int)next2.longs[next2.offset + k4];
            }
        }
        int totalPositions = 0;
        int totalOffsets = 0;
        int totalPayloads = 0;
        int termIndex = 0;
        for (int i8 = 0; i8 < totalFields; ++i8) {
            int f3 = (int)flags.get(i8);
            int termCount2 = (int)numTerms.get(i8);
            for (int j4 = 0; j4 < termCount2; ++j4) {
                int freq = termFreqs[termIndex++];
                if ((f3 & 1) != 0) {
                    totalPositions += freq;
                }
                if ((f3 & 2) != 0) {
                    totalOffsets += freq;
                }
                if ((f3 & 4) == 0) continue;
                totalPayloads += freq;
            }
            assert (i8 != totalFields - 1 || termIndex == totalTerms) : termIndex + " " + totalTerms;
        }
        int[][] positionIndex = this.positionIndex(skip, numFields, numTerms, termFreqs);
        Object positions = totalPositions > 0 ? (Object)this.readPositions(skip, numFields, flags, numTerms, termFreqs, 1, totalPositions, positionIndex) : new int[numFields][];
        if (totalOffsets > 0) {
            int i9;
            float[] charsPerTerm = new float[fieldNums.length];
            for (i9 = 0; i9 < charsPerTerm.length; ++i9) {
                charsPerTerm[i9] = Float.intBitsToFloat(this.vectorsStream.readInt());
            }
            startOffsets = this.readPositions(skip, numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            lengths = this.readPositions(skip, numFields, flags, numTerms, termFreqs, 2, totalOffsets, positionIndex);
            for (i9 = 0; i9 < numFields; ++i9) {
                int[] fStartOffsets = startOffsets[i9];
                int[] fPositions = positions[i9];
                if (fStartOffsets != null && fPositions != null) {
                    float fieldCharsPerTerm = charsPerTerm[fieldNumOffs[i9]];
                    for (int j5 = 0; j5 < startOffsets[i9].length; ++j5) {
                        int n2 = j5;
                        fStartOffsets[n2] = fStartOffsets[n2] + (int)(fieldCharsPerTerm * (float)fPositions[j5]);
                    }
                }
                if (fStartOffsets == null) continue;
                int[] fPrefixLengths = prefixLengths[i9];
                int[] fSuffixLengths = suffixLengths[i9];
                int[] fLengths = lengths[i9];
                int end = (int)numTerms.get(skip + i9);
                for (int j6 = 0; j6 < end; ++j6) {
                    int termLength = fPrefixLengths[j6] + fSuffixLengths[j6];
                    int[] nArray = lengths[i9];
                    int n3 = positionIndex[i9][j6];
                    nArray[n3] = nArray[n3] + termLength;
                    k2 = positionIndex[i9][j6] + 1;
                    while (k2 < positionIndex[i9][j6 + 1]) {
                        int n4 = k2;
                        fStartOffsets[n4] = fStartOffsets[n4] + fStartOffsets[k2 - 1];
                        int n5 = k2++;
                        fLengths[n5] = fLengths[n5] + termLength;
                    }
                }
            }
        } else {
            startOffsets = lengths = new int[numFields][];
        }
        if (totalPositions > 0) {
            for (int i10 = 0; i10 < numFields; ++i10) {
                int[] fPositions = positions[i10];
                int[] fpositionIndex = positionIndex[i10];
                if (fPositions == null) continue;
                int end = (int)numTerms.get(skip + i10);
                for (int j7 = 0; j7 < end; ++j7) {
                    for (int k5 = fpositionIndex[j7] + 1; k5 < fpositionIndex[j7 + 1]; ++k5) {
                        int n6 = k5;
                        fPositions[n6] = fPositions[n6] + fPositions[k5 - 1];
                    }
                }
            }
        }
        int[][] payloadIndex = new int[numFields][];
        int totalPayloadLength = 0;
        int payloadOff = 0;
        int payloadLen = 0;
        if (totalPayloads > 0) {
            int freq;
            int j8;
            int termCount3;
            int i11;
            this.reader.reset(this.vectorsStream, totalPayloads);
            int termIndex2 = 0;
            for (i11 = 0; i11 < skip; ++i11) {
                int f4 = (int)flags.get(i11);
                termCount3 = (int)numTerms.get(i11);
                if ((f4 & 4) != 0) {
                    for (j8 = 0; j8 < termCount3; ++j8) {
                        freq = termFreqs[termIndex2 + j8];
                        for (k2 = 0; k2 < freq; ++k2) {
                            int l2 = (int)this.reader.next();
                            payloadOff += l2;
                        }
                    }
                }
                termIndex2 += termCount3;
            }
            totalPayloadLength = payloadOff;
            for (i11 = 0; i11 < numFields; ++i11) {
                int f5 = (int)flags.get(skip + i11);
                termCount3 = (int)numTerms.get(skip + i11);
                if ((f5 & 4) != 0) {
                    int totalFreq = positionIndex[i11][termCount3];
                    payloadIndex[i11] = new int[totalFreq + 1];
                    int posIdx = 0;
                    payloadIndex[i11][posIdx] = payloadLen;
                    for (int j9 = 0; j9 < termCount3; ++j9) {
                        int freq2 = termFreqs[termIndex2 + j9];
                        for (int k6 = 0; k6 < freq2; ++k6) {
                            int payloadLength = (int)this.reader.next();
                            payloadIndex[i11][posIdx + 1] = payloadLen += payloadLength;
                            ++posIdx;
                        }
                    }
                    assert (posIdx == totalFreq);
                }
                termIndex2 += termCount3;
            }
            totalPayloadLength += payloadLen;
            for (i11 = skip + numFields; i11 < totalFields; ++i11) {
                int f6 = (int)flags.get(i11);
                termCount3 = (int)numTerms.get(i11);
                if ((f6 & 4) != 0) {
                    for (j8 = 0; j8 < termCount3; ++j8) {
                        freq = termFreqs[termIndex2 + j8];
                        for (k2 = 0; k2 < freq; ++k2) {
                            totalPayloadLength = (int)((long)totalPayloadLength + this.reader.next());
                        }
                    }
                }
                termIndex2 += termCount3;
            }
            assert (termIndex2 == totalTerms) : termIndex2 + " " + totalTerms;
        }
        BytesRef suffixBytes = new BytesRef();
        this.decompressor.decompress(this.vectorsStream, totalLen + totalPayloadLength, docOff + payloadOff, docLen + payloadLen, suffixBytes);
        suffixBytes.length = docLen;
        BytesRef payloadBytes = new BytesRef(suffixBytes.bytes, suffixBytes.offset + docLen, payloadLen);
        int[] fieldFlags = new int[numFields];
        for (int i12 = 0; i12 < numFields; ++i12) {
            fieldFlags[i12] = (int)flags.get(skip + i12);
        }
        int[] fieldNumTerms = new int[numFields];
        for (int i13 = 0; i13 < numFields; ++i13) {
            fieldNumTerms[i13] = (int)numTerms.get(skip + i13);
        }
        int[][] fieldTermFreqs = new int[numFields][];
        int termIdx = 0;
        for (i2 = 0; i2 < skip; ++i2) {
            termIdx = (int)((long)termIdx + numTerms.get(i2));
        }
        for (i2 = 0; i2 < numFields; ++i2) {
            int termCount4 = (int)numTerms.get(skip + i2);
            fieldTermFreqs[i2] = new int[termCount4];
            for (int j10 = 0; j10 < termCount4; ++j10) {
                fieldTermFreqs[i2][j10] = termFreqs[termIdx++];
            }
        }
        assert (CompressingTermVectorsReader.sum(fieldLengths) == docLen) : CompressingTermVectorsReader.sum(fieldLengths) + " != " + docLen;
        return new TVFields(fieldNums, fieldFlags, fieldNumOffs, fieldNumTerms, fieldLengths, prefixLengths, suffixLengths, fieldTermFreqs, positionIndex, (int[][])positions, (int[][])startOffsets, (int[][])lengths, payloadBytes, payloadIndex, suffixBytes);
    }

    private int[][] positionIndex(int skip, int numFields, PackedInts.Reader numTerms, int[] termFreqs) {
        int termCount;
        int i2;
        int[][] positionIndex = new int[numFields][];
        int termIndex = 0;
        for (i2 = 0; i2 < skip; ++i2) {
            termCount = (int)numTerms.get(i2);
            termIndex += termCount;
        }
        for (i2 = 0; i2 < numFields; ++i2) {
            termCount = (int)numTerms.get(skip + i2);
            positionIndex[i2] = new int[termCount + 1];
            for (int j2 = 0; j2 < termCount; ++j2) {
                int freq = termFreqs[termIndex + j2];
                positionIndex[i2][j2 + 1] = positionIndex[i2][j2] + freq;
            }
            termIndex += termCount;
        }
        return positionIndex;
    }

    private int[][] readPositions(int skip, int numFields, PackedInts.Reader flags, PackedInts.Reader numTerms, int[] termFreqs, int flag, int totalPositions, int[][] positionIndex) throws IOException {
        int termCount;
        int f2;
        int i2;
        int[][] positions = new int[numFields][];
        this.reader.reset(this.vectorsStream, totalPositions);
        int toSkip = 0;
        int termIndex = 0;
        for (i2 = 0; i2 < skip; ++i2) {
            f2 = (int)flags.get(i2);
            termCount = (int)numTerms.get(i2);
            if ((f2 & flag) != 0) {
                for (int j2 = 0; j2 < termCount; ++j2) {
                    int freq = termFreqs[termIndex + j2];
                    toSkip += freq;
                }
            }
            termIndex += termCount;
        }
        this.reader.skip(toSkip);
        for (i2 = 0; i2 < numFields; ++i2) {
            f2 = (int)flags.get(skip + i2);
            termCount = (int)numTerms.get(skip + i2);
            if ((f2 & flag) != 0) {
                int totalFreq = positionIndex[i2][termCount];
                int[] fieldPositions = new int[totalFreq];
                positions[i2] = fieldPositions;
                int j3 = 0;
                while (j3 < totalFreq) {
                    LongsRef nextPositions = this.reader.next(totalFreq - j3);
                    for (int k2 = 0; k2 < nextPositions.length; ++k2) {
                        fieldPositions[j3++] = (int)nextPositions.longs[nextPositions.offset + k2];
                    }
                }
            }
            termIndex += termCount;
        }
        this.reader.skip((long)totalPositions - this.reader.ord());
        return positions;
    }

    private static int sum(int[] arr) {
        int sum = 0;
        for (int el : arr) {
            sum += el;
        }
        return sum;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("term vector index", this.indexReader));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private static class TVPostingsEnum
    extends PostingsEnum {
        private int doc = -1;
        private int termFreq;
        private int positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private final BytesRef payload = new BytesRef();
        private int[] payloadIndex;
        private int basePayloadOffset;
        private int i;

        TVPostingsEnum() {
        }

        public void reset(int freq, int positionIndex, int[] positions, int[] startOffsets, int[] lengths, BytesRef payloads, int[] payloadIndex) {
            this.termFreq = freq;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.basePayloadOffset = payloads.offset;
            this.payload.bytes = payloads.bytes;
            this.payload.length = 0;
            this.payload.offset = 0;
            this.payloadIndex = payloadIndex;
            this.i = -1;
            this.doc = -1;
        }

        private void checkDoc() {
            if (this.doc == Integer.MAX_VALUE) {
                throw new IllegalStateException("DocsEnum exhausted");
            }
            if (this.doc == -1) {
                throw new IllegalStateException("DocsEnum not started");
            }
        }

        private void checkPosition() {
            this.checkDoc();
            if (this.i < 0) {
                throw new IllegalStateException("Position enum not started");
            }
            if (this.i >= this.termFreq) {
                throw new IllegalStateException("Read past last position");
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.doc != 0) {
                throw new IllegalStateException();
            }
            if (this.i >= this.termFreq - 1) {
                throw new IllegalStateException("Read past last position");
            }
            ++this.i;
            if (this.payloadIndex != null) {
                this.payload.offset = this.basePayloadOffset + this.payloadIndex[this.positionIndex + this.i];
                this.payload.length = this.payloadIndex[this.positionIndex + this.i + 1] - this.payloadIndex[this.positionIndex + this.i];
            }
            if (this.positions == null) {
                return -1;
            }
            return this.positions[this.positionIndex + this.i];
        }

        @Override
        public int startOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i];
        }

        @Override
        public int endOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i] + this.lengths[this.positionIndex + this.i];
        }

        @Override
        public BytesRef getPayload() throws IOException {
            this.checkPosition();
            if (this.payloadIndex == null || this.payload.length == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public int freq() throws IOException {
            this.checkDoc();
            return this.termFreq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == -1) {
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private static class TVTermsEnum
    extends TermsEnum {
        private int numTerms;
        private int startPos;
        private int ord;
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int[] termFreqs;
        private int[] positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        private ByteArrayDataInput in;
        private BytesRef payloads;
        private final BytesRef term = new BytesRef(16);

        private TVTermsEnum() {
        }

        void reset(int numTerms, int flags, int[] prefixLengths, int[] suffixLengths, int[] termFreqs, int[] positionIndex, int[] positions, int[] startOffsets, int[] lengths, int[] payloadIndex, BytesRef payloads, ByteArrayDataInput in) {
            this.numTerms = numTerms;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloads = payloads;
            this.in = in;
            this.startPos = in.getPosition();
            this.reset();
        }

        void reset() {
            this.term.length = 0;
            this.in.setPosition(this.startPos);
            this.ord = -1;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.ord == this.numTerms - 1) {
                return null;
            }
            assert (this.ord < this.numTerms);
            ++this.ord;
            this.term.offset = 0;
            this.term.length = this.prefixLengths[this.ord] + this.suffixLengths[this.ord];
            if (this.term.length > this.term.bytes.length) {
                this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
            }
            this.in.readBytes(this.term.bytes, this.prefixLengths[this.ord], this.suffixLengths[this.ord]);
            return this.term;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            int cmp;
            if (this.ord < this.numTerms && this.ord >= 0) {
                int cmp2 = this.term().compareTo(text);
                if (cmp2 == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp2 > 0) {
                    this.reset();
                }
            }
            do {
                BytesRef term;
                if ((term = this.next()) == null) {
                    return TermsEnum.SeekStatus.END;
                }
                cmp = term.compareTo(text);
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (cmp != 0);
            return TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.termFreqs[this.ord];
        }

        @Override
        public final PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            TVPostingsEnum docsEnum = reuse != null && reuse instanceof TVPostingsEnum ? (TVPostingsEnum)reuse : new TVPostingsEnum();
            docsEnum.reset(this.termFreqs[this.ord], this.positionIndex[this.ord], this.positions, this.startOffsets, this.lengths, this.payloads, this.payloadIndex);
            return docsEnum;
        }
    }

    private static class TVTerms
    extends Terms {
        private final int numTerms;
        private final int flags;
        private final int[] prefixLengths;
        private final int[] suffixLengths;
        private final int[] termFreqs;
        private final int[] positionIndex;
        private final int[] positions;
        private final int[] startOffsets;
        private final int[] lengths;
        private final int[] payloadIndex;
        private final BytesRef termBytes;
        private final BytesRef payloadBytes;

        TVTerms(int numTerms, int flags, int[] prefixLengths, int[] suffixLengths, int[] termFreqs, int[] positionIndex, int[] positions, int[] startOffsets, int[] lengths, int[] payloadIndex, BytesRef payloadBytes, BytesRef termBytes) {
            this.numTerms = numTerms;
            this.flags = flags;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadIndex = payloadIndex;
            this.payloadBytes = payloadBytes;
            this.termBytes = termBytes;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            TVTermsEnum termsEnum = new TVTermsEnum();
            termsEnum.reset(this.numTerms, this.flags, this.prefixLengths, this.suffixLengths, this.termFreqs, this.positionIndex, this.positions, this.startOffsets, this.lengths, this.payloadIndex, this.payloadBytes, new ByteArrayDataInput(this.termBytes.bytes, this.termBytes.offset, this.termBytes.length));
            return termsEnum;
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.numTerms;
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasPositions() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasPayloads() {
            return (this.flags & 4) != 0;
        }
    }

    private class TVFields
    extends Fields {
        private final int[] fieldNums;
        private final int[] fieldFlags;
        private final int[] fieldNumOffs;
        private final int[] numTerms;
        private final int[] fieldLengths;
        private final int[][] prefixLengths;
        private final int[][] suffixLengths;
        private final int[][] termFreqs;
        private final int[][] positionIndex;
        private final int[][] positions;
        private final int[][] startOffsets;
        private final int[][] lengths;
        private final int[][] payloadIndex;
        private final BytesRef suffixBytes;
        private final BytesRef payloadBytes;

        public TVFields(int[] fieldNums, int[] fieldFlags, int[] fieldNumOffs, int[] numTerms, int[] fieldLengths, int[][] prefixLengths, int[][] suffixLengths, int[][] termFreqs, int[][] positionIndex, int[][] positions, int[][] startOffsets, int[][] lengths, BytesRef payloadBytes, int[][] payloadIndex, BytesRef suffixBytes) {
            this.fieldNums = fieldNums;
            this.fieldFlags = fieldFlags;
            this.fieldNumOffs = fieldNumOffs;
            this.numTerms = numTerms;
            this.fieldLengths = fieldLengths;
            this.prefixLengths = prefixLengths;
            this.suffixLengths = suffixLengths;
            this.termFreqs = termFreqs;
            this.positionIndex = positionIndex;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.lengths = lengths;
            this.payloadBytes = payloadBytes;
            this.payloadIndex = payloadIndex;
            this.suffixBytes = suffixBytes;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < TVFields.this.fieldNumOffs.length;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int fieldNum = TVFields.this.fieldNums[TVFields.this.fieldNumOffs[this.i++]];
                    return ((CompressingTermVectorsReader)CompressingTermVectorsReader.this).fieldInfos.fieldInfo((int)fieldNum).name;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Terms terms(String field) throws IOException {
            FieldInfo fieldInfo = CompressingTermVectorsReader.this.fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                return null;
            }
            int idx = -1;
            for (int i2 = 0; i2 < this.fieldNumOffs.length; ++i2) {
                if (this.fieldNums[this.fieldNumOffs[i2]] != fieldInfo.number) continue;
                idx = i2;
                break;
            }
            if (idx == -1 || this.numTerms[idx] == 0) {
                return null;
            }
            int fieldOff = 0;
            int fieldLen = -1;
            for (int i3 = 0; i3 < this.fieldNumOffs.length; ++i3) {
                if (i3 < idx) {
                    fieldOff += this.fieldLengths[i3];
                    continue;
                }
                fieldLen = this.fieldLengths[i3];
                break;
            }
            assert (fieldLen >= 0);
            return new TVTerms(this.numTerms[idx], this.fieldFlags[idx], this.prefixLengths[idx], this.suffixLengths[idx], this.termFreqs[idx], this.positionIndex[idx], this.positions[idx], this.startOffsets[idx], this.lengths[idx], this.payloadIndex[idx], this.payloadBytes, new BytesRef(this.suffixBytes.bytes, this.suffixBytes.offset + fieldOff, fieldLen));
        }

        @Override
        public int size() {
            return this.fieldNumOffs.length;
        }
    }
}

