/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.idversion.IDVersionPostingsReader;
import org.apache.lucene.codecs.idversion.IDVersionPostingsWriter;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsReader;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class IDVersionPostingsFormat
extends PostingsFormat {
    public static final long MIN_VERSION = 0L;
    public static final long MAX_VERSION = 0x3FFFFFFFFFFFFFFFL;
    private final int minTermsInBlock;
    private final int maxTermsInBlock;

    public IDVersionPostingsFormat() {
        this(25, 48);
    }

    public IDVersionPostingsFormat(int minTermsInBlock, int maxTermsInBlock) {
        super("IDVersion");
        this.minTermsInBlock = minTermsInBlock;
        this.maxTermsInBlock = maxTermsInBlock;
        BlockTreeTermsWriter.validateSettings(minTermsInBlock, maxTermsInBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        VersionBlockTreeTermsWriter versionBlockTreeTermsWriter;
        block3: {
            IDVersionPostingsWriter postingsWriter = new IDVersionPostingsWriter(state.liveDocs);
            boolean success = false;
            try {
                VersionBlockTreeTermsWriter ret = new VersionBlockTreeTermsWriter(state, postingsWriter, this.minTermsInBlock, this.maxTermsInBlock);
                success = true;
                versionBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return versionBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        VersionBlockTreeTermsReader versionBlockTreeTermsReader;
        block3: {
            IDVersionPostingsReader postingsReader = new IDVersionPostingsReader();
            boolean success = false;
            try {
                VersionBlockTreeTermsReader ret = new VersionBlockTreeTermsReader(postingsReader, state);
                success = true;
                versionBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return versionBlockTreeTermsReader;
    }

    public static long bytesToLong(BytesRef bytes) {
        return ((long)bytes.bytes[bytes.offset] & 0xFFL) << 56 | ((long)bytes.bytes[bytes.offset + 1] & 0xFFL) << 48 | ((long)bytes.bytes[bytes.offset + 2] & 0xFFL) << 40 | ((long)bytes.bytes[bytes.offset + 3] & 0xFFL) << 32 | ((long)bytes.bytes[bytes.offset + 4] & 0xFFL) << 24 | ((long)bytes.bytes[bytes.offset + 5] & 0xFFL) << 16 | ((long)bytes.bytes[bytes.offset + 6] & 0xFFL) << 8 | (long)bytes.bytes[bytes.offset + 7] & 0xFFL;
    }

    public static void longToBytes(long v2, BytesRef bytes) {
        if (v2 > 0x3FFFFFFFFFFFFFFFL || v2 < 0L) {
            throw new IllegalArgumentException("version must be >= MIN_VERSION=0 and <= MAX_VERSION=4611686018427387903 (got: " + v2 + ")");
        }
        bytes.offset = 0;
        bytes.length = 8;
        bytes.bytes[0] = (byte)(v2 >> 56);
        bytes.bytes[1] = (byte)(v2 >> 48);
        bytes.bytes[2] = (byte)(v2 >> 40);
        bytes.bytes[3] = (byte)(v2 >> 32);
        bytes.bytes[4] = (byte)(v2 >> 24);
        bytes.bytes[5] = (byte)(v2 >> 16);
        bytes.bytes[6] = (byte)(v2 >> 8);
        bytes.bytes[7] = (byte)v2;
        assert (IDVersionPostingsFormat.bytesToLong(bytes) == v2) : IDVersionPostingsFormat.bytesToLong(bytes) + " vs " + v2 + " bytes=" + bytes;
    }
}

