/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class LongRange
extends Field {
    public static final int BYTES = 8;

    public LongRange(String name, long[] min2, long[] max) {
        super(name, LongRange.getType(min2.length));
        this.setRangeValues(min2, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(long[] min2, long[] max) {
        byte[] bytes;
        LongRange.checkArgs(min2, max);
        if (min2.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min2.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min2.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        LongRange.verifyAndEncode(min2, max, bytes);
    }

    private static void checkArgs(long[] min2, long[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min2.length > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
    }

    private static byte[] encode(long[] min2, long[] max) {
        LongRange.checkArgs(min2, max);
        byte[] b2 = new byte[16 * min2.length];
        LongRange.verifyAndEncode(min2, max, b2);
        return b2;
    }

    static void verifyAndEncode(long[] min2, long[] max, byte[] bytes) {
        int d2 = 0;
        int i2 = 0;
        int j2 = min2.length * 8;
        while (d2 < min2.length) {
            if (Double.isNaN(min2[d2])) {
                throw new IllegalArgumentException("invalid min value (NaN) in LongRange");
            }
            if (Double.isNaN(max[d2])) {
                throw new IllegalArgumentException("invalid max value (NaN) in LongRange");
            }
            if (min2[d2] > max[d2]) {
                throw new IllegalArgumentException("min value (" + min2[d2] + ") is greater than max value (" + max[d2] + ")");
            }
            LongRange.encode(min2[d2], bytes, i2);
            LongRange.encode(max[d2], bytes, j2);
            ++d2;
            i2 += 8;
            j2 += 8;
        }
    }

    private static void encode(long val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes(val, bytes, offset);
    }

    public long getMin(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return LongRange.decodeMin(((BytesRef)this.fieldsData).bytes, dimension);
    }

    public long getMax(int dimension) {
        if (dimension < 0 || dimension >= this.type.pointDimensionCount() / 2) {
            throw new IllegalArgumentException("dimension request (" + dimension + ") out of bounds for field (name=" + this.name + " dimensions=" + this.type.pointDimensionCount() / 2 + "). ");
        }
        return LongRange.decodeMax(((BytesRef)this.fieldsData).bytes, dimension);
    }

    static long decodeMin(byte[] b2, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableBytesToLong(b2, offset);
    }

    static long decodeMax(byte[] b2, int dimension) {
        int offset = b2.length / 2 + dimension * 8;
        return NumericUtils.sortableBytesToLong(b2, offset);
    }

    public static Query newIntersectsQuery(String field, long[] min2, long[] max) {
        return LongRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, long[] min2, long[] max) {
        return LongRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, long[] min2, long[] max) {
        return LongRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, long[] min2, long[] max) {
        return LongRange.newRelationQuery(field, min2, max, RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, long[] min2, long[] max, RangeFieldQuery.QueryType relation) {
        LongRange.checkArgs(min2, max);
        return new RangeFieldQuery(field, LongRange.encode(min2, max), min2.length, relation){

            @Override
            protected String toString(byte[] ranges, int dimension) {
                return LongRange.toString(ranges, dimension);
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b2 = ((BytesRef)this.fieldsData).bytes;
        LongRange.toString(b2, 0);
        for (int d2 = 1; d2 < this.type.pointDimensionCount(); ++d2) {
            sb.append(' ');
            LongRange.toString(b2, d2);
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Long.toString(LongRange.decodeMin(ranges, dimension)) + " : " + Long.toString(LongRange.decodeMax(ranges, dimension)) + "]";
    }
}

