/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergeReaderWrapper;
import org.apache.lucene.index.MultiSorter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.packed.PackedLongValues;

public class MergeState {
    public final DocMap[] docMaps;
    final DocMap[] leafDocMaps;
    public final SegmentInfo segmentInfo;
    public FieldInfos mergeFieldInfos;
    public final StoredFieldsReader[] storedFieldsReaders;
    public final TermVectorsReader[] termVectorsReaders;
    public final NormsProducer[] normsProducers;
    public final DocValuesProducer[] docValuesProducers;
    public final FieldInfos[] fieldInfos;
    public final Bits[] liveDocs;
    public final FieldsProducer[] fieldsProducers;
    public final PointsReader[] pointsReaders;
    public final int[] maxDocs;
    public final InfoStream infoStream;
    public boolean needsIndexSort;

    MergeState(List<CodecReader> originalReaders, SegmentInfo segmentInfo, InfoStream infoStream) throws IOException {
        this.infoStream = infoStream;
        Sort indexSort = segmentInfo.getIndexSort();
        int numReaders = originalReaders.size();
        this.leafDocMaps = new DocMap[numReaders];
        List<CodecReader> readers = this.maybeSortReaders(originalReaders, segmentInfo);
        this.maxDocs = new int[numReaders];
        this.fieldsProducers = new FieldsProducer[numReaders];
        this.normsProducers = new NormsProducer[numReaders];
        this.storedFieldsReaders = new StoredFieldsReader[numReaders];
        this.termVectorsReaders = new TermVectorsReader[numReaders];
        this.docValuesProducers = new DocValuesProducer[numReaders];
        this.pointsReaders = new PointsReader[numReaders];
        this.fieldInfos = new FieldInfos[numReaders];
        this.liveDocs = new Bits[numReaders];
        int numDocs = 0;
        for (int i2 = 0; i2 < numReaders; ++i2) {
            CodecReader reader = readers.get(i2);
            this.maxDocs[i2] = reader.maxDoc();
            this.liveDocs[i2] = reader.getLiveDocs();
            this.fieldInfos[i2] = reader.getFieldInfos();
            this.normsProducers[i2] = reader.getNormsReader();
            if (this.normsProducers[i2] != null) {
                this.normsProducers[i2] = this.normsProducers[i2].getMergeInstance();
            }
            this.docValuesProducers[i2] = reader.getDocValuesReader();
            if (this.docValuesProducers[i2] != null) {
                this.docValuesProducers[i2] = this.docValuesProducers[i2].getMergeInstance();
            }
            this.storedFieldsReaders[i2] = reader.getFieldsReader();
            if (this.storedFieldsReaders[i2] != null) {
                this.storedFieldsReaders[i2] = this.storedFieldsReaders[i2].getMergeInstance();
            }
            this.termVectorsReaders[i2] = reader.getTermVectorsReader();
            if (this.termVectorsReaders[i2] != null) {
                this.termVectorsReaders[i2] = this.termVectorsReaders[i2].getMergeInstance();
            }
            this.fieldsProducers[i2] = reader.getPostingsReader().getMergeInstance();
            this.pointsReaders[i2] = reader.getPointsReader();
            if (this.pointsReaders[i2] != null) {
                this.pointsReaders[i2] = this.pointsReaders[i2].getMergeInstance();
            }
            numDocs += reader.numDocs();
        }
        segmentInfo.setMaxDoc(numDocs);
        this.segmentInfo = segmentInfo;
        this.docMaps = this.buildDocMaps(readers, indexSort);
    }

    private DocMap[] buildDeletionDocMaps(List<CodecReader> readers) {
        int totalDocs = 0;
        int numReaders = readers.size();
        DocMap[] docMaps = new DocMap[numReaders];
        for (int i2 = 0; i2 < numReaders; ++i2) {
            LeafReader reader = readers.get(i2);
            final Bits liveDocs = reader.getLiveDocs();
            final PackedLongValues delDocMap = liveDocs != null ? MergeState.removeDeletes(reader.maxDoc(), liveDocs) : null;
            final int docBase = totalDocs;
            docMaps[i2] = new DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null) {
                        return docBase + docID;
                    }
                    if (liveDocs.get(docID)) {
                        return docBase + (int)delDocMap.get(docID);
                    }
                    return -1;
                }
            };
            totalDocs += reader.numDocs();
        }
        return docMaps;
    }

    private DocMap[] buildDocMaps(List<CodecReader> readers, Sort indexSort) throws IOException {
        if (indexSort == null) {
            return this.buildDeletionDocMaps(readers);
        }
        long t0 = System.nanoTime();
        DocMap[] result = MultiSorter.sort(indexSort, readers);
        if (result == null) {
            return this.buildDeletionDocMaps(readers);
        }
        this.needsIndexSort = true;
        long t1 = System.nanoTime();
        if (this.infoStream.isEnabled("SM")) {
            this.infoStream.message("SM", String.format(Locale.ROOT, "%.2f msec to build merge sorted DocMaps", (double)(t1 - t0) / 1000000.0));
        }
        return result;
    }

    private List<CodecReader> maybeSortReaders(List<CodecReader> originalReaders, SegmentInfo segmentInfo) throws IOException {
        for (int i2 = 0; i2 < originalReaders.size(); ++i2) {
            this.leafDocMaps[i2] = new DocMap(){

                @Override
                public int get(int docID) {
                    return docID;
                }
            };
        }
        Sort indexSort = segmentInfo.getIndexSort();
        if (indexSort == null) {
            return originalReaders;
        }
        Sorter sorter = new Sorter(indexSort);
        ArrayList<CodecReader> readers = new ArrayList<CodecReader>(originalReaders.size());
        for (CodecReader leaf : originalReaders) {
            Sort segmentSort = leaf.getMetaData().getSort();
            if (segmentSort == null) {
                long t0 = System.nanoTime();
                final Sorter.DocMap sortDocMap = sorter.sort(leaf);
                long t1 = System.nanoTime();
                double msec = (double)(t1 - t0) / 1000000.0;
                if (sortDocMap != null) {
                    if (this.infoStream.isEnabled("SM")) {
                        this.infoStream.message("SM", String.format(Locale.ROOT, "segment %s is not sorted; wrapping for sort %s now (%.2f msec to sort)", leaf, indexSort, msec));
                    }
                    this.needsIndexSort = true;
                    leaf = SlowCodecReaderWrapper.wrap(SortingLeafReader.wrap((LeafReader)new MergeReaderWrapper(leaf), sortDocMap));
                    this.leafDocMaps[readers.size()] = new DocMap(){

                        @Override
                        public int get(int docID) {
                            return sortDocMap.oldToNew(docID);
                        }
                    };
                } else if (this.infoStream.isEnabled("SM")) {
                    this.infoStream.message("SM", String.format(Locale.ROOT, "segment %s is not sorted, but is already accidentally in sort %s order (%.2f msec to sort)", leaf, indexSort, msec));
                }
            } else {
                if (!segmentSort.equals(indexSort)) {
                    throw new IllegalArgumentException("index sort mismatch: merged segment has sort=" + indexSort + " but to-be-merged segment has sort=" + segmentSort);
                }
                if (this.infoStream.isEnabled("SM")) {
                    this.infoStream.message("SM", "segment " + leaf + " already sorted");
                }
            }
            readers.add(leaf);
        }
        return readers;
    }

    static PackedLongValues removeDeletes(int maxDoc, Bits liveDocs) {
        PackedLongValues.Builder docMapBuilder = PackedLongValues.monotonicBuilder(0.0f);
        int del = 0;
        for (int i2 = 0; i2 < maxDoc; ++i2) {
            docMapBuilder.add(i2 - del);
            if (liveDocs.get(i2)) continue;
            ++del;
        }
        return docMapBuilder.build();
    }

    public static abstract class DocMap {
        public abstract int get(int var1);
    }
}

