/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.util.Bits;

final class MultiBits
implements Bits {
    private final Bits[] subs;
    private final int[] starts;
    private final boolean defaultValue;

    public MultiBits(Bits[] subs, int[] starts, boolean defaultValue) {
        assert (starts.length == 1 + subs.length);
        this.subs = subs;
        this.starts = starts;
        this.defaultValue = defaultValue;
    }

    private boolean checkLength(int reader, int doc) {
        int length = this.starts[1 + reader] - this.starts[reader];
        assert (doc - this.starts[reader] < length) : "doc=" + doc + " reader=" + reader + " starts[reader]=" + this.starts[reader] + " length=" + length;
        return true;
    }

    @Override
    public boolean get(int doc) {
        int reader = ReaderUtil.subIndex(doc, this.starts);
        assert (reader != -1);
        Bits bits = this.subs[reader];
        if (bits == null) {
            return this.defaultValue;
        }
        assert (this.checkLength(reader, doc));
        return bits.get(doc - this.starts[reader]);
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append(this.subs.length + " subs: ");
        for (int i2 = 0; i2 < this.subs.length; ++i2) {
            if (i2 != 0) {
                b2.append("; ");
            }
            if (this.subs[i2] == null) {
                b2.append("s=" + this.starts[i2] + " l=null");
                continue;
            }
            b2.append("s=" + this.starts[i2] + " l=" + this.subs[i2].length() + " b=" + this.subs[i2]);
        }
        b2.append(" end=" + this.starts[this.subs.length]);
        return b2.toString();
    }

    public SubResult getMatchingSub(ReaderSlice slice) {
        int reader = ReaderUtil.subIndex(slice.start, this.starts);
        assert (reader != -1);
        assert (reader < this.subs.length) : "slice=" + slice + " starts[-1]=" + this.starts[this.starts.length - 1];
        SubResult subResult = new SubResult();
        if (this.starts[reader] == slice.start && this.starts[1 + reader] == slice.start + slice.length) {
            subResult.matches = true;
            subResult.result = this.subs[reader];
        } else {
            subResult.matches = false;
        }
        return subResult;
    }

    @Override
    public int length() {
        return this.starts[this.starts.length - 1];
    }

    public static final class SubResult {
        public boolean matches;
        public Bits result;
    }
}

