/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.IndexReader;

public class MultiReader
extends BaseCompositeReader<IndexReader> {
    private final boolean closeSubReaders;

    public MultiReader(IndexReader ... subReaders) throws IOException {
        this(subReaders, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) throws IOException {
        super((IndexReader[])subReaders.clone());
        this.closeSubReaders = closeSubReaders;
        if (!closeSubReaders) {
            for (int i2 = 0; i2 < subReaders.length; ++i2) {
                subReaders[i2].incRef();
            }
        }
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        if (this.getSequentialSubReaders().size() == 1) {
            return ((IndexReader)this.getSequentialSubReaders().get(0)).getReaderCacheHelper();
        }
        return null;
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (IndexReader r2 : this.getSequentialSubReaders()) {
            try {
                if (this.closeSubReaders) {
                    r2.close();
                    continue;
                }
                r2.decRef();
            }
            catch (IOException e2) {
                if (ioe != null) continue;
                ioe = e2;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

